/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Hashtable;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.accessibility.gtk.ATK;
import org.eclipse.swt.internal.accessibility.gtk.AtkActionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkComponentIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkHypertextIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkObjectFactoryClass;
import org.eclipse.swt.internal.accessibility.gtk.AtkSelectionIface;
import org.eclipse.swt.internal.accessibility.gtk.AtkTextIface;
import org.eclipse.swt.internal.gtk.GInterfaceInfo;
import org.eclipse.swt.internal.gtk.GObjectClass;
import org.eclipse.swt.internal.gtk.GTypeInfo;
import org.eclipse.swt.internal.gtk.GTypeQuery;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;

class AccessibleFactory {
    int handle;
    int objectParentType;
    int widgetTypeName;
    Callback atkObjectFactoryCB_create_accessible;
    Callback gTypeInfo_base_init_factory;
    Hashtable accessibles = new Hashtable(9);
    static final Hashtable Types = new Hashtable(9);
    static final Hashtable Factories = new Hashtable(9);
    static final int DefaultParentType = OS.g_type_from_name(Converter.wcsToMbcs(null, "GtkAccessible", true));
    static final byte[] FACTORY_PARENTTYPENAME = Converter.wcsToMbcs(null, "AtkObjectFactory", true);
    static final byte[] SWT_TYPE_PREFIX = Converter.wcsToMbcs(null, "SWT", false);
    static final byte[] CHILD_TYPENAME = Converter.wcsToMbcs(null, "Child", false);
    static final byte[] FACTORY_TYPENAME = Converter.wcsToMbcs(null, "SWTFactory", true);
    static final int[] actionRoles = new int[]{44, 46, 30, 12, 43, 45};
    static final int[] hypertextRoles = new int[]{30};
    static final int[] selectionRoles = new int[]{33, 60, 24, 35};
    static final int[] textRoles = new int[]{46, 30, 41, 42};
    static final Callback AtkActionCB_get_keybinding = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_keybinding", 2);
    static final Callback AtkActionCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkAction_get_name", 2);
    static final Callback AtkComponentCB_get_extents = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_extents", 6);
    static final Callback AtkComponentCB_get_position = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_position", 4);
    static final Callback AtkComponentCB_get_size = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_get_size", 4);
    static final Callback AtkComponentCB_ref_accessible_at_point = AccessibleFactory.newCallback(AccessibleObject.class, "atkComponent_ref_accessible_at_point", 4);
    static final Callback AtkHypertextCB_get_link = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link", 2);
    static final Callback AtkHypertextCB_get_n_links = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_n_links", 1);
    static final Callback AtkHypertextCB_get_link_index = AccessibleFactory.newCallback(AccessibleObject.class, "atkHypertext_get_link_index", 2);
    static final Callback AtkObjectCB_get_description;
    static final Callback AtkObjectCB_get_index_in_parent;
    static final Callback AtkObjectCB_get_n_children;
    static final Callback AtkObjectCB_get_name;
    static final Callback AtkObjectCB_get_parent;
    static final Callback AtkObjectCB_get_role;
    static final Callback AtkObjectCB_ref_child;
    static final Callback AtkObjectCB_ref_state_set;
    static final Callback AtkSelectionCB_is_child_selected;
    static final Callback AtkSelectionCB_ref_selection;
    static final Callback AtkTextCB_get_caret_offset;
    static final Callback AtkTextCB_get_n_selections;
    static final Callback AtkTextCB_get_selection;
    static final Callback AtkTextCB_get_text;
    static final Callback AtkTextCB_get_text_after_offset;
    static final Callback AtkTextCB_get_text_at_offset;
    static final Callback AtkTextCB_get_text_before_offset;
    static final Callback AtkTextCB_get_character_at_offset;
    static final Callback AtkTextCB_get_character_count;
    static final Callback GObjectClass_finalize;
    static final Callback InitActionIfaceCB;
    static final Callback InitComponentIfaceCB;
    static final Callback InitHypertextIfaceCB;
    static final Callback GTypeInfo_base_init_type;
    static final Callback InitSelectionIfaceCB;
    static final Callback InitTextIfaceCB;
    static int ObjectIfaceDefinition;
    static final int ActionIfaceDefinition;
    static final int ComponentIfaceDefinition;
    static final int HypertextIfaceDefinition;
    static final int SelectionIfaceDefinition;
    static final int TextIfaceDefinition;

    static {
        AtkObjectCB_get_name = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_name", 1);
        AtkObjectCB_get_description = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_description", 1);
        AtkObjectCB_get_n_children = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_n_children", 1);
        AtkObjectCB_get_role = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_role", 1);
        AtkObjectCB_get_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_parent", 1);
        AtkObjectCB_ref_state_set = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_state_set", 1);
        AtkObjectCB_get_index_in_parent = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_get_index_in_parent", 1);
        AtkObjectCB_ref_child = AccessibleFactory.newCallback(AccessibleObject.class, "atkObject_ref_child", 2);
        AtkSelectionCB_is_child_selected = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_is_child_selected", 2);
        AtkSelectionCB_ref_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkSelection_ref_selection", 2);
        AtkTextCB_get_caret_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_caret_offset", 1);
        AtkTextCB_get_n_selections = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_n_selections", 1);
        AtkTextCB_get_selection = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_selection", 4);
        AtkTextCB_get_text = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text", 3);
        AtkTextCB_get_text_after_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_after_offset", 5);
        AtkTextCB_get_text_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_at_offset", 5);
        AtkTextCB_get_text_before_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_text_before_offset", 5);
        AtkTextCB_get_character_at_offset = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_at_offset", 2);
        AtkTextCB_get_character_count = AccessibleFactory.newCallback(AccessibleObject.class, "atkText_get_character_count", 1);
        GObjectClass_finalize = AccessibleFactory.newCallback(AccessibleObject.class, "gObjectClass_finalize", 1);
        GTypeInfo_base_init_type = AccessibleFactory.newCallback(AccessibleFactory.class, "gTypeInfo_base_init_type", 1);
        InitActionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initActionIfaceCB", 1);
        GInterfaceInfo interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitActionIfaceCB.getAddress();
        ActionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ActionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitComponentIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initComponentIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitComponentIfaceCB.getAddress();
        ComponentIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(ComponentIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitHypertextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initHypertextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitHypertextIfaceCB.getAddress();
        HypertextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(HypertextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitSelectionIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initSelectionIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitSelectionIfaceCB.getAddress();
        SelectionIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(SelectionIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
        InitTextIfaceCB = AccessibleFactory.newCallback(AccessibleFactory.class, "initTextIfaceCB", 1);
        interfaceInfo = new GInterfaceInfo();
        interfaceInfo.interface_init = InitTextIfaceCB.getAddress();
        TextIfaceDefinition = OS.g_malloc(GInterfaceInfo.sizeof);
        OS.memmove(TextIfaceDefinition, interfaceInfo, GInterfaceInfo.sizeof);
    }

    private static Callback newCallback(Object object, String method, int argCount) {
        Callback callback = new Callback(object, method, argCount);
        if (callback.getAddress() == 0) {
            SWT.error(3);
        }
        return callback;
    }

    private AccessibleFactory(int widgetType) {
        this.widgetTypeName = OS.g_type_name(widgetType);
        int widgetTypeNameLength = OS.strlen(this.widgetTypeName) + 1;
        byte[] buffer = new byte[widgetTypeNameLength];
        OS.memmove(buffer, this.widgetTypeName, widgetTypeNameLength);
        byte[] factoryName = new byte[FACTORY_TYPENAME.length + widgetTypeNameLength - 1];
        System.arraycopy(FACTORY_TYPENAME, 0, factoryName, 0, FACTORY_TYPENAME.length);
        System.arraycopy(buffer, 0, factoryName, FACTORY_TYPENAME.length - 1, widgetTypeNameLength);
        if (OS.g_type_from_name(factoryName) == 0) {
            int registry = ATK.atk_get_default_registry();
            int previousFactory = ATK.atk_registry_get_factory(registry, widgetType);
            this.objectParentType = ATK.atk_object_factory_get_accessible_type(previousFactory);
            if (this.objectParentType == 0) {
                this.objectParentType = DefaultParentType;
            }
            int factoryParentType = OS.g_type_from_name(FACTORY_PARENTTYPENAME);
            this.gTypeInfo_base_init_factory = new Callback(this, "gTypeInfo_base_init_factory", 1);
            int address = this.gTypeInfo_base_init_factory.getAddress();
            if (address == 0) {
                SWT.error(3);
            }
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = address;
            typeInfo.class_size = (short)ATK.AtkObjectFactoryClass_sizeof();
            typeInfo.instance_size = (short)ATK.AtkObjectFactory_sizeof();
            int info = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(info, typeInfo, GTypeInfo.sizeof);
            int swtFactoryType = OS.g_type_register_static(factoryParentType, factoryName, info, 0);
            ATK.atk_registry_set_factory_type(registry, widgetType, swtFactoryType);
            this.handle = ATK.atk_registry_get_factory(registry, widgetType);
        }
    }

    void addAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        this.accessibles.put(new LONG(controlHandle), accessible);
        ATK.atk_object_factory_create_accessible(this.handle, controlHandle);
    }

    int atkObjectFactory_create_accessible(int widget) {
        AccessibleObject object;
        Accessible accessible = (Accessible)this.accessibles.get(new LONG(widget));
        if (accessible == null) {
            int result = OS.g_object_new(this.objectParentType, 0);
            ATK.atk_object_initialize(result, widget);
            return result;
        }
        if (accessible.accessibleObject != null) {
            return accessible.accessibleObject.handle;
        }
        int typeNameLength = OS.strlen(this.widgetTypeName);
        byte[] buffer = new byte[typeNameLength];
        OS.memmove(buffer, this.widgetTypeName, typeNameLength);
        int type = AccessibleFactory.getType(buffer, accessible, this.objectParentType, -1);
        accessible.accessibleObject = object = new AccessibleObject(type, widget, accessible, this.objectParentType, false);
        return object.handle;
    }

    static int getChildType(Accessible accessible, int childIndex) {
        return AccessibleFactory.getType(CHILD_TYPENAME, accessible, DefaultParentType, childIndex);
    }

    static int getDefaultParentType() {
        return DefaultParentType;
    }

    static int getType(byte[] widgetTypeName, Accessible accessible, int parentType, int childId) {
        AccessibleControlEvent event = new AccessibleControlEvent(accessible);
        event.childID = childId;
        AccessibleControlListener[] listeners = accessible.getControlListeners();
        int i = 0;
        while (i < listeners.length) {
            listeners[i].getRole(event);
            ++i;
        }
        boolean action = false;
        boolean hypertext = false;
        boolean selection = false;
        boolean text = false;
        if (event.detail != 0) {
            int i2 = 0;
            while (i2 < actionRoles.length) {
                if (event.detail == actionRoles[i2]) {
                    action = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < hypertextRoles.length) {
                if (event.detail == hypertextRoles[i2]) {
                    hypertext = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < selectionRoles.length) {
                if (event.detail == selectionRoles[i2]) {
                    selection = true;
                    break;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < textRoles.length) {
                if (event.detail == textRoles[i2]) {
                    text = true;
                    break;
                }
                ++i2;
            }
        } else {
            text = true;
            selection = true;
            hypertext = true;
            action = true;
        }
        String swtTypeName = new String(SWT_TYPE_PREFIX);
        swtTypeName = String.valueOf(swtTypeName) + new String(widgetTypeName);
        if (action) {
            swtTypeName = String.valueOf(swtTypeName) + "Action";
        }
        if (hypertext) {
            swtTypeName = String.valueOf(swtTypeName) + "Hypertext";
        }
        if (selection) {
            swtTypeName = String.valueOf(swtTypeName) + "Selection";
        }
        if (text) {
            swtTypeName = String.valueOf(swtTypeName) + "Text";
        }
        int type = 0;
        LONG typeInt = (LONG)Types.get(swtTypeName);
        if (typeInt != null) {
            type = typeInt.value;
        } else {
            int queryPtr = OS.g_malloc(GTypeQuery.sizeof);
            OS.g_type_query(parentType, queryPtr);
            GTypeQuery query = new GTypeQuery();
            OS.memmove(query, queryPtr, GTypeQuery.sizeof);
            OS.g_free(queryPtr);
            GTypeInfo typeInfo = new GTypeInfo();
            typeInfo.base_init = GTypeInfo_base_init_type.getAddress();
            typeInfo.class_size = (short)query.class_size;
            typeInfo.instance_size = (short)query.instance_size;
            ObjectIfaceDefinition = OS.g_malloc(GTypeInfo.sizeof);
            OS.memmove(ObjectIfaceDefinition, typeInfo, GTypeInfo.sizeof);
            byte[] nameBytes = new byte[swtTypeName.length() + 1];
            System.arraycopy(swtTypeName.getBytes(), 0, nameBytes, 0, swtTypeName.length());
            type = OS.g_type_register_static(parentType, nameBytes, ObjectIfaceDefinition, 0);
            OS.g_type_add_interface_static(type, AccessibleObject.ATK_COMPONENT_TYPE, ComponentIfaceDefinition);
            if (action) {
                OS.g_type_add_interface_static(type, AccessibleObject.ATK_ACTION_TYPE, ActionIfaceDefinition);
            }
            if (hypertext) {
                OS.g_type_add_interface_static(type, AccessibleObject.ATK_HYPERTEXT_TYPE, HypertextIfaceDefinition);
            }
            if (selection) {
                OS.g_type_add_interface_static(type, AccessibleObject.ATK_SELECTION_TYPE, SelectionIfaceDefinition);
            }
            if (text) {
                OS.g_type_add_interface_static(type, AccessibleObject.ATK_TEXT_TYPE, TextIfaceDefinition);
            }
            Types.put(swtTypeName, new LONG(type));
        }
        return type;
    }

    int gTypeInfo_base_init_factory(int klass) {
        int atkObjectFactoryClass = ATK.ATK_OBJECT_FACTORY_CLASS(klass);
        AtkObjectFactoryClass objectFactoryClassStruct = new AtkObjectFactoryClass();
        ATK.memmove(objectFactoryClassStruct, atkObjectFactoryClass);
        this.atkObjectFactoryCB_create_accessible = new Callback(this, "atkObjectFactory_create_accessible", 1);
        int address = this.atkObjectFactoryCB_create_accessible.getAddress();
        if (address == 0) {
            SWT.error(3);
        }
        objectFactoryClassStruct.create_accessible = address;
        ATK.memmove(atkObjectFactoryClass, objectFactoryClassStruct);
        return 0;
    }

    static int gTypeInfo_base_init_type(int klass) {
        AtkObjectClass objectClass = new AtkObjectClass();
        ATK.memmove(objectClass, klass);
        objectClass.get_name = AtkObjectCB_get_name.getAddress();
        objectClass.get_description = AtkObjectCB_get_description.getAddress();
        objectClass.get_n_children = AtkObjectCB_get_n_children.getAddress();
        objectClass.get_role = AtkObjectCB_get_role.getAddress();
        objectClass.get_parent = AtkObjectCB_get_parent.getAddress();
        objectClass.ref_state_set = AtkObjectCB_ref_state_set.getAddress();
        objectClass.get_index_in_parent = AtkObjectCB_get_index_in_parent.getAddress();
        objectClass.ref_child = AtkObjectCB_ref_child.getAddress();
        int gObjectClass = OS.G_OBJECT_CLASS(klass);
        GObjectClass objectClassStruct = new GObjectClass();
        OS.memmove(objectClassStruct, gObjectClass);
        objectClassStruct.finalize = GObjectClass_finalize.getAddress();
        OS.memmove(gObjectClass, objectClassStruct);
        ATK.memmove(klass, objectClass);
        return 0;
    }

    static int initActionIfaceCB(int iface) {
        AtkActionIface actionIface = new AtkActionIface();
        ATK.memmove(actionIface, iface);
        actionIface.get_keybinding = AtkActionCB_get_keybinding.getAddress();
        actionIface.get_name = AtkActionCB_get_name.getAddress();
        ATK.memmove(iface, actionIface);
        return 0;
    }

    static int initComponentIfaceCB(int iface) {
        AtkComponentIface componentIface = new AtkComponentIface();
        ATK.memmove(componentIface, iface);
        componentIface.get_extents = AtkComponentCB_get_extents.getAddress();
        componentIface.get_position = AtkComponentCB_get_position.getAddress();
        componentIface.get_size = AtkComponentCB_get_size.getAddress();
        componentIface.ref_accessible_at_point = AtkComponentCB_ref_accessible_at_point.getAddress();
        ATK.memmove(iface, componentIface);
        return 0;
    }

    static int initHypertextIfaceCB(int iface) {
        AtkHypertextIface hypertextIface = new AtkHypertextIface();
        ATK.memmove(hypertextIface, iface);
        hypertextIface.get_link = AtkHypertextCB_get_link.getAddress();
        hypertextIface.get_link_index = AtkHypertextCB_get_link_index.getAddress();
        hypertextIface.get_n_links = AtkHypertextCB_get_n_links.getAddress();
        ATK.memmove(iface, hypertextIface);
        return 0;
    }

    static int initSelectionIfaceCB(int iface) {
        AtkSelectionIface selectionIface = new AtkSelectionIface();
        ATK.memmove(selectionIface, iface);
        selectionIface.is_child_selected = AtkSelectionCB_is_child_selected.getAddress();
        selectionIface.ref_selection = AtkSelectionCB_ref_selection.getAddress();
        ATK.memmove(iface, selectionIface);
        return 0;
    }

    static int initTextIfaceCB(int iface) {
        AtkTextIface textInterface = new AtkTextIface();
        ATK.memmove(textInterface, iface);
        textInterface.get_caret_offset = AtkTextCB_get_caret_offset.getAddress();
        textInterface.get_character_at_offset = AtkTextCB_get_character_at_offset.getAddress();
        textInterface.get_character_count = AtkTextCB_get_character_count.getAddress();
        textInterface.get_n_selections = AtkTextCB_get_n_selections.getAddress();
        textInterface.get_selection = AtkTextCB_get_selection.getAddress();
        textInterface.get_text = AtkTextCB_get_text.getAddress();
        textInterface.get_text_after_offset = AtkTextCB_get_text_after_offset.getAddress();
        textInterface.get_text_at_offset = AtkTextCB_get_text_at_offset.getAddress();
        textInterface.get_text_before_offset = AtkTextCB_get_text_before_offset.getAddress();
        ATK.memmove(iface, textInterface);
        return 0;
    }

    static void registerAccessible(Accessible accessible) {
        if (DefaultParentType == 0) {
            return;
        }
        int controlHandle = accessible.getControlHandle();
        int widgetType = OS.G_OBJECT_TYPE(controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory == null) {
            factory = new AccessibleFactory(widgetType);
            Factories.put(new LONG(widgetType), factory);
        }
        factory.addAccessible(accessible);
    }

    void removeAccessible(Accessible accessible) {
        this.accessibles.remove(new LONG(accessible.getControlHandle()));
    }

    static void unregisterAccessible(Accessible accessible) {
        int controlHandle = accessible.getControlHandle();
        int widgetType = OS.G_OBJECT_TYPE(controlHandle);
        AccessibleFactory factory = (AccessibleFactory)Factories.get(new LONG(widgetType));
        if (factory != null) {
            factory.removeAccessible(accessible);
        }
    }
}

