/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.launcher;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.junit.launcher.ITestFinder;
import org.eclipse.jdt.internal.junit.launcher.JUnit3TestFinder;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;

public class JUnit4TestFinder
implements ITestFinder {
    private JUnit3TestFinder fJUnit3TestFinder = new JUnit3TestFinder();

    public void findTestsInContainer(Object[] elements, Set result, IProgressMonitor pm) {
        try {
            int i = 0;
            while (i < elements.length) {
                Object container = TestSearchEngine.computeScope(elements[i]);
                if (container instanceof IJavaProject) {
                    IJavaProject project = (IJavaProject)container;
                    this.findTestsInProject(project, result);
                } else if (container instanceof IPackageFragmentRoot) {
                    IPackageFragmentRoot root = (IPackageFragmentRoot)container;
                    this.findTestsInPackageFragmentRoot(root, result);
                } else if (container instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)container;
                    this.findTestsInPackageFragment(fragment, result);
                } else if (container instanceof ICompilationUnit) {
                    ICompilationUnit cu = (ICompilationUnit)container;
                    this.findTestsInCompilationUnit(cu, result);
                } else if (container instanceof IType) {
                    IType type = (IType)container;
                    this.findTestsInType(type, result);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {}
    }

    private void findTestsInProject(IJavaProject project, Set result) throws JavaModelException {
        IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            this.findTestsInPackageFragmentRoot(root, result);
            ++i;
        }
    }

    private void findTestsInPackageFragmentRoot(IPackageFragmentRoot root, Set result) throws JavaModelException {
        IJavaElement[] children = root.getChildren();
        int j = 0;
        while (j < children.length) {
            IPackageFragment fragment = (IPackageFragment)children[j];
            this.findTestsInPackageFragment(fragment, result);
            ++j;
        }
    }

    private void findTestsInPackageFragment(IPackageFragment fragment, Set result) throws JavaModelException {
        ICompilationUnit[] compilationUnits = fragment.getCompilationUnits();
        int k = 0;
        while (k < compilationUnits.length) {
            ICompilationUnit unit = compilationUnits[k];
            this.findTestsInCompilationUnit(unit, result);
            ++k;
        }
    }

    private void findTestsInCompilationUnit(ICompilationUnit unit, Set result) throws JavaModelException {
        IType[] types = unit.getAllTypes();
        int l = 0;
        while (l < types.length) {
            IType type = types[l];
            this.findTestsInType(type, result);
            ++l;
        }
    }

    private void findTestsInType(IType type, Set result) throws JavaModelException {
        if (this.isTest(type)) {
            result.add(type);
        }
    }

    public boolean isTest(IType type) throws JavaModelException {
        if (!Flags.isAbstract((int)type.getFlags())) {
            if (Annotation.RUN_WITH.annotates((IMember)type) || Annotation.TEST.annotatesAtLeastOneMethod(type)) {
                return true;
            }
            return this.fJUnit3TestFinder.isTest(type);
        }
        return false;
    }

    private static class Annotation {
        private static final Annotation RUN_WITH = new Annotation(new String[]{"RunWith", "org.junit.runner.RunWith"});
        private static final Annotation TEST = new Annotation(new String[]{"Test", "org.junit.Test"});
        private final String[] names;

        private Annotation(String[] names) {
            this.names = names;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean foundIn(String source) {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)true, (boolean)false, (boolean)false);
            scanner.setSource(source.toCharArray());
            try {
                int tok;
                do {
                    if ((tok = scanner.getNextToken()) != 401) continue;
                    String annotationName = "";
                    tok = scanner.getNextToken();
                    while (tok == 5 || tok == 6) {
                        annotationName = String.valueOf(annotationName) + String.valueOf(scanner.getCurrentTokenSource());
                        tok = scanner.getNextToken();
                    }
                    int i = 0;
                    while (i < this.names.length) {
                        String annotation = this.names[i];
                        if (annotationName.equals(annotation)) {
                            return true;
                        }
                        ++i;
                    }
                } while (tok != 158);
                return false;
            }
            catch (InvalidInputException invalidInputException) {
                return false;
            }
        }

        boolean annotates(IMember member) throws JavaModelException {
            ISourceRange sourceRange = member.getSourceRange();
            ISourceRange nameRange = member.getNameRange();
            int charsToSearch = nameRange.getOffset() - sourceRange.getOffset();
            String source = member.getSource().substring(0, charsToSearch);
            return this.foundIn(source);
        }

        boolean annotatesAtLeastOneMethod(IType type) throws JavaModelException {
            IMethod[] methods = type.getMethods();
            int i = 0;
            while (i < methods.length) {
                if (this.annotates((IMember)methods[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }
}

