/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Collection;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.GetterSetterUtil;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.java.JavaTextMessages;
import org.eclipse.jdt.internal.ui.text.java.JavaTypeCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;

public class GetterSetterCompletionProposal
extends JavaTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private final IField fField;
    private final boolean fIsGetter;

    public static void evaluateProposals(IType type, String prefix, int offset, int length, int relevance, Set suggestedMethods, Collection result) throws CoreException {
        if (prefix.length() == 0) {
            --relevance;
        }
        IField[] fields = type.getFields();
        IMethod[] methods = type.getMethods();
        int i = 0;
        while (i < fields.length) {
            IField curr = fields[i];
            if (!JdtFlags.isEnum((IMember)curr)) {
                String setterName;
                String getterName = GetterSetterUtil.getGetterName(curr, null);
                if (getterName.startsWith(prefix) && !GetterSetterCompletionProposal.hasMethod(methods, getterName) && suggestedMethods.add(getterName)) {
                    result.add(new GetterSetterCompletionProposal(curr, offset, length, true, relevance));
                }
                if ((setterName = GetterSetterUtil.getSetterName(curr, null)).startsWith(prefix) && !GetterSetterCompletionProposal.hasMethod(methods, setterName) && suggestedMethods.add(setterName)) {
                    result.add(new GetterSetterCompletionProposal(curr, offset, length, false, relevance));
                }
            }
            ++i;
        }
    }

    private static boolean hasMethod(IMethod[] methods, String name) {
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getElementName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public GetterSetterCompletionProposal(IField field, int start, int length, boolean isGetter, int relevance) throws JavaModelException {
        super("", field.getCompilationUnit(), start, length, JavaPluginImages.get("org.eclipse.jdt.ui.methpub_obj.gif"), GetterSetterCompletionProposal.getDisplayName(field, isGetter), relevance);
        Assert.isNotNull((Object)field);
        this.fField = field;
        this.fIsGetter = isGetter;
        this.setProposalInfo(new ProposalInfo((IMember)field));
    }

    private static String getDisplayName(IField field, boolean isGetter) throws JavaModelException {
        StringBuffer buf = new StringBuffer();
        if (isGetter) {
            buf.append(GetterSetterUtil.getGetterName(field, null));
            buf.append("()  ");
            buf.append(Signature.toString((String)field.getTypeSignature()));
            buf.append(" - ");
            buf.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_getter_label, field.getElementName()));
        } else {
            buf.append(GetterSetterUtil.getSetterName(field, null));
            buf.append('(').append(Signature.toString((String)field.getTypeSignature())).append(')');
            buf.append("  ");
            buf.append(Signature.toString((String)"V"));
            buf.append(" - ");
            buf.append(Messages.format(JavaTextMessages.GetterSetterCompletionProposal_setter_label, field.getElementName()));
        }
        return buf.toString();
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset, ImportRewrite impRewrite) throws CoreException, BadLocationException {
        String stub;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.fField.getJavaProject());
        boolean addComments = settings.createComments;
        int flags = 1 | this.fField.getFlags() & 8;
        if (this.fIsGetter) {
            String getterName = GetterSetterUtil.getGetterName(this.fField, null);
            stub = GetterSetterUtil.getGetterStub(this.fField, getterName, addComments, flags);
        } else {
            String setterName = GetterSetterUtil.getSetterName(this.fField, null);
            stub = GetterSetterUtil.getSetterStub(this.fField, setterName, addComments, flags);
        }
        String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
        IRegion region = document.getLineInformationOfOffset(this.getReplacementOffset());
        int lineStart = region.getOffset();
        int indent = Strings.computeIndentUnits(document.get(lineStart, this.getReplacementOffset() - lineStart), settings.tabWidth, settings.indentWidth);
        String replacement = CodeFormatterUtil.format(4, stub, indent, null, lineDelim, this.fField.getJavaProject());
        if (replacement.endsWith(lineDelim)) {
            replacement = replacement.substring(0, replacement.length() - lineDelim.length());
        }
        this.setReplacementString(Strings.trimLeadingTabsAndSpaces(replacement));
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }
}

