/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.JavaPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class CommentsTabPage
extends ModifyDialogTabPage {
    private static final String PREVIEW = String.valueOf(CommentsTabPage.createPreviewHeader("An example for comment formatting. This example is meant to illustrate the various possibilities offered by <i>Eclipse</i> in order to format comments.")) + "package mypackage;\n" + "/**\n" + " * This is the comment for the example interface.\n" + " */\n" + " interface Example {" + " /**\n" + " *\n" + " * These possibilities include:\n" + " * <ul><li>Formatting of header comments.</li><li>Formatting of Javadoc tags</li></ul>\n" + " */\n" + " int bar();" + " /**\n" + " * The following is some sample code which illustrates source formatting within javadoc comments:\n" + " * <pre>public class Example {final int a= 1;final boolean b= true;}</pre>\n" + " * Descriptions of parameters and return values are best appended at end of the javadoc comment.\n" + " * @param a The first parameter. For an optimum result, this should be an odd number\n" + " * between 0 and 100.\n" + " * @param b The second parameter.\n" + " * @return The result of the foo operation, usually within 0 and 1000.\n" + " */" + " int foo(int a, int b);" + "}";
    private CompilationUnitPreview fPreview;

    public CommentsTabPage(ModifyDialog modifyDialog, Map workingValues) {
        super(modifyDialog, workingValues);
    }

    protected void doCreatePreferences(Composite composite, int numColumns) {
        Group globalGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group1_title);
        ModifyDialogTabPage.CheckboxPreference global = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_enable_comment_formatting, "org.eclipse.jdt.core.formatter.comment.format_comments");
        ModifyDialogTabPage.CheckboxPreference header = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_header, "org.eclipse.jdt.core.formatter.comment.format_header");
        ModifyDialogTabPage.CheckboxPreference html = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_html, "org.eclipse.jdt.core.formatter.comment.format_html");
        ModifyDialogTabPage.CheckboxPreference code = this.createPrefTrueFalse((Composite)globalGroup, numColumns, FormatterMessages.CommentsTabPage_format_code_snippets, "org.eclipse.jdt.core.formatter.comment.format_source_code");
        Group settingsGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group2_title);
        ModifyDialogTabPage.CheckboxPreference blankComments = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_clear_blank_lines, "org.eclipse.jdt.core.formatter.comment.clear_blank_lines");
        ModifyDialogTabPage.CheckboxPreference blankJavadoc = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_blank_line_before_javadoc_tags, "org.eclipse.jdt.core.formatter.comment.insert_new_line_before_root_tags");
        ModifyDialogTabPage.CheckboxPreference indentJavadoc = this.createPrefTrueFalse((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_javadoc_tags, "org.eclipse.jdt.core.formatter.comment.indent_root_tags");
        ModifyDialogTabPage.CheckboxPreference indentDesc = this.createCheckboxPref((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_indent_description_after_param, "org.eclipse.jdt.core.formatter.comment.indent_parameter_description", FALSE_TRUE);
        ((GridData)indentDesc.getControl().getLayoutData()).horizontalIndent = this.fPixelConverter.convertWidthInCharsToPixels(4);
        ModifyDialogTabPage.CheckboxPreference nlParam = this.createPrefInsert((Composite)settingsGroup, numColumns, FormatterMessages.CommentsTabPage_new_line_after_param_tags, "org.eclipse.jdt.core.formatter.comment.insert_new_line_for_parameter");
        Group widthGroup = this.createGroup(numColumns, composite, FormatterMessages.CommentsTabPage_group3_title);
        ModifyDialogTabPage.NumberPreference lineWidth = this.createNumberPref((Composite)widthGroup, numColumns, FormatterMessages.CommentsTabPage_line_width, "org.eclipse.jdt.core.formatter.comment.line_length", 0, 9999);
        ArrayList<ModifyDialogTabPage.CheckboxPreference> masters = new ArrayList<ModifyDialogTabPage.CheckboxPreference>();
        masters.add(global);
        ArrayList<Object> slaves = new ArrayList<Object>();
        slaves.add(settingsGroup);
        slaves.add(header);
        slaves.add(html);
        slaves.add(code);
        slaves.add(blankComments);
        slaves.add(blankJavadoc);
        slaves.add(indentJavadoc);
        slaves.add(nlParam);
        slaves.add(lineWidth);
        new Controller(masters, slaves);
        masters = new ArrayList();
        masters.add(global);
        masters.add(indentJavadoc);
        slaves = new ArrayList();
        slaves.add(indentDesc);
        new Controller(masters, slaves);
    }

    protected void initializePage() {
        this.fPreview.setPreviewText(PREVIEW);
    }

    protected JavaPreview doCreateJavaPreview(Composite parent) {
        this.fPreview = new CompilationUnitPreview(this.fWorkingValues, parent);
        return this.fPreview;
    }

    protected void doUpdatePreview() {
        this.fPreview.update();
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefTrueFalse(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, FALSE_TRUE);
    }

    private ModifyDialogTabPage.CheckboxPreference createPrefInsert(Composite composite, int numColumns, String text, String key) {
        return this.createCheckboxPref(composite, numColumns, text, key, DO_NOT_INSERT_INSERT);
    }

    private static final class Controller
    implements Observer {
        private final Collection fMasters;
        private final Collection fSlaves;

        public Controller(Collection masters, Collection slaves) {
            this.fMasters = masters;
            this.fSlaves = slaves;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                ((ModifyDialogTabPage.CheckboxPreference)iter.next()).addObserver(this);
            }
            this.update(null, null);
        }

        public void update(Observable o, Object arg) {
            boolean enabled = true;
            Iterator iter = this.fMasters.iterator();
            while (iter.hasNext()) {
                enabled &= ((ModifyDialogTabPage.CheckboxPreference)iter.next()).getChecked();
            }
            for (Object obj : this.fSlaves) {
                if (obj instanceof ModifyDialogTabPage.Preference) {
                    ((ModifyDialogTabPage.Preference)obj).setEnabled(enabled);
                    continue;
                }
                if (!(obj instanceof Control)) continue;
                ((Group)obj).setEnabled(enabled);
            }
        }
    }
}

