/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeAction;
import org.eclipse.jdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.jdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.PlatformUI;

class SearchScopeHierarchyAction
extends SearchScopeAction {
    private final SearchScopeActionGroup fGroup;

    public SearchScopeHierarchyAction(SearchScopeActionGroup group) {
        super(group, CallHierarchyMessages.SearchScopeActionGroup_hierarchy_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_hierarchy_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.call_hierarchy_search_scope_action_context");
    }

    public IJavaSearchScope getSearchScope() {
        try {
            IMethod method = this.fGroup.getView().getMethod();
            if (method != null) {
                return SearchEngine.createHierarchyScope((IType)method.getDeclaringType());
            }
            return null;
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
            return null;
        }
    }

    public int getSearchScopeType() {
        return 3;
    }

    public String getFullDescription() {
        IMethod method = this.fGroup.getView().getMethod();
        return JavaSearchScopeFactory.getInstance().getHierarchyScopeDescription(method.getDeclaringType());
    }
}

