/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.ui.internal.preferences.WorkingCopyPreferences;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class WorkingCopyManager
implements IWorkingCopyManager {
    private static final String EMPTY_STRING = "";
    private Map workingCopies = new HashMap();

    public IEclipsePreferences getWorkingCopy(IEclipsePreferences original) {
        if (original instanceof WorkingCopyPreferences) {
            throw new IllegalArgumentException("Trying to get a working copy of a working copy");
        }
        String absolutePath = original.absolutePath();
        IEclipsePreferences preferences = (IEclipsePreferences)this.workingCopies.get(absolutePath);
        if (preferences == null) {
            preferences = new WorkingCopyPreferences(original, this);
            this.workingCopies.put(absolutePath, preferences);
        }
        return preferences;
    }

    public void applyChanges() throws BackingStoreException {
        for (WorkingCopyPreferences prefs : this.workingCopies.values()) {
            if (!prefs.nodeExists(EMPTY_STRING)) continue;
            prefs.flush();
        }
    }
}

