/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.core.parser;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.rubypeople.rdt.core.RubyCore;
import org.rubypeople.rdt.internal.core.parser.TaskTag;

public class TaskParser {
    private boolean fCaseSensitive = false;
    private String[] fTags;
    private int[] fPriorities;
    private List tasks;

    public TaskParser(Map map) {
        String string = this.getString(map, "org.rubypeople.rdt.core.compiler.taskCaseSensitive", "enabled");
        if (string.equals("enabled")) {
            this.fCaseSensitive = true;
        }
        String string2 = this.getString(map, "org.rubypeople.rdt.core.compiler.taskTags", "TODO,FIXME,XXX");
        String string3 = this.getString(map, "org.rubypeople.rdt.core.compiler.taskPriorities", "NORMAL,HIGH,NORMAL");
        this.fTags = this.tokenize(string2, ",");
        this.fPriorities = this.convertPriorities(this.tokenize(string3, ","));
        this.tasks = new ArrayList();
    }

    private String getString(Map map, String string, String string2) {
        if (map == null) {
            return string2;
        }
        String string3 = (String)map.get(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private int[] convertPriorities(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            nArray[n] = string.equals("LOW") ? 0 : (string.equals("HIGH") ? 2 : 1);
            ++n;
        }
        return nArray;
    }

    private String[] tokenize(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n++] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public void parse(Reader reader) throws IOException {
        String string = this.loadFromReader(reader);
        this.parse(string);
    }

    public void parse(String string) {
        try {
            if (this.fTags.length <= 0) {
                return;
            }
            int n = 0;
            int n2 = 0;
            String string2 = null;
            while ((string2 = this.findNextLine(string, n)) != null) {
                this.processLine(string2, n, n2);
                ++n2;
                n += string2.length();
            }
        }
        catch (CoreException coreException) {
            RubyCore.log((Exception)((Object)coreException));
        }
    }

    private String findNextLine(String string, int n) {
        if (n >= string.length()) {
            return null;
        }
        int n2 = string.indexOf(13, n);
        int n3 = string.indexOf(10, n);
        int n4 = n2;
        if (n2 == -1) {
            n4 = n3;
        }
        if (n3 == -1 && n2 == -1) {
            return string.substring(n);
        }
        if (n2 + 1 == n3 && n2 >= 0) {
            ++n4;
        }
        return string.substring(n, n4 + 1);
    }

    private void processLine(String string, int n, int n2) throws CoreException {
        if (!this.fCaseSensitive) {
            string = string.toLowerCase();
        }
        int n3 = 0;
        while (n3 < this.fTags.length) {
            int n4;
            String string2 = this.fTags[n3];
            int n5 = this.fPriorities[n3];
            if (!this.fCaseSensitive) {
                string2 = string2.toLowerCase();
            }
            if ((n4 = string.indexOf(string2)) != -1) {
                String string3 = string.substring(n4).trim();
                this.createTaskTag(n5, string3, n2 + 1, n + n4, n + n4 + string3.length());
            }
            ++n3;
        }
    }

    private void createTaskTag(int n, String string, int n2, int n3, int n4) throws CoreException {
        TaskTag taskTag = new TaskTag(string, n, n2, n3, n4);
        this.tasks.add(taskTag);
    }

    private String loadFromReader(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = new char[4096];
        int n;
        while ((n = reader.read(cArray)) != -1) {
            stringBuffer.append(cArray, 0, n);
        }
        return stringBuffer.toString();
    }

    public List getTasks() {
        return Collections.unmodifiableList(this.tasks);
    }

    public void clear() {
        this.tasks.clear();
    }
}

