/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.wizards;

import java.util.Iterator;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.actions.NewProjectAction;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.util.ExceptionHandler;
import org.rubypeople.rdt.internal.ui.util.PixelConverter;
import org.rubypeople.rdt.internal.ui.wizards.NewWizardMessages;

public abstract class AbstractOpenWizardAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private Class[] fActivatedOnTypes;
    private boolean fAcceptEmptySelection;
    private boolean fNoChecking;

    public AbstractOpenWizardAction(String string, boolean bl) {
        this(string, null, bl);
    }

    public AbstractOpenWizardAction(String string, Class[] classArray, boolean bl) {
        super(string);
        this.fActivatedOnTypes = classArray;
        this.fAcceptEmptySelection = bl;
        this.fNoChecking = false;
    }

    protected AbstractOpenWizardAction() {
        this.fActivatedOnTypes = null;
        this.fAcceptEmptySelection = true;
        this.fNoChecking = true;
    }

    protected IWorkbench getWorkbench() {
        return RubyPlugin.getDefault().getWorkbench();
    }

    private boolean isOfAcceptedType(Object object) {
        if (this.fActivatedOnTypes != null) {
            int n = 0;
            while (n < this.fActivatedOnTypes.length) {
                if (this.fActivatedOnTypes[n].isInstance(object)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return true;
    }

    private boolean isEnabled(IStructuredSelection iStructuredSelection) {
        Iterator iterator = iStructuredSelection.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (this.isOfAcceptedType(e) && this.shouldAcceptElement(e)) continue;
            return false;
        }
        return true;
    }

    protected boolean shouldAcceptElement(Object object) {
        return true;
    }

    protected abstract Wizard createWizard() throws CoreException;

    protected IStructuredSelection getCurrentSelection() {
        ISelection iSelection;
        IWorkbenchWindow iWorkbenchWindow = RubyPlugin.getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null && (iSelection = iWorkbenchWindow.getSelectionService().getSelection()) instanceof IStructuredSelection) {
            return (IStructuredSelection)iSelection;
        }
        return null;
    }

    public void run() {
        if (!this.fNoChecking && !this.canActionBeAdded()) {
            return;
        }
        if (!this.checkWorkspaceNotEmpty()) {
            return;
        }
        Shell shell = RubyPlugin.getActiveWorkbenchShell();
        try {
            Wizard wizard = this.createWizard();
            if (wizard instanceof IWorkbenchWizard) {
                ((IWorkbenchWizard)wizard).init(this.getWorkbench(), this.getCurrentSelection());
            }
            WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
            PixelConverter pixelConverter = new PixelConverter((Control)RubyPlugin.getActiveWorkbenchShell());
            wizardDialog.setMinimumPageSize(pixelConverter.convertWidthInCharsToPixels(70), pixelConverter.convertHeightInCharsToPixels(20));
            wizardDialog.create();
            int n = wizardDialog.open();
            this.notifyResult(n == 0);
        }
        catch (CoreException coreException) {
            String string = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.title");
            String string2 = NewWizardMessages.getString("AbstractOpenWizardAction.createerror.message");
            ExceptionHandler.handle(coreException, shell, string, string2);
        }
    }

    public boolean canActionBeAdded() {
        IStructuredSelection iStructuredSelection = this.getCurrentSelection();
        if (iStructuredSelection == null || iStructuredSelection.isEmpty()) {
            return this.fAcceptEmptySelection;
        }
        return this.isEnabled(iStructuredSelection);
    }

    public void run(IAction iAction) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    protected boolean checkWorkspaceNotEmpty() {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        if (iWorkspace.getRoot().getProjects().length == 0) {
            String string;
            String string2;
            Shell shell = RubyPlugin.getActiveWorkbenchShell();
            if (MessageDialog.openQuestion((Shell)shell, (String)(string2 = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.title")), (String)(string = NewWizardMessages.getString("AbstractOpenWizardAction.noproject.message")))) {
                IWorkbenchWindow iWorkbenchWindow = RubyPlugin.getActiveWorkbenchWindow();
                new NewProjectAction(iWorkbenchWindow).run();
                return iWorkspace.getRoot().getProjects().length != 0;
            }
            return false;
        }
        return true;
    }
}

