/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.text.folding;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.rubypeople.rdt.internal.ui.RubyPlugin;
import org.rubypeople.rdt.internal.ui.text.folding.RubyFoldingStructureProviderDescriptor;
import org.rubypeople.rdt.ui.text.folding.IRubyFoldingStructureProvider;

public class RubyFoldingStructureProviderRegistry {
    private static final String EXTENSION_POINT = "foldingStructureProviders";
    private Map fDescriptors;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyFoldingStructureProviderDescriptor[] getFoldingProviderDescriptors() {
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return this.fDescriptors.values().toArray(new RubyFoldingStructureProviderDescriptor[this.fDescriptors.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyFoldingStructureProviderDescriptor getFoldingProviderDescriptor(String string) {
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.ensureRegistered();
            return (RubyFoldingStructureProviderDescriptor)this.fDescriptors.get(string);
        }
    }

    public IRubyFoldingStructureProvider getCurrentFoldingProvider() {
        String string = RubyPlugin.getDefault().getPreferenceStore().getString("editor_folding_provider");
        RubyFoldingStructureProviderDescriptor rubyFoldingStructureProviderDescriptor = this.getFoldingProviderDescriptor(string);
        if (rubyFoldingStructureProviderDescriptor != null) {
            try {
                return rubyFoldingStructureProviderDescriptor.createProvider();
            }
            catch (CoreException coreException) {
                RubyPlugin.log(coreException);
            }
        }
        return null;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadExtensions() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        HashMap<String, RubyFoldingStructureProviderDescriptor> hashMap = new HashMap<String, RubyFoldingStructureProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = iExtensionRegistry.getConfigurationElementsFor(RubyPlugin.getPluginId(), EXTENSION_POINT);
        int n = 0;
        while (n < iConfigurationElementArray.length) {
            RubyFoldingStructureProviderDescriptor rubyFoldingStructureProviderDescriptor = new RubyFoldingStructureProviderDescriptor(iConfigurationElementArray[n]);
            hashMap.put(rubyFoldingStructureProviderDescriptor.getId(), rubyFoldingStructureProviderDescriptor);
            ++n;
        }
        RubyFoldingStructureProviderRegistry rubyFoldingStructureProviderRegistry = this;
        synchronized (rubyFoldingStructureProviderRegistry) {
            this.fDescriptors = Collections.unmodifiableMap(hashMap);
        }
    }
}

