/*
 * Decompiled with CFR 0.152.
 */
package org.rubypeople.rdt.internal.ui.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.rubypeople.rdt.internal.ui.dialogs.StatusInfo;
import org.rubypeople.rdt.internal.ui.dialogs.StatusUtil;
import org.rubypeople.rdt.internal.ui.wizards.IStatusChangeListener;
import org.rubypeople.rdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;

public abstract class PropertyAndPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IWorkbenchPropertyPage {
    private Control fConfigurationBlockControl;
    private ControlEnableState fBlockEnableState = null;
    private Hyperlink fChangeWorkspaceSettings;
    private SelectionButtonDialogField fUseProjectSettings;
    private IStatus fBlockStatus = new StatusInfo();
    private IProject fProject = null;
    static /* synthetic */ Class class$0;

    protected Control createContents(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        composite2.setFont(composite.getFont());
        GridData gridData = new GridData(4, 4, true, true);
        this.fConfigurationBlockControl = this.createPreferenceContent(composite2);
        this.fConfigurationBlockControl.setLayoutData((Object)gridData);
        if (this.isProjectPreferencePage()) {
            boolean bl = this.hasProjectSpecificOptions(this.getProject());
            this.enableProjectSpecificSettings(bl);
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    protected abstract Control createPreferenceContent(Composite var1);

    protected abstract boolean hasProjectSpecificOptions(IProject var1);

    protected abstract String getPreferencePageID();

    protected abstract String getPropertyPageID();

    protected final void openWorkspacePreferences(Object object) {
        String string = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)string, (String[])new String[]{string}, (Object)object).open();
    }

    protected boolean useProjectSettings() {
        return this.isProjectPreferencePage() && this.fUseProjectSettings != null && this.fUseProjectSettings.isSelected();
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected IProject getProject() {
        return this.fProject;
    }

    private void doProjectWorkspaceStateChanged() {
        this.enablePreferenceContent(this.useProjectSettings());
        this.fChangeWorkspaceSettings.setVisible(!this.useProjectSettings());
        this.doStatusChanged();
    }

    protected void setPreferenceContentStatus(IStatus iStatus) {
        this.fBlockStatus = iStatus;
        this.doStatusChanged();
    }

    protected IStatusChangeListener getNewStatusChangedListener() {
        return new IStatusChangeListener(){

            public void statusChanged(IStatus iStatus) {
                PropertyAndPreferencePage.this.setPreferenceContentStatus(iStatus);
            }
        };
    }

    protected IStatus getPreferenceContentStatus() {
        return this.fBlockStatus;
    }

    protected void doStatusChanged() {
        if (!this.isProjectPreferencePage() || this.useProjectSettings()) {
            this.updateStatus(this.fBlockStatus);
        } else {
            this.updateStatus(new StatusInfo());
        }
    }

    protected void enablePreferenceContent(boolean bl) {
        if (bl) {
            if (this.fBlockEnableState != null) {
                this.fBlockEnableState.restore();
                this.fBlockEnableState = null;
            }
        } else if (this.fBlockEnableState == null) {
            this.fBlockEnableState = ControlEnableState.disable((Control)this.fConfigurationBlockControl);
        }
    }

    protected void performDefaults() {
        if (this.useProjectSettings()) {
            this.fUseProjectSettings.setSelection(false);
        }
        super.performDefaults();
    }

    private void updateStatus(IStatus iStatus) {
        this.setValid(!iStatus.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, iStatus);
    }

    public void init(IWorkbench iWorkbench) {
    }

    public IAdaptable getElement() {
        return this.fProject;
    }

    public void setElement(IAdaptable iAdaptable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IResource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fProject = (IProject)iAdaptable.getAdapter((Class)clazz);
    }

    protected void enableProjectSpecificSettings(boolean bl) {
        this.fUseProjectSettings.setSelection(bl);
        this.enablePreferenceContent(bl);
        this.updateLinkVisibility();
        this.doStatusChanged();
    }

    private void updateLinkVisibility() {
        if (this.fChangeWorkspaceSettings == null || this.fChangeWorkspaceSettings.isDisposed()) {
            return;
        }
        if (this.isProjectPreferencePage()) {
            this.fChangeWorkspaceSettings.setEnabled(!this.useProjectSettings());
        }
    }
}

