/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.namespace;

import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.namespace.MRIDRule;
import fr.jayasoft.ivy.namespace.NamespaceTransformer;
import fr.jayasoft.ivy.util.Message;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MRIDTransformationRule
implements NamespaceTransformer {
    private List _src = new ArrayList();
    private MRIDRule _dest;

    public void addSrc(MRIDRule src) {
        this._src.add(src);
    }

    public void addDest(MRIDRule dest) {
        if (this._dest != null) {
            throw new IllegalArgumentException("only one dest is allowed per mapping");
        }
        this._dest = dest;
    }

    public ModuleRevisionId transform(ModuleRevisionId mrid) {
        MridRuleMatcher matcher = new MridRuleMatcher();
        Iterator iter = this._src.iterator();
        while (iter.hasNext()) {
            MRIDRule rule = (MRIDRule)iter.next();
            if (!matcher.match(rule, mrid)) continue;
            ModuleRevisionId destMrid = matcher.apply(this._dest, mrid);
            Message.debug("found matching namespace rule: " + rule + ". Applied " + this._dest + " on " + mrid + ". Transformed to " + destMrid);
            return destMrid;
        }
        return mrid;
    }

    public boolean isIdentity() {
        return false;
    }

    private static class MridRuleMatcher {
        private static final String[] TYPES = new String[]{"o", "m", "b", "r"};
        private Matcher[] _matchers = new Matcher[4];

        private MridRuleMatcher() {
        }

        public boolean match(MRIDRule src, ModuleRevisionId mrid) {
            this._matchers[0] = Pattern.compile(this.getPattern(src.getOrg())).matcher(mrid.getOrganisation());
            if (!this._matchers[0].matches()) {
                return false;
            }
            this._matchers[1] = Pattern.compile(this.getPattern(src.getModule())).matcher(mrid.getName());
            if (!this._matchers[1].matches()) {
                return false;
            }
            if (mrid.getBranch() == null) {
                this._matchers[2] = null;
            } else {
                this._matchers[2] = Pattern.compile(this.getPattern(src.getBranch())).matcher(mrid.getBranch());
                if (!this._matchers[2].matches()) {
                    return false;
                }
            }
            this._matchers[3] = Pattern.compile(this.getPattern(src.getRev())).matcher(mrid.getRevision());
            return this._matchers[3].matches();
        }

        public ModuleRevisionId apply(MRIDRule dest, ModuleRevisionId mrid) {
            String org = this.applyRules(dest.getOrg(), "o");
            String mod = this.applyRules(dest.getModule(), "m");
            String branch = this.applyRules(dest.getBranch(), "b");
            String rev = this.applyRules(dest.getRev(), "r");
            return ModuleRevisionId.newInstance(org, mod, branch, rev, mrid.getExtraAttributes());
        }

        private String applyRules(String str, String type) {
            for (int i = 0; i < TYPES.length; ++i) {
                str = this.applyTypeRule(str, TYPES[i], type, this._matchers[i]);
            }
            return str;
        }

        private String applyTypeRule(String rule, String type, String ruleType, Matcher m) {
            if (m == null) {
                return rule;
            }
            String res = rule == null ? "$" + ruleType + "0" : rule;
            for (int i = 0; i < TYPES.length; ++i) {
                if (TYPES[i].equals(type)) {
                    res = res.replaceAll("([^\\\\])\\$" + type, "$1\\$");
                    res = res.replaceAll("^\\$" + type, "\\$");
                    continue;
                }
                res = res.replaceAll("([^\\\\])\\$" + TYPES[i], "$1\\\\\\$" + TYPES[i]);
                res = res.replaceAll("^\\$" + TYPES[i], "\\\\\\$" + TYPES[i]);
            }
            StringBuffer sb = new StringBuffer();
            m.reset();
            m.find();
            m.appendReplacement(sb, res);
            String str = sb.toString();
            if (rule == null && ("$" + ruleType + "0").equals(str)) {
                return null;
            }
            return str;
        }

        private String getPattern(String p) {
            return p == null ? ".*" : p;
        }
    }
}

