/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.plugin.eclipse.quickfix;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.BugResolution;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.exception.BugResolutionException;
import edu.umd.cs.findbugs.plugin.eclipse.quickfix.util.ASTUtil;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public class CreateSuperCallResolution
extends BugResolution {
    private boolean insertFirst = true;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CreateSuperCallResolution() {
    }

    public CreateSuperCallResolution(boolean insertFirst) {
        this();
        this.setInsertFirst(insertFirst);
    }

    public boolean isInsertFirst() {
        return this.insertFirst;
    }

    public void setInsertFirst(boolean insertFirst) {
        this.insertFirst = insertFirst;
    }

    public boolean isInsertLast() {
        return !this.isInsertFirst();
    }

    public void setInsertLast(boolean insertLast) {
        this.setInsertFirst(!insertLast);
    }

    protected void repairBug(ASTRewrite rewrite, CompilationUnit workingUnit, BugInstance bug) throws BugResolutionException {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && workingUnit == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && bug == null) {
            throw new AssertionError();
        }
        TypeDeclaration type = ASTUtil.getTypeDeclaration(workingUnit, bug.getPrimaryClass());
        MethodDeclaration method = ASTUtil.getMethodDeclaration(type, bug.getPrimaryMethod());
        AST ast = rewrite.getAST();
        SuperMethodInvocation superCall = this.createSuperMethodInvocation(rewrite, method);
        ExpressionStatement statement = ast.newExpressionStatement((Expression)superCall);
        Block methodBody = method.getBody();
        ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)methodBody, Block.STATEMENTS_PROPERTY);
        if (this.isInsertFirst()) {
            listRewrite.insertFirst((ASTNode)statement, null);
        } else {
            listRewrite.insertLast((ASTNode)statement, null);
        }
    }

    protected SuperMethodInvocation createSuperMethodInvocation(ASTRewrite rewrite, MethodDeclaration method) {
        if (!$assertionsDisabled && rewrite == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && method == null) {
            throw new AssertionError();
        }
        AST ast = rewrite.getAST();
        SuperMethodInvocation invocation = ast.newSuperMethodInvocation();
        invocation.setName((SimpleName)rewrite.createCopyTarget((ASTNode)method.getName()));
        return invocation;
    }

    protected boolean resolveBindings() {
        return true;
    }

    static {
        $assertionsDisabled = !CreateSuperCallResolution.class.desiredAssertionStatus();
    }
}

