/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import java.util.Iterator;
import org.apache.bcel.generic.InstructionHandle;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataflowAnalysis<Fact>
extends BasicAbstractDataflowAnalysis<Fact> {
    private static final boolean DEBUG = SystemProperties.getBoolean("dataflow.transfer");

    public abstract void transferInstruction(InstructionHandle var1, BasicBlock var2, Fact var3) throws DataflowAnalysisException;

    @CheckReturnValue
    public abstract boolean isFactValid(Fact var1);

    @Override
    public Fact getFactAtLocation(Location location) throws DataflowAnalysisException {
        Object start = this.getStartFact(location.getBasicBlock());
        Object result = this.createFact();
        this.makeFactTop(result);
        this.transfer(location.getBasicBlock(), location.getHandle(), start, result);
        return result;
    }

    @Override
    public Fact getFactAfterLocation(Location location) throws DataflowAnalysisException {
        BasicBlock basicBlock = location.getBasicBlock();
        InstructionHandle handle = location.getHandle();
        if (handle == (this.isForwards() ? basicBlock.getLastInstruction() : basicBlock.getFirstInstruction())) {
            return this.getResultFact(basicBlock);
        }
        return this.getFactAtLocation(new Location(this.isForwards() ? handle.getNext() : handle.getPrev(), basicBlock));
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, Fact start, Fact result) throws DataflowAnalysisException {
        this.copy(start, result);
        if (this.isFactValid(result)) {
            InstructionHandle handle;
            Iterator<InstructionHandle> i;
            Iterator<InstructionHandle> iterator = i = this.isForwards() ? basicBlock.instructionIterator() : basicBlock.instructionReverseIterator();
            while (i.hasNext() && (handle = i.next()) != end) {
                if (DEBUG && end == null) {
                    System.out.print(new StringBuffer().append("Transfer ").append(handle).toString());
                }
                this.transferInstruction(handle, basicBlock, result);
                if (!DEBUG || end != null) continue;
                System.out.println(new StringBuffer().append(" ==> ").append(result.toString()).toString());
            }
        }
    }
}

