/*
 * Decompiled with CFR 0.152.
 */
package org.epic.core.util;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.TextUtilities;
import org.epic.core.util.PerlExecutor;
import org.epic.core.util.ProcessOutput;
import org.epic.core.util.ResourceUtilities;
import org.epic.core.util.StatusFactory;
import org.epic.perleditor.PerlEditorPlugin;

public abstract class ScriptExecutor {
    private ILog log;

    protected ScriptExecutor(ILog log) {
        this.log = log;
    }

    public final ProcessOutput run(List args) throws CoreException {
        return this.run("", args);
    }

    public final ProcessOutput run(String text) throws CoreException {
        return this.run(text, null);
    }

    public final ProcessOutput run(String text, List additionalArgs) throws CoreException {
        File workingDir = this.getWorkingDir();
        PerlExecutor executor = new PerlExecutor(this.ignoresBrokenPipe());
        try {
            ArrayList<String> cmdArgs = new ArrayList<String>(1);
            cmdArgs.add(this.getExecutable());
            cmdArgs.addAll(this.getCommandLineOpts(additionalArgs));
            ProcessOutput output = executor.execute(workingDir, cmdArgs, text);
            if (output.stderr != null && !output.stderr.equals("")) {
                this.log.log(StatusFactory.createWarning(PerlEditorPlugin.getPluginId(), "Perl Process stderr: " + output.stderr, null));
            }
            ProcessOutput processOutput = output;
            Object var7_8 = null;
            executor.dispose();
            return processOutput;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            executor.dispose();
            throw throwable;
        }
    }

    protected abstract String getExecutable();

    protected abstract String getScriptDir();

    protected List getCommandLineOpts(List additionalOptions) {
        return additionalOptions != null ? additionalOptions : Collections.EMPTY_LIST;
    }

    protected String getSystemLineSeparator() {
        String seperator = System.getProperty("line.separator");
        if (seperator == null) {
            seperator = "\n";
        }
        return seperator;
    }

    protected String getLineSeparator(String text) {
        return TextUtilities.determineLineDelimiter((String)text, (String)this.getSystemLineSeparator());
    }

    protected String getPluginId() {
        return PerlEditorPlugin.getPluginId();
    }

    protected boolean ignoresBrokenPipe() {
        return false;
    }

    protected void log(IStatus status) {
        this.log.log(status);
    }

    protected int parseInt(String s) {
        try {
            return Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            this.log.log(StatusFactory.createError(this.getPluginId(), e.getMessage(), e));
            return -1;
        }
    }

    private File extractScripts() throws CoreException {
        return ResourceUtilities.extractResources((Plugin)PerlEditorPlugin.getDefault(), "perlutils/");
    }

    private File getWorkingDir() throws CoreException {
        try {
            File scriptsLocation = this.extractScripts();
            if (scriptsLocation == null) {
                URL url = new URL(PerlEditorPlugin.getDefault().getBundle().getEntry("/"), this.getScriptDir());
                URL workingURL = Platform.resolve((URL)url);
                return new File(workingURL.getPath());
            }
            return new File(scriptsLocation.getParentFile(), this.getScriptDir());
        }
        catch (IOException e) {
            this.log.log(StatusFactory.createError(this.getPluginId(), e.getMessage(), e));
            return null;
        }
    }
}

