WebInspector.PromisePane=function()
{WebInspector.VBox.call(this);this.registerRequiredCSS("promises/promisePane.css");this.element.classList.add("promises");var statusBar=this.element.createChild("div","panel-status-bar");this._recordButton=new WebInspector.StatusBarButton(WebInspector.UIString("Record Promises"),"record-profile-status-bar-item");this._recordButton.addEventListener("click",this._recordButtonClicked.bind(this));statusBar.appendChild(this._recordButton.element);var clearButton=new WebInspector.StatusBarButton(WebInspector.UIString("Clear"),"clear-status-bar-item");clearButton.addEventListener("click",this._clearButtonClicked.bind(this));statusBar.appendChild(clearButton.element);this._refreshButton=new WebInspector.StatusBarButton(WebInspector.UIString("Refresh"),"refresh-storage-status-bar-item");this._refreshButton.addEventListener("click",this._refreshButtonClicked.bind(this));this._refreshButton.setEnabled(false);statusBar.appendChild(this._refreshButton.element);this._liveCheckbox=new WebInspector.StatusBarCheckbox(WebInspector.UIString("Live"));this._liveCheckbox.element.title=WebInspector.UIString("Live Recording");this._liveCheckbox.inputElement.disabled=true;statusBar.appendChild(this._liveCheckbox.element);this._dataGridContainer=new WebInspector.VBox();this._dataGridContainer.show(this.element);var columns=[{id:"location",title:WebInspector.UIString("Location"),disclosure:true},{id:"status",title:WebInspector.UIString("Status")},{id:"tts",title:WebInspector.UIString("Time to settle")}];this._dataGrid=new WebInspector.DataGrid(columns,undefined,undefined,undefined,this._onContextMenu.bind(this));this._dataGrid.show(this._dataGridContainer.element);this._linkifier=new WebInspector.Linkifier();}
WebInspector.PromisePane.prototype={_recordButtonClicked:function(event)
{var recording=!this._recordButton.toggled;this._recordButton.toggled=recording;this._refreshButton.setEnabled(recording);if(recording)
this._enablePromiseTracker();else
this._disablePromiseTracker();},_refreshButtonClicked:function(event)
{this._updateData();},_clearButtonClicked:function(event)
{this._clear();},_enablePromiseTracker:function()
{var mainTarget=WebInspector.targetManager.mainTarget();if(mainTarget){mainTarget.debuggerAgent().enablePromiseTracker();this._target=mainTarget;}},_disablePromiseTracker:function()
{if(this._target){this._target.debuggerAgent().disablePromiseTracker();delete this._target;}
this._clear();},_comparePromises:function(p1,p2){var t1=p1.creationTime||0;var t2=p2.creationTime||0;return t1-t2;},_updateData:function()
{function callback(error,promiseData)
{if(error||!promiseData)
return;promiseData.sort(this._comparePromises);var nodesToInsert={__proto__:null};for(var i=0;i<promiseData.length;i++){var promise=promiseData[i];var status=createElementWithClass("div","status");status.classList.add(promise.status);status.createTextChild(promise.status);var data={promiseId:promise.id,status:status};if(promise.callFrame)
data.location=this._linkifier.linkifyConsoleCallFrame(this._target,promise.callFrame);if(promise.creationTime&&promise.settlementTime&&promise.settlementTime>=promise.creationTime)
data.tts=Number.millisToString(promise.settlementTime-promise.creationTime,true);var node=new WebInspector.DataGridNode(data,false);nodesToInsert[promise.id]={node:node,parentId:promise.parentId};}
var rootNode=this._dataGrid.rootNode();for(var id in nodesToInsert){var node=nodesToInsert[id].node;var parentId=nodesToInsert[id].parentId;var parentNode=(parentId&&nodesToInsert[parentId])?nodesToInsert[parentId].node:rootNode;parentNode.appendChild(node);parentNode.expanded=true;}}
this._clear();if(this._target)
this._target.debuggerAgent().getPromises(callback.bind(this));},_clear:function()
{this._dataGrid.rootNode().removeChildren();this._linkifier.reset();},_onContextMenu:function(contextMenu,node)
{if(!this._target)
return;var promiseId=node.data.promiseId;contextMenu.appendItem(WebInspector.UIString(WebInspector.useLowerCaseMenuTitles()?"Show in console":"Show In Console"),showPromiseInConsole.bind(this));contextMenu.show();function showPromiseInConsole()
{if(this._target)
this._target.debuggerAgent().getPromiseById(promiseId,"console",didGetPromiseById.bind(this));}
function didGetPromiseById(error,promise)
{if(error||!promise)
return;if(!this._target)
return;this._target.consoleAgent().setLastEvaluationResult(promise.objectId);var message=new WebInspector.ConsoleMessage(this._target,WebInspector.ConsoleMessage.MessageSource.Other,WebInspector.ConsoleMessage.MessageLevel.Log,"",WebInspector.ConsoleMessage.MessageType.Log,undefined,undefined,undefined,undefined,[promise]);this._target.consoleModel.addMessage(message);WebInspector.console.show();}},__proto__:WebInspector.VBox.prototype};Runtime.cachedResources["promises/promisePane.css"]="/*\n * Copyright 2014 The Chromium Authors. All rights reserved.\n * Use of this source code is governed by a BSD-style license that can be\n * found in the LICENSE file.\n */\n\n.promises .data-grid {\n    border: none;\n    flex: 1 1;\n}\n\n.promises .data-grid .odd {\n    background-color: #eee;\n}\n\n.promises .data-grid .header-container {\n    height: 30px;\n}\n\n.promises .data-grid .data-container {\n    top: 30px;\n}\n\n.promises .data-grid table.data {\n    background: transparent;\n}\n\n.promises .data-grid th {\n    border-bottom: none;\n    border-left: 1px solid rgb(205, 205, 205);\n    background-color: white;\n}\n\n.promises .data-grid td {\n    line-height: 17px;\n    height: 24px;\n    vertical-align: middle;\n    border-bottom: 1px solid rgb(205, 205, 205);\n    border-left: 1px solid rgb(205, 205, 205);\n}\n\n.promises .status {\n    border-radius: 25px;\n    width: 54px;\n    text-align: center;\n    color: white;\n}\n\n.promises .status.rejected {\n    background-color: #f66;\n}\n\n.promises .status.resolved {\n    background-color: #696;\n}\n/*# sourceURL=promises/promisePane.css */";