/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sql;

import ca.sqlpower.sql.JDBCDataSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.apache.log4j.Logger;

public class JDBCDataSourceType {
    static final Logger logger = Logger.getLogger(JDBCDataSourceType.class);
    private static final Map<List<String>, JDBCClassLoader> jdbcClassloaders = new HashMap<List<String>, JDBCClassLoader>();
    private static Map<String, Integer> classLoadCounts = new HashMap<String, Integer>();
    public static final String JDBC_DRIVER = "JDBC Driver Class";
    public static final String JDBC_URL = "JDBC URL";
    public static final String JDBC_JAR_BASE = "JDBC JAR";
    public static final String JDBC_JAR_COUNT = "JDBC JAR Count";
    public static final String TYPE_NAME = "Name";
    public static final String PARENT_TYPE_NAME = "Parent Type";
    public static final String PL_DB_TYPE = "PL Type";
    public static final String COMMENT = "Comment";
    public static final String DDL_GENERATOR = "DDL Generator";
    public static final String KETTLE_DB_TYPES = "ca.sqlpower.architect.etl.kettle.connectionType";
    public static final String SUPPORTS_UPDATEABLE_RESULT_SETS = "Supports Updatable Result Sets";
    public static final String SUPPORTS_STREAM_QUERIES = "Supports Stream Queries";
    private JDBCDataSourceType parentType;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private JDBCClassLoader classLoader;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final List<UndoableEditListener> undoableEditListeners = new ArrayList<UndoableEditListener>();
    private final URI serverBaseUri;

    public JDBCDataSourceType() {
        this(null);
    }

    public JDBCDataSourceType(URI serverBaseUri) {
        this.serverBaseUri = serverBaseUri;
        this.classLoader = this.getClassLoaderFromCache();
    }

    private JDBCClassLoader getClassLoaderFromCache() {
        List<String> classpath = Collections.unmodifiableList(new ArrayList<String>(this.getJdbcJarList()));
        JDBCClassLoader classLoader = jdbcClassloaders.get(classpath);
        if (classLoader == null) {
            classLoader = new JDBCClassLoader(this.getServerBaseUri(), classpath);
            jdbcClassloaders.put(classpath, classLoader);
        }
        return classLoader;
    }

    public String getComment() {
        return this.getProperty(COMMENT);
    }

    public void setComment(String comment) {
        this.putPropertyImpl("comment", COMMENT, comment);
    }

    public String getPlDbType() {
        return this.getProperty(PL_DB_TYPE);
    }

    public void setPlDbType(String type) {
        this.putPropertyImpl("plDbType", PL_DB_TYPE, type);
    }

    public String getJdbcDriver() {
        return this.getProperty(JDBC_DRIVER);
    }

    public void setJdbcDriver(String jdbcDriver) {
        this.putPropertyImpl("jdbcDriver", JDBC_DRIVER, jdbcDriver);
    }

    public List<String> getJdbcJarList() {
        return Collections.unmodifiableList(this.makeModifiableJdbcJarList());
    }

    private List<String> makeModifiableJdbcJarList() {
        int count = this.getJdbcJarCount();
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < count; ++i) {
            String key = "JDBC JAR_" + i;
            String value = this.getProperty(key);
            if (value != null) {
                logger.debug((Object)("Found jar \"" + value + "\" under key \"" + key + "\""));
                list.add(value);
                continue;
            }
            logger.debug((Object)("Skipping null jar entry under key \"" + key + "\""));
        }
        return list;
    }

    public void setJdbcJarList(List<String> jdbcJarList) {
        this.clearJdbcJarList();
        int count = jdbcJarList.size();
        this.setJdbcJarCount(count);
        int i = 0;
        for (String jar : jdbcJarList) {
            logger.debug((Object)("Setting jar list value " + i + " to path " + jar));
            this.properties.put("JDBC JAR_" + i, jar);
            ++i;
        }
        this.classLoader = this.getClassLoaderFromCache();
    }

    private void clearJdbcJarList() {
        Set<String> keys = this.properties.keySet();
        Iterator<String> it = keys.iterator();
        while (it.hasNext()) {
            String key = it.next();
            if (!key.startsWith(JDBC_JAR_BASE)) continue;
            it.remove();
        }
    }

    public void addJdbcJar(String jarPath) {
        logger.debug((Object)("Adding jar at path " + jarPath));
        int count = this.getJdbcJarCount();
        this.properties.put("JDBC JAR_" + count, jarPath);
        this.setJdbcJarCount(count + 1);
        this.classLoader = this.getClassLoaderFromCache();
    }

    private void setJdbcJarCount(int count) {
        this.putPropertyImpl("jdbcJarCount", JDBC_JAR_COUNT, String.valueOf(count));
        this.classLoader = this.getClassLoaderFromCache();
    }

    private int getJdbcJarCount() {
        String jarCountString = this.getProperty(JDBC_JAR_COUNT);
        if (jarCountString == null) {
            return 0;
        }
        return Integer.parseInt(jarCountString);
    }

    public String getJdbcUrl() {
        return this.getProperty(JDBC_URL);
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.putPropertyImpl("jdbcUrl", JDBC_URL, jdbcUrl);
    }

    public Map<String, String> retrieveURLDefaults() {
        String template = this.getProperty(JDBC_URL);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (template == null) {
            return map;
        }
        int searchFrom = 0;
        while (template.indexOf(60, searchFrom) >= 0) {
            int openBrace = template.indexOf(60, searchFrom);
            searchFrom = openBrace + 1;
            int colon = template.indexOf(58, searchFrom);
            int closeBrace = template.indexOf(62, searchFrom);
            if (closeBrace == -1) break;
            if (colon >= 0 && colon < closeBrace) {
                map.put(template.substring(openBrace + 1, colon), template.substring(colon + 1, closeBrace));
            } else if (closeBrace >= 0) {
                map.put(template.substring(openBrace + 1, closeBrace), "");
            }
            searchFrom = closeBrace++;
        }
        return map;
    }

    public Map<String, String> retrieveURLParsing(String url) {
        String template = this.getProperty(JDBC_URL);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (template == null) {
            return map;
        }
        String reTemplate = template.replaceAll("<.*?>", "(.*)");
        logger.debug((Object)("Regex of template is " + reTemplate));
        Pattern p = Pattern.compile(reTemplate);
        Matcher m = p.matcher(url);
        if (m.find()) {
            int searchFrom = 0;
            for (int g = 1; g <= m.groupCount(); ++g) {
                int openBrace = template.indexOf(60, searchFrom);
                searchFrom = openBrace + 1;
                int colon = template.indexOf(58, searchFrom);
                int closeBrace = template.indexOf(62, searchFrom);
                if (colon >= 0 && colon < closeBrace) {
                    map.put(template.substring(openBrace + 1, colon), m.group(g));
                } else if (closeBrace >= 0) {
                    map.put(template.substring(openBrace + 1, closeBrace), m.group(g));
                }
                searchFrom = closeBrace++;
            }
        }
        logger.debug((Object)("The map! dun dun dun: " + ((Object)map).toString()));
        return map;
    }

    public String getName() {
        return this.getProperty(TYPE_NAME);
    }

    public void setName(String name) {
        this.putPropertyImpl("name", TYPE_NAME, name);
    }

    public String getDDLGeneratorClass() {
        return this.getProperty(DDL_GENERATOR);
    }

    public void setDDLGeneratorClass(String className) {
        this.putPropertyImpl("DDLGeneratorClass", DDL_GENERATOR, className);
    }

    public JDBCDataSourceType getParentType() {
        return this.parentType;
    }

    public void setParentType(JDBCDataSourceType parentType) {
        this.parentType = parentType;
    }

    public boolean getSupportsUpdateableResultSets() {
        String ret = this.getProperty(SUPPORTS_UPDATEABLE_RESULT_SETS);
        return ret != null && Boolean.parseBoolean(ret);
    }

    public boolean getSupportsStreamQueries() {
        String ret = this.getProperty(SUPPORTS_STREAM_QUERIES);
        return ret != null && Boolean.parseBoolean(ret);
    }

    Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Set<String> getPropertyNames() {
        return Collections.unmodifiableSet(this.properties.keySet());
    }

    public void putProperty(String key, String value) {
        this.putPropertyImpl(null, key, value);
    }

    public ClassLoader getJdbcClassLoader() {
        return this.classLoader;
    }

    public List<String> getKettleNames() {
        LinkedList<String> ret = new LinkedList<String>();
        String dbTypes = this.getProperty(KETTLE_DB_TYPES);
        if (dbTypes == null) {
            return Collections.emptyList();
        }
        Scanner s = new Scanner(dbTypes);
        s.useDelimiter(":");
        while (s.hasNext()) {
            ret.add(s.next());
        }
        return ret;
    }

    public String getProperty(String key) {
        String value = this.properties.get(key);
        if (value != null) {
            return value;
        }
        if (this.parentType != null) {
            return this.parentType.getProperty(key);
        }
        return null;
    }

    public void removeJdbcJar(String path) {
        List<String> jdbcJars = this.makeModifiableJdbcJarList();
        logger.debug((Object)("Removing jdbc jar " + path + " at index " + jdbcJars.indexOf(path)));
        if (jdbcJars.contains(path)) {
            jdbcJars.remove(path);
        } else {
            File file = new File(path);
            jdbcJars.remove("builtin:" + file.getName());
        }
        this.setJdbcJarList(jdbcJars);
    }

    public String toString() {
        return "DataSourceType: " + this.properties;
    }

    public void checkConnectPrereqs() throws SQLException {
        if (this.getJdbcDriver() == null || this.getJdbcDriver().trim().length() == 0) {
            throw new SQLException("Data Source Type \"" + this.getName() + "\" has no JDBC Driver class specified.");
        }
    }

    private void putPropertyImpl(String javaPropName, String plPropName, String propValue) {
        String oldValue = this.properties.get(plPropName);
        this.properties.put(plPropName, propValue);
        this.classLoader = this.getClassLoaderFromCache();
        if (javaPropName != null) {
            this.firePropertyChange(javaPropName, oldValue, propValue);
        }
        if (oldValue == null && propValue != null || oldValue != null && !oldValue.equals(propValue)) {
            UndoablePropertyEdit edit = new UndoablePropertyEdit(plPropName, oldValue, propValue, this);
            for (int i = this.undoableEditListeners.size() - 1; i >= 0; --i) {
                this.undoableEditListeners.get(i).undoableEditHappened(new UndoableEditEvent(this, edit));
            }
        }
    }

    public void addUndoableEditListener(UndoableEditListener l) {
        this.undoableEditListeners.add(l);
    }

    public void removeUndoableEditListener(UndoableEditListener l) {
        this.undoableEditListeners.remove(l);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this.pcs.firePropertyChange(evt);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
    }

    public URI getServerBaseUri() {
        return this.serverBaseUri;
    }

    static class JDBCClassLoader
    extends ClassLoader {
        private final URI serverBaseUri;
        private final List<String> classpath;

        protected JDBCClassLoader(URI serverBaseUri, List<String> classpath) {
            super(JDBCClassLoader.class.getClassLoader());
            this.serverBaseUri = serverBaseUri;
            this.classpath = classpath;
            for (String jarPath : classpath) {
                if (!jarPath.startsWith("server:") || serverBaseUri != null) continue;
                throw new IllegalStateException("Found a server-based JAR file \"" + jarPath + "\" on the" + " classpath but there is no server base URI configured");
            }
            logger.debug((Object)("Created new JDBC Classloader @" + System.identityHashCode(this)));
            Policy.setPolicy(new Policy(){

                @Override
                public PermissionCollection getPermissions(CodeSource codesource) {
                    Permissions perms = new Permissions();
                    perms.add(new AllPermission());
                    return perms;
                }

                @Override
                public void refresh() {
                }
            });
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            if (logger.isDebugEnabled()) {
                Integer count = (Integer)classLoadCounts.get(name);
                count = count == null ? new Integer(1) : Integer.valueOf(count + 1);
                classLoadCounts.put(name, count);
                logger.debug((Object)("JDBC Classloader @" + System.identityHashCode(this) + ": Looking for class " + name + " (count = " + count + ")"));
            }
            for (String jarFileName : this.classpath) {
                try {
                    int offs;
                    JarURLConnection jarConnection;
                    logger.debug((Object)("checking file " + jarFileName));
                    URL jarLocation = JDBCDataSource.jarSpecToFile(jarFileName, this.getParent(), this.serverBaseUri);
                    if (jarLocation == null) continue;
                    String jarEntryPath = name.replace('.', '/') + ".class";
                    URL url = new URL("jar:" + jarLocation.toString() + "!/" + jarEntryPath);
                    try {
                        jarConnection = (JarURLConnection)url.openConnection();
                    }
                    catch (IOException ex) {
                        logger.debug((Object)("Skipping non-existant JAR file " + jarFileName));
                        continue;
                    }
                    JarEntry ent = jarConnection.getJarEntry();
                    byte[] buf = new byte[(int)ent.getSize()];
                    InputStream is = jarConnection.getInputStream();
                    int n = 0;
                    for (offs = 0; (n = is.read(buf, offs, buf.length - offs)) >= 0 && offs < buf.length; offs += n) {
                    }
                    int total = offs;
                    if ((long)total != ent.getSize()) {
                        logger.warn((Object)("What gives?  ZipEntry " + ent.getName() + " is " + ent.getSize() + " bytes long, but we only read " + total + " bytes!"));
                    }
                    return this.defineClass(name, buf, 0, buf.length);
                }
                catch (IOException ex) {
                }
            }
            String errorMsg = "Could not locate class " + name + " in any of the JDBC Driver JAR files: " + this.classpath;
            logger.debug((Object)errorMsg);
            throw new ClassNotFoundException(errorMsg);
        }

        @Override
        protected URL findResource(String name) {
            Enumeration<URL> resources = this.findResources(name);
            if (resources.hasMoreElements()) {
                return resources.nextElement();
            }
            return null;
        }

        @Override
        protected Enumeration<URL> findResources(String name) {
            logger.debug((Object)("Looking for all resources with path " + name));
            ArrayList<URL> results = new ArrayList<URL>();
            for (String jarName : this.classpath) {
                logger.debug((Object)("Converting JAR name: " + jarName));
                URL jarLocation = JDBCDataSource.jarSpecToFile(jarName, this.getParent(), this.serverBaseUri);
                logger.debug((Object)("  JAR is " + jarLocation));
                try {
                    JarURLConnection jarConnection;
                    if (jarLocation == null) {
                        logger.debug((Object)("  Skipping non-existant JAR file " + jarName));
                        continue;
                    }
                    logger.debug((Object)("  Searching JAR " + jarLocation));
                    URL url = new URL("jar:" + jarLocation.toString() + "!/" + name);
                    try {
                        jarConnection = (JarURLConnection)url.openConnection();
                    }
                    catch (IOException ex) {
                        logger.debug((Object)("Skipping non-existant JAR file " + jarLocation));
                        continue;
                    }
                    JarEntry ent = jarConnection.getJarEntry();
                    if (ent == null) continue;
                    results.add(url);
                    logger.debug((Object)("    Found entry " + name));
                }
                catch (IOException ex) {
                    logger.debug((Object)("  IO Exception while searching " + jarLocation + " for resource " + name + ". Continuing..."), (Throwable)ex);
                }
            }
            return Collections.enumeration(results);
        }
    }

    private class UndoablePropertyEdit
    extends AbstractUndoableEdit {
        private final String changedProperty;
        private final String oldValue;
        private final String newValue;
        private final JDBCDataSourceType source;

        public UndoablePropertyEdit(String propertyName, String oldValue, String newValue, JDBCDataSourceType source) {
            this.changedProperty = propertyName;
            this.oldValue = oldValue;
            this.newValue = newValue;
            this.source = source;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.source.properties.put(this.changedProperty, this.newValue);
            this.source.classLoader = JDBCDataSourceType.this.getClassLoaderFromCache();
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.source.properties.put(this.changedProperty, this.oldValue);
            this.source.classLoader = JDBCDataSourceType.this.getClassLoaderFromCache();
        }
    }
}

