/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FailoverServerPortPlaceHolder;
import com.microsoft.sqlserver.jdbc.SQLServerConnection;
import com.microsoft.sqlserver.jdbc.SQLServerConnectionSecurityManager;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import java.text.MessageFormat;
import java.util.logging.Level;

final class FailoverInfo {
    private String failoverPartner;
    private boolean useFailoverPartner;
    private int portNumber;
    private SQLServerConnectionSecurityManager securityManager;

    FailoverInfo(String string, SQLServerConnection sQLServerConnection, boolean bl) {
        this.failoverPartner = string;
        this.useFailoverPartner = bl;
        this.portNumber = -1;
    }

    void log(SQLServerConnection sQLServerConnection) {
        if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
            sQLServerConnection.getConnectionLogger().fine("Failover server :" + this.failoverPartner + " Failover partner is primary : " + this.useFailoverPartner);
        }
    }

    private void setupInfo(SQLServerConnection sQLServerConnection) throws SQLServerException {
        if (0 == this.failoverPartner.length()) {
            this.failoverPartner = null;
        } else {
            int n = this.failoverPartner.indexOf(92);
            String string = null;
            String string2 = null;
            if (n >= 0) {
                string2 = this.failoverPartner.substring(n + 1, this.failoverPartner.length());
                this.failoverPartner = this.failoverPartner.substring(0, n);
                sQLServerConnection.ValidateMaxSQLLoginName("instanceName", string2);
                string = sQLServerConnection.getInstancePort(this.failoverPartner, string2);
                try {
                    this.portNumber = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidPortNumber"));
                    Object[] objectArray = new Object[]{string};
                    SQLServerException.makeFromDriverError(sQLServerConnection, null, messageFormat.format(objectArray), null, false);
                }
            } else {
                this.portNumber = 1433;
            }
        }
        this.securityManager = new SQLServerConnectionSecurityManager(this.failoverPartner, this.portNumber);
    }

    synchronized FailoverServerPortPlaceHolder failoverPermissionCheck(SQLServerConnection sQLServerConnection, boolean bl) throws SQLServerException {
        if (null == this.securityManager) {
            this.setupInfo(sQLServerConnection);
        }
        this.securityManager.checkConnect();
        if (bl) {
            this.securityManager.checkLink();
        }
        return new FailoverServerPortPlaceHolder(this.failoverPartner, this.useFailoverPartner, this.portNumber);
    }

    synchronized void failoverAdd(SQLServerConnection sQLServerConnection, boolean bl, String string) throws SQLServerException {
        if (this.useFailoverPartner != bl) {
            if (sQLServerConnection.getConnectionLogger().isLoggable(Level.FINE)) {
                sQLServerConnection.getConnectionLogger().fine("Failover detected. failover partner=" + string);
            }
            this.useFailoverPartner = bl;
        }
        if (!bl && !this.failoverPartner.equals(string)) {
            this.failoverPartner = string;
        }
    }
}

