/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.io.PushbackReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import org.armedbear.lisp.util.RACFMalformedInputException;
import org.armedbear.lisp.util.RACFUnmappableCharacterException;

public class RandomAccessCharacterFile {
    static Reader staticReader = new StringReader("");
    static final int BUFSIZ = 4096;
    private RandomAccessWriter writer;
    private RandomAccessReader reader;
    private RandomAccessInputStream inputStream;
    private RandomAccessOutputStream outputStream;
    private FileChannel fcn;
    private Charset cset;
    private CharsetEncoder cenc;
    private CharsetDecoder cdec;
    private ByteBuffer bbuf;
    private boolean bbufIsDirty;
    private boolean bbufIsReadable;
    private long bbufpos;
    private CharBuffer singleCharBuf;
    private ByteBuffer shortByteBuf;

    public RandomAccessCharacterFile(RandomAccessFile raf, String encoding) throws IOException {
        this.fcn = raf.getChannel();
        this.setEncoding(encoding);
        this.bbuf = ByteBuffer.allocate(4096);
        this.bbuf.flip();
        this.bbufIsDirty = false;
        this.bbufIsReadable = false;
        this.bbufpos = this.fcn.position();
        this.reader = new RandomAccessReader();
        this.writer = new RandomAccessWriter();
        this.inputStream = new RandomAccessInputStream();
        this.outputStream = new RandomAccessOutputStream();
    }

    public void setEncoding(String encoding) {
        this.cset = encoding == null ? Charset.defaultCharset() : Charset.forName(encoding);
        this.cdec = this.cset.newDecoder();
        this.cdec.onMalformedInput(CodingErrorAction.REPLACE);
        this.cdec.onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.cenc = this.cset.newEncoder();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public PushbackReader getReader() {
        return this.reader;
    }

    public PushbackInputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public final void close() throws IOException {
        this.internalFlush(true);
        this.fcn.close();
    }

    public final void flush() throws IOException {
        this.internalFlush(false);
    }

    private final boolean ensureReadBbuf(boolean force) throws IOException {
        boolean bufReady = true;
        if (this.bbuf.remaining() == 0 || force || !this.bbufIsReadable) {
            if (this.bbufIsDirty) {
                this.bbuf.flip();
                this.fcn.position(this.bbufpos);
                this.fcn.write(this.bbuf);
                this.bbufpos += (long)this.bbuf.position();
                this.bbuf.clear();
            } else {
                int bbufEnd = this.bbufIsReadable ? this.bbuf.limit() : this.bbuf.position();
                this.fcn.position(this.bbufpos + (long)bbufEnd);
                this.bbufpos += (long)this.bbuf.position();
                this.bbuf.compact();
            }
            bufReady = this.fcn.read(this.bbuf) != -1;
            this.bbuf.flip();
            this.bbufIsReadable = true;
        }
        return bufReady;
    }

    final int read(char[] cb, int off, int len) throws IOException {
        CharBuffer cbuf = CharBuffer.wrap(cb, off, len);
        boolean decodeWasUnderflow = false;
        boolean atEof = false;
        while (cbuf.remaining() > 0 && !atEof) {
            int oldRemaining = cbuf.remaining();
            atEof = !this.ensureReadBbuf(decodeWasUnderflow);
            CoderResult r = this.cdec.decode(this.bbuf, cbuf, atEof);
            if (oldRemaining == cbuf.remaining() && CoderResult.OVERFLOW == r) {
                cbuf.put('?');
                this.bbuf.get();
            }
            decodeWasUnderflow = CoderResult.UNDERFLOW == r;
        }
        if (cbuf.remaining() == len) {
            return -1;
        }
        return len - cbuf.remaining();
    }

    final void write(char[] cb, int off, int len) throws IOException {
        CharBuffer cbuf = CharBuffer.wrap(cb, off, len);
        this.encodeAndWrite(cbuf, false, false);
    }

    private final void internalFlush(boolean endOfFile) throws IOException {
        if (endOfFile) {
            CharBuffer cbuf = CharBuffer.allocate(0);
            this.encodeAndWrite(cbuf, true, endOfFile);
        } else {
            this.flushBbuf(false);
        }
    }

    private final void encodeAndWrite(CharBuffer cbuf, boolean flush, boolean endOfFile) throws IOException {
        while (cbuf.remaining() > 0) {
            CoderResult r = this.cenc.encode(cbuf, this.bbuf, endOfFile);
            this.bbufIsDirty = true;
            if (CoderResult.OVERFLOW == r || this.bbuf.remaining() == 0) {
                this.flushBbuf(false);
                this.bbuf.clear();
            }
            if (r.isUnmappable()) {
                throw new RACFUnmappableCharacterException(cbuf.position(), cbuf.charAt(cbuf.position()), this.cset.name());
            }
            if (!r.isMalformed()) continue;
            throw new RACFMalformedInputException(cbuf.position(), cbuf.charAt(cbuf.position()), this.cset.name());
        }
        if (this.bbuf.position() > 0 && this.bbufIsDirty && flush) {
            this.flushBbuf(false);
        }
    }

    public final void position(long newPosition) throws IOException {
        this.flushBbuf(true);
        long bbufend = this.bbufpos + (long)(this.bbufIsReadable ? this.bbuf.limit() : this.bbuf.position());
        if (newPosition >= this.bbufpos && newPosition < bbufend) {
            this.bbuf.position((int)(newPosition - this.bbufpos));
        } else {
            this.fcn.position(newPosition);
            this.bbuf.clear();
            this.bbuf.flip();
            this.bbufpos = newPosition;
        }
    }

    public final long position() throws IOException {
        return this.bbufpos + (long)this.bbuf.position();
    }

    public final long length() throws IOException {
        this.flushBbuf(false);
        return this.fcn.size();
    }

    private final void flushBbuf(boolean commitOnly) throws IOException {
        if (!this.bbufIsDirty) {
            return;
        }
        this.fcn.position(this.bbufpos);
        if (commitOnly || this.bbufIsReadable) {
            ByteBuffer dup = this.bbuf.duplicate();
            dup.flip();
            this.fcn.write(dup);
            return;
        }
        this.bbuf.flip();
        this.fcn.write(this.bbuf);
        this.bbufpos += (long)this.bbuf.position();
        this.bbuf.clear();
        this.bbuf.flip();
        this.bbufIsDirty = false;
        this.bbufIsReadable = false;
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        int pos = off;
        boolean atEof = false;
        while (pos - off < len && !atEof) {
            atEof = !this.ensureReadBbuf(false);
            int want = len - pos;
            if (want > this.bbuf.remaining()) {
                want = this.bbuf.remaining();
            }
            this.bbuf.get(b, pos, want);
            pos += want;
        }
        return pos - off;
    }

    public final void unreadChar(char c) throws IOException {
        if (this.singleCharBuf == null) {
            this.singleCharBuf = CharBuffer.allocate(1);
            this.shortByteBuf = ByteBuffer.allocate((int)this.cenc.maxBytesPerChar());
        }
        this.singleCharBuf.clear();
        this.singleCharBuf.append(c);
        this.singleCharBuf.flip();
        this.shortByteBuf.clear();
        this.cenc.encode(this.singleCharBuf, this.shortByteBuf, false);
        int n = this.shortByteBuf.position();
        long pos = this.position() - (long)n;
        this.position(pos);
    }

    public final void unreadByte(byte b) throws IOException {
        long pos = this.position() - 1L;
        this.position(pos);
    }

    final void write(byte[] b, int off, int len) throws IOException {
        int want;
        for (int pos = off; pos < off + len; pos += want) {
            want = len - pos + off;
            if (want > this.bbuf.remaining()) {
                want = this.bbuf.remaining();
            }
            this.bbuf.put(b, pos, want);
            this.bbufIsDirty = true;
            if (this.bbuf.remaining() != 0) continue;
            this.flushBbuf(false);
            this.bbuf.clear();
        }
    }

    private class RandomAccessWriter
    extends Writer {
        RandomAccessWriter() {
        }

        public final void close() throws IOException {
            RandomAccessCharacterFile.this.close();
        }

        public final void flush() throws IOException {
            RandomAccessCharacterFile.this.flush();
        }

        public final void write(char[] cb, int off, int len) throws IOException {
            RandomAccessCharacterFile.this.write(cb, off, len);
        }
    }

    private class RandomAccessReader
    extends PushbackReader {
        private char[] read_buf;

        RandomAccessReader() {
            super(staticReader);
            this.read_buf = new char[1];
        }

        public final void close() throws IOException {
            RandomAccessCharacterFile.this.close();
        }

        public final int read() throws IOException {
            int n = this.read(this.read_buf);
            if (n == 1) {
                return this.read_buf[0];
            }
            return -1;
        }

        public final void unread(int c) throws IOException {
            RandomAccessCharacterFile.this.unreadChar((char)c);
        }

        public final void unread(char[] cbuf, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.unread(cbuf[off + i]);
            }
        }

        public final void unread(char[] cbuf) throws IOException {
            this.unread(cbuf, 0, cbuf.length);
        }

        public final int read(CharBuffer target) throws IOException {
            throw new IOException("Not implemented");
        }

        public final int read(char[] cbuf) throws IOException {
            return RandomAccessCharacterFile.this.read(cbuf, 0, cbuf.length);
        }

        public final int read(char[] cb, int off, int len) throws IOException {
            return RandomAccessCharacterFile.this.read(cb, off, len);
        }

        public final boolean ready() throws IOException {
            return true;
        }
    }

    private class RandomAccessOutputStream
    extends OutputStream {
        private byte[] buf = new byte[1];

        RandomAccessOutputStream() {
        }

        public final void write(int b) throws IOException {
            this.buf[0] = (byte)b;
            RandomAccessCharacterFile.this.write(this.buf, 0, 1);
        }

        public final void write(byte[] b) throws IOException {
            RandomAccessCharacterFile.this.write(b, 0, b.length);
        }

        public final void write(byte[] b, int off, int len) throws IOException {
            RandomAccessCharacterFile.this.write(b, off, len);
        }

        public final void flush() throws IOException {
            RandomAccessCharacterFile.this.flush();
        }

        public final void close() throws IOException {
            RandomAccessCharacterFile.this.close();
        }
    }

    private class RandomAccessInputStream
    extends PushbackInputStream {
        private byte[] read_buf;

        public RandomAccessInputStream() {
            super(null);
            this.read_buf = new byte[1];
        }

        public final int read() throws IOException {
            int len = this.read(this.read_buf);
            if (len == 1) {
                return 0xFF & this.read_buf[0];
            }
            return -1;
        }

        public final int read(byte[] b, int off, int len) throws IOException {
            return RandomAccessCharacterFile.this.read(b, off, len);
        }

        public final void unread(int b) throws IOException {
            RandomAccessCharacterFile.this.unreadByte((byte)b);
        }

        public final void unread(byte[] b, int off, int len) throws IOException {
            for (int i = 0; i < len; ++i) {
                this.unread(b[off + i]);
            }
        }

        public final void unread(byte[] b) throws IOException {
            this.unread(b, 0, b.length);
        }

        public final int available() throws IOException {
            return (int)(RandomAccessCharacterFile.this.length() - RandomAccessCharacterFile.this.position());
        }

        public final synchronized void mark(int readlimit) {
        }

        public final boolean markSupported() {
            return false;
        }

        public final synchronized void reset() throws IOException {
            throw new IOException("Operation not supported");
        }

        public final long skip(long n) throws IOException {
            RandomAccessCharacterFile.this.position(RandomAccessCharacterFile.this.position() + n);
            return n;
        }

        public final int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public final void close() throws IOException {
            RandomAccessCharacterFile.this.close();
        }
    }
}

