/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import org.armedbear.lisp.AbstractString;
import org.armedbear.lisp.JavaObject;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SimpleString;
import org.armedbear.lisp.Symbol;

public final class jclass_name
extends Primitive {
    private static final Primitive JCLASS_NAME = new jclass_name();

    private jclass_name() {
        super(Symbol.JCLASS_NAME, "class-ref &optional name", "When called with one argument, returns the name of the Java class\n  designated by CLASS-REF. When called with two arguments, tests\n  whether CLASS-REF matches NAME.");
    }

    public LispObject execute(LispObject arg) {
        Object obj;
        if (arg instanceof AbstractString) {
            String s = arg.getStringValue();
            try {
                return new SimpleString(Class.forName(s).getName());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        } else if (arg instanceof JavaObject && (obj = ((JavaObject)arg).getObject()) instanceof Class) {
            return new SimpleString(((Class)obj).getName());
        }
        return Lisp.error(new LispError(arg.princToString() + " does not designate a Java class."));
    }

    public LispObject execute(LispObject first, LispObject second) {
        Object obj;
        String className = null;
        if (first instanceof AbstractString) {
            String s = first.getStringValue();
            try {
                className = Class.forName(s).getName();
            }
            catch (ClassNotFoundException e) {}
        } else if (first instanceof JavaObject && (obj = ((JavaObject)first).getObject()) instanceof Class) {
            className = ((Class)obj).getName();
        }
        if (className == null) {
            return Lisp.error(new LispError(first.princToString() + " does not designate a Java class."));
        }
        AbstractString name = Lisp.checkString(second);
        return LispThread.currentThread().setValues(name.getStringValue().equals(className) ? Lisp.T : Lisp.NIL, new SimpleString(className));
    }
}

