/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.math.BigInteger;
import org.armedbear.lisp.ArithmeticError;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Complex;
import org.armedbear.lisp.DivisionByZero;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class Ratio
extends LispObject {
    private BigInteger numerator;
    private BigInteger denominator;

    public Ratio(BigInteger numerator, BigInteger denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public BigInteger numerator() {
        return this.numerator;
    }

    public LispObject NUMERATOR() {
        return Lisp.number(this.numerator);
    }

    public BigInteger denominator() {
        return this.denominator;
    }

    public LispObject DENOMINATOR() {
        return Lisp.number(this.denominator);
    }

    public LispObject typeOf() {
        return Symbol.RATIO;
    }

    public LispObject classOf() {
        return BuiltInClass.RATIO;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.RATIO) {
            return Lisp.T;
        }
        if (type == Symbol.RATIONAL) {
            return Lisp.T;
        }
        if (type == Symbol.REAL) {
            return Lisp.T;
        }
        if (type == Symbol.NUMBER) {
            return Lisp.T;
        }
        if (type == BuiltInClass.RATIO) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean numberp() {
        return true;
    }

    public boolean rationalp() {
        return true;
    }

    public boolean realp() {
        return true;
    }

    public boolean eql(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Ratio) {
            return this.numerator.equals(((Ratio)obj).numerator) && this.denominator.equals(((Ratio)obj).denominator);
        }
        return false;
    }

    public boolean equal(LispObject obj) {
        return this.eql(obj);
    }

    public boolean equalp(LispObject obj) {
        if (obj instanceof Ratio) {
            return this.numerator.equals(((Ratio)obj).numerator) && this.denominator.equals(((Ratio)obj).denominator);
        }
        if (obj instanceof SingleFloat) {
            return this.floatValue() == ((SingleFloat)obj).value;
        }
        if (obj instanceof DoubleFloat) {
            return this.doubleValue() == ((DoubleFloat)obj).value;
        }
        return false;
    }

    public LispObject ABS() {
        if (this.numerator.signum() > 0 && this.denominator.signum() > 0) {
            return this;
        }
        if (this.numerator.signum() < 0 && this.denominator.signum() < 0) {
            return this;
        }
        return new Ratio(this.numerator.negate(), this.denominator);
    }

    public boolean plusp() {
        return this.numerator.signum() == this.denominator.signum();
    }

    public boolean minusp() {
        return this.numerator.signum() != this.denominator.signum();
    }

    public boolean zerop() {
        return false;
    }

    public float floatValue() {
        float result = (float)this.doubleValue();
        if (Float.isInfinite(result) && Lisp.TRAP_OVERFLOW) {
            Lisp.type_error(this, Symbol.SINGLE_FLOAT);
        }
        return (float)this.doubleValue();
    }

    public double doubleValue() {
        int denLen;
        double result = this.numerator.doubleValue() / this.denominator.doubleValue();
        if (result != 0.0 && !Double.isNaN(result) && !Double.isInfinite(result)) {
            return result;
        }
        boolean negative = this.numerator.signum() < 0;
        BigInteger num = negative ? this.numerator.negate() : this.numerator;
        BigInteger den = this.denominator;
        int numLen = num.bitLength();
        int length = Math.min(numLen, denLen = den.bitLength());
        if (length <= 1) {
            return result;
        }
        BigInteger n = num;
        BigInteger d = den;
        int digits = 54;
        if (length > 54) {
            n = n.shiftRight(length - 54);
            d = d.shiftRight(length - 54);
            length -= 54;
        } else {
            n = n.shiftRight(1);
            d = d.shiftRight(1);
            --length;
        }
        for (int i = 0; i < length && ((result = n.doubleValue() / d.doubleValue()) == 0.0 || Double.isNaN(result) || Double.isInfinite(result)); ++i) {
            n = n.shiftRight(1);
            d = d.shiftRight(1);
        }
        if (Double.isInfinite(result) && Lisp.TRAP_OVERFLOW) {
            Lisp.type_error(this, Symbol.DOUBLE_FLOAT);
        }
        return negative ? -result : result;
    }

    public final LispObject incr() {
        return new Ratio(this.numerator.add(this.denominator), this.denominator);
    }

    public final LispObject decr() {
        return new Ratio(this.numerator.subtract(this.denominator), this.denominator);
    }

    public LispObject add(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n = this.numerator.add(BigInteger.valueOf(((Fixnum)obj).value).multiply(this.denominator));
            return Lisp.number(n, this.denominator);
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.numerator.add(n.multiply(this.denominator)), this.denominator);
        }
        if (obj instanceof Ratio) {
            BigInteger n = ((Ratio)obj).numerator;
            BigInteger d = ((Ratio)obj).denominator;
            if (this.denominator.equals(d)) {
                return Lisp.number(this.numerator.add(n), this.denominator);
            }
            BigInteger common = this.denominator.multiply(d);
            return Lisp.number(this.numerator.multiply(d).add(n.multiply(this.denominator)), common);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() + ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() + ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.add(c.getRealPart()), c.getImaginaryPart());
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject subtract(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n = this.numerator.subtract(BigInteger.valueOf(((Fixnum)obj).value).multiply(this.denominator));
            return Lisp.number(n, this.denominator);
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.numerator.subtract(n.multiply(this.denominator)), this.denominator);
        }
        if (obj instanceof Ratio) {
            BigInteger n = ((Ratio)obj).numerator;
            BigInteger d = ((Ratio)obj).denominator;
            if (this.denominator.equals(d)) {
                return Lisp.number(this.numerator.subtract(n), this.denominator);
            }
            BigInteger common = this.denominator.multiply(d);
            return Lisp.number(this.numerator.multiply(d).subtract(n.multiply(this.denominator)), common);
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() - ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() - ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.subtract(c.getRealPart()), Fixnum.ZERO.subtract(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject multiplyBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n = ((Fixnum)obj).getBigInteger();
            return Lisp.number(this.numerator.multiply(n), this.denominator);
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.numerator.multiply(n), this.denominator);
        }
        if (obj instanceof Ratio) {
            BigInteger n = ((Ratio)obj).numerator;
            BigInteger d = ((Ratio)obj).denominator;
            return Lisp.number(this.numerator.multiply(n), this.denominator.multiply(d));
        }
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue() * ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue() * ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            return Complex.getInstance(this.multiplyBy(c.getRealPart()), this.multiplyBy(c.getImaginaryPart()));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public LispObject divideBy(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n = ((Fixnum)obj).getBigInteger();
            return Lisp.number(this.numerator, this.denominator.multiply(n));
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value;
            return Lisp.number(this.numerator, this.denominator.multiply(n));
        }
        if (obj instanceof Ratio) {
            BigInteger n = ((Ratio)obj).numerator;
            BigInteger d = ((Ratio)obj).denominator;
            return Lisp.number(this.numerator.multiply(d), this.denominator.multiply(n));
        }
        if (obj instanceof SingleFloat) {
            if (obj.zerop()) {
                return Lisp.error(new DivisionByZero());
            }
            return new SingleFloat(this.floatValue() / ((SingleFloat)obj).value);
        }
        if (obj instanceof DoubleFloat) {
            if (obj.zerop()) {
                return Lisp.error(new DivisionByZero());
            }
            return new DoubleFloat(this.doubleValue() / ((DoubleFloat)obj).value);
        }
        if (obj instanceof Complex) {
            Complex c = (Complex)obj;
            LispObject realPart = this.multiplyBy(c.getRealPart());
            LispObject imagPart = Fixnum.ZERO.subtract(this).multiplyBy(c.getImaginaryPart());
            LispObject d = c.getRealPart().multiplyBy(c.getRealPart());
            d = d.add(c.getImaginaryPart().multiplyBy(c.getImaginaryPart()));
            return Complex.getInstance(realPart.divideBy(d), imagPart.divideBy(d));
        }
        return Lisp.type_error(obj, Symbol.NUMBER);
    }

    public boolean isEqualTo(LispObject obj) {
        if (obj instanceof Ratio) {
            return this.numerator.equals(((Ratio)obj).numerator) && this.denominator.equals(((Ratio)obj).denominator);
        }
        if (obj instanceof SingleFloat) {
            return this.isEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isEqualTo(((DoubleFloat)obj).rational());
        }
        if (obj.numberp()) {
            return false;
        }
        Lisp.type_error(obj, Symbol.NUMBER);
        return false;
    }

    public boolean isNotEqualTo(LispObject obj) {
        return !this.isEqualTo(obj);
    }

    public boolean isLessThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n2 = ((Fixnum)obj).getBigInteger().multiply(this.denominator);
            return this.numerator.compareTo(n2) < 0;
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value.multiply(this.denominator);
            return this.numerator.compareTo(n) < 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n2;
            BigInteger n1 = this.numerator.multiply(((Ratio)obj).denominator);
            return n1.compareTo(n2 = ((Ratio)obj).numerator.multiply(this.denominator)) < 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThan(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n2 = ((Fixnum)obj).getBigInteger().multiply(this.denominator);
            return this.numerator.compareTo(n2) > 0;
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value.multiply(this.denominator);
            return this.numerator.compareTo(n) > 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n2;
            BigInteger n1 = this.numerator.multiply(((Ratio)obj).denominator);
            return n1.compareTo(n2 = ((Ratio)obj).numerator.multiply(this.denominator)) > 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThan(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThan(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isLessThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n2 = ((Fixnum)obj).getBigInteger().multiply(this.denominator);
            return this.numerator.compareTo(n2) <= 0;
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value.multiply(this.denominator);
            return this.numerator.compareTo(n) <= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n2;
            BigInteger n1 = this.numerator.multiply(((Ratio)obj).denominator);
            return n1.compareTo(n2 = ((Ratio)obj).numerator.multiply(this.denominator)) <= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isLessThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isLessThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public boolean isGreaterThanOrEqualTo(LispObject obj) {
        if (obj instanceof Fixnum) {
            BigInteger n2 = ((Fixnum)obj).getBigInteger().multiply(this.denominator);
            return this.numerator.compareTo(n2) >= 0;
        }
        if (obj instanceof Bignum) {
            BigInteger n = ((Bignum)obj).value.multiply(this.denominator);
            return this.numerator.compareTo(n) >= 0;
        }
        if (obj instanceof Ratio) {
            BigInteger n2;
            BigInteger n1 = this.numerator.multiply(((Ratio)obj).denominator);
            return n1.compareTo(n2 = ((Ratio)obj).numerator.multiply(this.denominator)) >= 0;
        }
        if (obj instanceof SingleFloat) {
            return this.isGreaterThanOrEqualTo(((SingleFloat)obj).rational());
        }
        if (obj instanceof DoubleFloat) {
            return this.isGreaterThanOrEqualTo(((DoubleFloat)obj).rational());
        }
        Lisp.type_error(obj, Symbol.REAL);
        return false;
    }

    public LispObject truncate(LispObject obj) {
        if (obj instanceof SingleFloat) {
            return new SingleFloat(this.floatValue()).truncate(obj);
        }
        if (obj instanceof DoubleFloat) {
            return new DoubleFloat(this.doubleValue()).truncate(obj);
        }
        try {
            BigInteger d;
            BigInteger n;
            if (obj instanceof Fixnum) {
                n = ((Fixnum)obj).getBigInteger();
                d = BigInteger.ONE;
            } else if (obj instanceof Bignum) {
                n = ((Bignum)obj).value;
                d = BigInteger.ONE;
            } else if (obj instanceof Ratio) {
                n = ((Ratio)obj).numerator();
                d = ((Ratio)obj).denominator();
            } else {
                return Lisp.type_error(obj, Symbol.NUMBER);
            }
            BigInteger num = this.numerator.multiply(d);
            BigInteger den = this.denominator.multiply(n);
            BigInteger quotient = num.divide(den);
            LispObject product = Lisp.number(quotient.multiply(n), d);
            LispObject remainder = this.subtract(product);
            return LispThread.currentThread().setValues(Lisp.number(quotient), remainder);
        }
        catch (ArithmeticException e) {
            if (obj.zerop()) {
                return Lisp.error(new DivisionByZero());
            }
            return Lisp.error(new ArithmeticError(e.getMessage()));
        }
    }

    public int hashCode() {
        return this.numerator.hashCode() ^ this.denominator.hashCode();
    }

    public String printObject() {
        LispThread thread = LispThread.currentThread();
        int base = Fixnum.getValue(Symbol.PRINT_BASE.symbolValue(thread));
        StringBuffer sb = new StringBuffer(this.numerator.toString(base));
        sb.append('/');
        sb.append(this.denominator.toString(base));
        String s = sb.toString().toUpperCase();
        if (Symbol.PRINT_RADIX.symbolValue(thread) != Lisp.NIL) {
            sb.setLength(0);
            switch (base) {
                case 2: {
                    sb.append("#b");
                    sb.append(s);
                    break;
                }
                case 8: {
                    sb.append("#o");
                    sb.append(s);
                    break;
                }
                case 10: {
                    sb.append("#10r");
                    sb.append(s);
                    break;
                }
                case 16: {
                    sb.append("#x");
                    sb.append(s);
                    break;
                }
                default: {
                    sb.append('#');
                    sb.append(String.valueOf(base));
                    sb.append('r');
                    sb.append(s);
                }
            }
            s = sb.toString();
        }
        return s;
    }
}

