/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.Random;
import org.armedbear.lisp.Bignum;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.DoubleFloat;
import org.armedbear.lisp.Fixnum;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispError;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.Primitive;
import org.armedbear.lisp.SingleFloat;
import org.armedbear.lisp.Symbol;

public final class RandomState
extends LispObject {
    private Random random;
    private static final Primitive RANDOM = new Primitive(Symbol.RANDOM, "limit &optional random-state"){

        public LispObject execute(LispObject arg) {
            RandomState randomState = (RandomState)Symbol._RANDOM_STATE_.symbolValue();
            return randomState.random(arg);
        }

        public LispObject execute(LispObject first, LispObject second) {
            if (second instanceof RandomState) {
                RandomState randomState = (RandomState)second;
                return randomState.random(first);
            }
            return Lisp.type_error(first, Symbol.RANDOM_STATE);
        }
    };
    private static final Primitive MAKE_RANDOM_STATE = new Primitive(Symbol.MAKE_RANDOM_STATE, "&optional state"){

        public LispObject execute() {
            return new RandomState((RandomState)Symbol._RANDOM_STATE_.symbolValue());
        }

        public LispObject execute(LispObject arg) {
            if (arg == Lisp.NIL) {
                return new RandomState((RandomState)Symbol._RANDOM_STATE_.symbolValue());
            }
            if (arg == Lisp.T) {
                return new RandomState();
            }
            if (arg instanceof RandomState) {
                return new RandomState((RandomState)arg);
            }
            return Lisp.type_error(arg, Symbol.RANDOM_STATE);
        }
    };
    private static final Primitive RANDOM_STATE_P = new Primitive(Symbol.RANDOM_STATE_P, "object"){

        public LispObject execute(LispObject arg) {
            return arg instanceof RandomState ? Lisp.T : Lisp.NIL;
        }
    };

    public RandomState() {
        this.random = new Random();
    }

    public RandomState(RandomState rs) {
        try {
            ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(byteOut);
            out.writeObject(rs.random);
            out.close();
            ByteArrayInputStream byteIn = new ByteArrayInputStream(byteOut.toByteArray());
            ObjectInputStream in = new ObjectInputStream(byteIn);
            this.random = (Random)in.readObject();
            in.close();
        }
        catch (Throwable t) {
            Lisp.error(new LispError("Unable to copy random state."));
        }
    }

    public LispObject typeOf() {
        return Symbol.RANDOM_STATE;
    }

    public LispObject classOf() {
        return BuiltInClass.RANDOM_STATE;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.RANDOM_STATE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.RANDOM_STATE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public String printObject() {
        return this.unreadableString("RANDOM-STATE");
    }

    public LispObject random(LispObject arg) {
        double limit;
        if (arg instanceof Fixnum) {
            int limit2 = ((Fixnum)arg).value;
            if (limit2 > 0) {
                int n = this.random.nextInt(limit2);
                return Fixnum.getInstance(n);
            }
        } else if (arg instanceof Bignum) {
            BigInteger limit3 = ((Bignum)arg).value;
            if (limit3.signum() > 0) {
                int bitLength = limit3.bitLength();
                BigInteger rand = new BigInteger(bitLength + 1, this.random);
                BigInteger remainder = rand.remainder(limit3);
                return Lisp.number(remainder);
            }
        } else if (arg instanceof SingleFloat) {
            float limit4 = ((SingleFloat)arg).value;
            if (limit4 > 0.0f) {
                float rand = this.random.nextFloat();
                return new SingleFloat(rand * limit4);
            }
        } else if (arg instanceof DoubleFloat && (limit = ((DoubleFloat)arg).value) > 0.0) {
            double rand = this.random.nextDouble();
            return new DoubleFloat(rand * limit);
        }
        return Lisp.type_error(arg, Lisp.list(Symbol.OR, Lisp.list(Symbol.INTEGER, Fixnum.ONE), Lisp.list(Symbol.FLOAT, Lisp.list(Fixnum.ZERO, new LispObject[0]))));
    }
}

