if not modules then modules = { } end modules ['font-agl'] = {
    version   = 1.001,
    comment   = "companion to font-ini.mkiv",
    author    = "Hans Hagen, PRAGMA-ADE, Hasselt NL",
    copyright = "derived from http://www.adobe.com/devnet/opentype/archives/glyphlist.txt",
    original  = "Adobe Glyph List, version 2.0, September 20, 2002",
}

local allocate = utilities.storage.allocate

local names    = allocate {
    -- filled from char-def.lua
}
local unicodes = allocate {
    -- filled from char-def.lua
}

local extras   = allocate { -- private extensions
    Dcroat          = 0x0110,
    Delta           = 0x2206,
    Euro            = 0x20AC,
    H18533          = 0x25CF,
    H18543          = 0x25AA,
    H18551          = 0x25AB,
    H22073          = 0x25A1,
    Ldot            = 0x013F,
    Oslashacute     = 0x01FE,
    SF10000         = 0x250C,
    SF20000         = 0x2514,
    SF30000         = 0x2510,
    SF40000         = 0x2518,
    SF50000         = 0x253C,
    SF60000         = 0x252C,
    SF70000         = 0x2534,
    SF80000         = 0x251C,
    SF90000         = 0x2524,
    Upsilon1        = 0x03D2,
    afii10066       = 0x0431,
    afii10067       = 0x0432,
    afii10068       = 0x0433,
    afii10069       = 0x0434,
    afii10070       = 0x0435,
    afii10071       = 0x0451,
    afii10072       = 0x0436,
    afii10073       = 0x0437,
    afii10074       = 0x0438,
    afii10075       = 0x0439,
    afii10076       = 0x043A,
    afii10077       = 0x043B,
    afii10078       = 0x043C,
    afii10079       = 0x043D,
    afii10080       = 0x043E,
    afii10081       = 0x043F,
    afii10082       = 0x0440,
    afii10083       = 0x0441,
    afii10084       = 0x0442,
    afii10085       = 0x0443,
    afii10086       = 0x0444,
    afii10087       = 0x0445,
    afii10088       = 0x0446,
    afii10089       = 0x0447,
    afii10090       = 0x0448,
    afii10091       = 0x0449,
    afii10092       = 0x044A,
    afii10093       = 0x044B,
    afii10094       = 0x044C,
    afii10095       = 0x044D,
    afii10096       = 0x044E,
    afii10097       = 0x044F,
    afii10098       = 0x0491,
    afii10099       = 0x0452,
    afii10100       = 0x0453,
    afii10101       = 0x0454,
    afii10102       = 0x0455,
    afii10103       = 0x0456,
    afii10104       = 0x0457,
    afii10105       = 0x0458,
    afii10106       = 0x0459,
    afii10107       = 0x045A,
    afii10108       = 0x045B,
    afii10109       = 0x045C,
    afii10110       = 0x045E,
    afii10193       = 0x045F,
    afii10194       = 0x0463,
    afii10195       = 0x0473,
    afii10196       = 0x0475,
    afii10846       = 0x04D9,
    afii208         = 0x2015,
    afii57381       = 0x066A,
    afii57388       = 0x060C,
    afii57392       = 0x0660,
    afii57393       = 0x0661,
    afii57394       = 0x0662,
    afii57395       = 0x0663,
    afii57396       = 0x0664,
    afii57397       = 0x0665,
    afii57398       = 0x0666,
    afii57399       = 0x0667,
    afii57400       = 0x0668,
    afii57401       = 0x0669,
    afii57403       = 0x061B,
    afii57407       = 0x061F,
    afii57409       = 0x0621,
    afii57410       = 0x0622,
    afii57411       = 0x0623,
    afii57412       = 0x0624,
    afii57413       = 0x0625,
    afii57414       = 0x0626,
    afii57415       = 0x0627,
    afii57416       = 0x0628,
    afii57417       = 0x0629,
    afii57418       = 0x062A,
    afii57419       = 0x062B,
    afii57420       = 0x062C,
    afii57421       = 0x062D,
    afii57422       = 0x062E,
    afii57423       = 0x062F,
    afii57424       = 0x0630,
    afii57425       = 0x0631,
    afii57426       = 0x0632,
    afii57427       = 0x0633,
    afii57428       = 0x0634,
    afii57429       = 0x0635,
    afii57430       = 0x0636,
    afii57431       = 0x0637,
    afii57432       = 0x0638,
    afii57433       = 0x0639,
    afii57434       = 0x063A,
    afii57440       = 0x0640,
    afii57441       = 0x0641,
    afii57442       = 0x0642,
    afii57443       = 0x0643,
    afii57444       = 0x0644,
    afii57445       = 0x0645,
    afii57446       = 0x0646,
    afii57448       = 0x0648,
    afii57449       = 0x0649,
    afii57450       = 0x064A,
    afii57451       = 0x064B,
    afii57452       = 0x064C,
    afii57453       = 0x064D,
    afii57454       = 0x064E,
    afii57455       = 0x064F,
    afii57456       = 0x0650,
    afii57457       = 0x0651,
    afii57458       = 0x0652,
    afii57470       = 0x0647,
    afii57505       = 0x06A4,
    afii57506       = 0x067E,
    afii57507       = 0x0686,
    afii57508       = 0x0698,
    afii57509       = 0x06AF,
    afii57511       = 0x0679,
    afii57512       = 0x0688,
    afii57513       = 0x0691,
    afii57514       = 0x06BA,
    afii57519       = 0x06D2,
    afii57636       = 0x20AA,
    afii57645       = 0x05BE,
    afii57658       = 0x05C3,
    afii57664       = 0x05D0,
    afii57665       = 0x05D1,
    afii57666       = 0x05D2,
    afii57667       = 0x05D3,
    afii57668       = 0x05D4,
    afii57669       = 0x05D5,
    afii57670       = 0x05D6,
    afii57671       = 0x05D7,
    afii57672       = 0x05D8,
    afii57673       = 0x05D9,
    afii57674       = 0x05DA,
    afii57675       = 0x05DB,
    afii57676       = 0x05DC,
    afii57677       = 0x05DD,
    afii57678       = 0x05DE,
    afii57679       = 0x05DF,
    afii57680       = 0x05E0,
    afii57681       = 0x05E1,
    afii57682       = 0x05E2,
    afii57683       = 0x05E3,
    afii57684       = 0x05E4,
    afii57685       = 0x05E5,
    afii57686       = 0x05E6,
    afii57687       = 0x05E7,
    afii57688       = 0x05E8,
    afii57689       = 0x05E9,
    afii57690       = 0x05EA,
    afii57716       = 0x05F0,
    afii57717       = 0x05F1,
    afii57718       = 0x05F2,
    afii57793       = 0x05B4,
    afii57794       = 0x05B5,
    afii57795       = 0x05B6,
    afii57796       = 0x05BB,
    afii57797       = 0x05B8,
    afii57798       = 0x05B7,
    afii57799       = 0x05B0,
    afii57800       = 0x05B2,
    afii57801       = 0x05B1,
    afii57802       = 0x05B3,
    afii57803       = 0x05C2,
    afii57804       = 0x05C1,
    afii57806       = 0x05B9,
    afii57807       = 0x05BC,
    afii57839       = 0x05BD,
    afii57841       = 0x05BF,
    afii57842       = 0x05C0,
    afii57929       = 0x02BC,
    afii61248       = 0x2105,
    afii61289       = 0x2113,
    afii61352       = 0x2116,
    afii61664       = 0x200C,
    afii63167       = 0x066D,
    afii64937       = 0x02BD,
    arrowdblboth    = 0x21D4,
    arrowdblleft    = 0x21D0,
    arrowdblright   = 0x21D2,
    arrowupdnbse    = 0x21A8,
    bar             = 0x007C,
    circle          = 0x25CB,
    circlemultiply  = 0x2297,
    circleplus      = 0x2295,
    club            = 0x2663,
    colonmonetary   = 0x20A1,
    dcroat          = 0x0111,
    dkshade         = 0x2593,
    existential     = 0x2203,
    female          = 0x2640,
    gradient        = 0x2207,
    heart           = 0x2665,
    hookabovecomb   = 0x0309,
    invcircle       = 0x25D9,
    ldot            = 0x0140,
    longs           = 0x017F,
    ltshade         = 0x2591,
    male            = 0x2642,
    mu              = 0x00B5,
    napostrophe     = 0x0149,
    notelement      = 0x2209,
    omega1          = 0x03D6,
    openbullet      = 0x25E6,
    orthogonal      = 0x221F,
    oslashacute     = 0x01FF,
    phi1            = 0x03D5,
    propersubset    = 0x2282,
    propersuperset  = 0x2283,
    reflexsubset    = 0x2286,
    reflexsuperset  = 0x2287,
    shade           = 0x2592,
    sigma1          = 0x03C2,
    similar         = 0x223C,
    smileface       = 0x263A,
    spacehackarabic = 0x0020,
    spade           = 0x2660,
    theta1          = 0x03D1,
    twodotenleader  = 0x2025,
}

for u, c in next, characters.data do
    local a = c.adobename
    if a then
        unicodes[a] = u
        names   [u] = a
    end
end

for a, u in next, extras do
    unicodes[a] = u
    if not names[u] then
        names[u] = a
    end
end

-- We load this table only when needed. We could use a loading mechanism
-- return the table but there are no more vectors like this so why bother.

fonts.encodings = fonts.encodings or { }

fonts.encodings.agl = {
    names    = names,     -- unicode -> name
    unicodes = unicodes,  -- name -> unicode
    extras   = extras,    -- merged into the other two
}
