# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest
from elisa.core.tests.elisa_test_case import ElisaTestCase

from elisa.core.utils.singleton import Singleton

class TestSingleton(ElisaTestCase):

    def test_same_instance(self):

        class ClassA(Singleton):
            pass

        class ClassB(ClassA):
            pass

        # There will be only one instance for ClassA and ClassB

        class ClassC(Singleton):
            pass

        instance1 = ClassA()
        instance2 = ClassA()
        instance3 = ClassB()
        instance4 = ClassB()

        instance5 = ClassC()
        instance6 = ClassC()

        self.assertEquals(instance1, instance2)
        self.assertEquals(instance3, instance4)
        self.assertEquals(instance5, instance6)



if __name__ == "__main__":
    unittest.main()
