// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_GHOSTPAD_H
#define _GSTREAMERMM_GHOSTPAD_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gstreamermm/pad.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GstGhostPad GstGhostPad;
typedef struct _GstGhostPadClass GstGhostPadClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{ class GhostPad_Class; } // namespace Gst
namespace Gst
{

/** A class that represents pseudo link pads.
 * Gst::GhostPad are useful when organizing pipelines with Gst::Bin like
 * elements.
 * The idea here is to create hierarchical element graphs. The bin element
 * contains a sub-graph. Now one would like to treat the bin-element like
 * another Gst::Element. This is where Gst::GhostPad come into play. A
 * Gst::GhostPad acts as a proxy for another pad. Thus the bin can have sink
 * and source ghost-pads that are associated with sink and source pads of the
 * child elements.
 *
 * If the target pad is known at creation time, create() with a Gst::Pad
 * argument is the method to use to get a ghost-pad. Otherwise one can use
 * create() with a Gst::PadDirection argument to create the ghost-pad and use
 * set_target() to establish the association later on.
 *
 * Note that Gst::GhostPad add overhead to the data processing of a pipeline.
 *
 * Last reviewed on 2005-11-18 (0.9.5)
 */

class GhostPad : public Pad
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef GhostPad CppObjectType;
  typedef GhostPad_Class CppClassType;
  typedef GstGhostPad BaseObjectType;
  typedef GstGhostPadClass BaseClassType;

private:  friend class GhostPad_Class;
  static CppClassType ghostpad_class_;

private:
  // noncopyable
  GhostPad(const GhostPad&);
  GhostPad& operator=(const GhostPad&);

protected:
  explicit GhostPad(const Glib::ConstructParams& construct_params);
  explicit GhostPad(GstGhostPad* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~GhostPad();

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GstGhostPad*       gobj()       { return reinterpret_cast<GstGhostPad*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GstGhostPad* gobj() const { return reinterpret_cast<GstGhostPad*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstGhostPad* gobj_copy();

private:


protected:
  /** Creates a Gst::GhostPad from a target pad.
   * @param target The target pad.
   * @param name The name of the Gst::GhostPad.
   *
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  GhostPad(const Glib::RefPtr<Gst::Pad>& target, const Glib::ustring& name);

  /** Creates a Gst::GhostPad with a specified name and direction.
   * @param direction The direction of the Gst::GhostPad.
   * @param name The name of the Gst::GhostPad.
   *
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  GhostPad(PadDirection direction, const Glib::ustring& name);

  /** Creates a Gst::GhostPad from a target pad and a pad template.
   * @param target The target pad.
   * @param templ The pad template.
   * @param name The name of the Gst::GhostPad.
   *
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  GhostPad(const Glib::RefPtr<Gst::Pad>& target,
    const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::ustring& name);

  /** Creates a Gst::GhostPad from a pad template.
   * @param templ The pad template.
   * @param name The name of the Gst::GhostPad.
   *
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  GhostPad(const Glib::RefPtr<Gst::PadTemplate>& templ,
    const Glib::ustring& name);
  

public:
  /** Create a new Gst::GhostPad with @a target as the target. The direction
   * will be taken from the target pad. @a target must be unlinked.
   *
   * @param target The pad to ghost.
   * @param name The (optional) name of the new pad.
   * @return A new Gst::GhostPad, or an empty RefPtr in case of an error.
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  
  static Glib::RefPtr<GhostPad> create(const Glib::RefPtr<Gst::Pad>& target, const Glib::ustring& name =  Glib::ustring());


  /** Create a new Gst::GhostPad without a target with the given direction. A
   * target can be set on the Gst::GhostPad later with the set_target()
   * function.
   *
   * The created Gst::GhostPad will not have a padtemplate.
   *
   * @param dir The direction of the Gst::GhostPad.
   * @param name The (optional) name of the new Gst::GhostPad.
   * @return A new Gst::GhostPad, or an empty RefPtr in case of an error.
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  
  static Glib::RefPtr<GhostPad> create(PadDirection dir, const Glib::ustring& name =  Glib::ustring());


  /** Create a new Gst::GhostPad with @a target as the target. The direction
   * will be taken from the target pad. The template used on the Gst::GhostPad
   * will be template.
   *
   * @param target The pad to ghost.
   * @param templ The Gst::PadTemplate to use on the Gst::GhostPad.
   * @param name The (optional) name of the new Gst::GhostPad.
   * @return A new Gst::GhostPad, or an empty RefPtr in case of an error.
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  
  static Glib::RefPtr<GhostPad> create(const Glib::RefPtr<Gst::Pad>& target, const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::ustring& name =  Glib::ustring());


  /** Create a new Gst::GhostPad based on @a templ, without setting a target.
   * The direction will be taken from @a templ.
   *
   * @param templ The Gst::PadTemplate to create the Gst::GhostPad from.
   * @param name The (optional) name of the new Gst::GhostPad.
   * @return A new Gst::GhostPad, or an empty RefPtr in case of an error.
   * @throw std::runtime_error if Gst::GhostPad construction fails.
   */
  
  static Glib::RefPtr<GhostPad> create(const Glib::RefPtr<Gst::PadTemplate>& templ, const Glib::ustring& name =  Glib::ustring());


  /** Set the new target of the ghostpad @a gpad. Any existing target
   * is unlinked and links to the new target are established. if @a newtarget is
   * <tt>0</tt> the target will be cleared.
   * @param newtarget The new pad target.
   * @return <tt>true</tt> if the new target could be set. This function
   * can return <tt>false</tt> when the internal pads could not be linked.
   */
  bool set_target(const Glib::RefPtr<Gst::Pad>& newtarget);

  
  /** Get the target pad of @a gpad. Unref target pad after usage.
   * @return The target Gst::Pad, can be <tt>0</tt> if the ghostpad
   * has no target set. Unref target pad after usage.
   */
  Glib::RefPtr<Gst::Pad> get_target();
  
  /** Get the target pad of @a gpad. Unref target pad after usage.
   * @return The target Gst::Pad, can be <tt>0</tt> if the ghostpad
   * has no target set. Unref target pad after usage.
   */
  Glib::RefPtr<const Gst::Pad> get_target() const;


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gst


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::GhostPad
   */
  Glib::RefPtr<Gst::GhostPad> wrap(GstGhostPad* object, bool take_copy = false);
}


#endif /* _GSTREAMERMM_GHOSTPAD_H */

