// -*- c++ -*-
// Generated by gmmproc 2.39.93 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUFFER_H
#define _GSTREAMERMM_BUFFER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/memory.h>
#include <gstreamermm/mapinfo.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var BufferFlags BUFFER_FLAG_LIVE
 *         the buffer is live data and should be discarded inthe PAUSED state.
 * 
 *  @var BufferFlags BUFFER_FLAG_DECODE_ONLY
 *  the buffer contains data that should be droppedbecause it will be clipped against the segmentboundaries or because it does not contain datathat should be shown to the user.
 * 
 *  @var BufferFlags BUFFER_FLAG_DISCONT
 *      the buffer marks a data discontinuity in the stream.This typically occurs after a seek or a dropped bufferfrom a live or network source.
 * 
 *  @var BufferFlags BUFFER_FLAG_RESYNC
 *       the buffer timestamps might have a discontinuityand this buffer is a good point to resynchronize.
 * 
 *  @var BufferFlags BUFFER_FLAG_CORRUPTED
 *    the buffer data is corrupted.
 * 
 *  @var BufferFlags BUFFER_FLAG_MARKER
 *       the buffer contains a media specific marker. forvideo this is typically the end of a frame boundary, for audiothis is usually the start of a talkspurt.
 * 
 *  @var BufferFlags BUFFER_FLAG_HEADER
 *       the buffer contains header information that isneeded to decode the following data.
 * 
 *  @var BufferFlags BUFFER_FLAG_GAP
 *          the buffer has been created to fill a gap in thestream and contains media neutral data (elements canswitch to optimized code path that ignores the buffercontent).
 * 
 *  @var BufferFlags BUFFER_FLAG_DROPPABLE
 *    the buffer can be dropped without breaking thestream, for example to reduce bandwidth.
 * 
 *  @var BufferFlags BUFFER_FLAG_DELTA_UNIT
 *   this unit cannot be decoded independently.
 * 
 *  @var BufferFlags BUFFER_FLAG_LAST
 *         additional media specific flags can be added starting fromthis flag.
 * 
 *  @enum BufferFlags
 * 
 * A set of buffer flags used to describe properties of a Gst::Buffer.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%BufferFlags operator|(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator&(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator^(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator~(BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator|=(BufferFlags&, BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator&=(BufferFlags&, BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator^=(BufferFlags&, BufferFlags)</tt><br>
 */
enum BufferFlags
{
  BUFFER_FLAG_LIVE = (GST_MINI_OBJECT_FLAG_LAST << 0),
  BUFFER_FLAG_DECODE_ONLY = (GST_MINI_OBJECT_FLAG_LAST << 1),
  BUFFER_FLAG_DISCONT = (GST_MINI_OBJECT_FLAG_LAST << 2),
  BUFFER_FLAG_RESYNC = (GST_MINI_OBJECT_FLAG_LAST << 3),
  BUFFER_FLAG_CORRUPTED = (GST_MINI_OBJECT_FLAG_LAST << 4),
  BUFFER_FLAG_MARKER = (GST_MINI_OBJECT_FLAG_LAST << 5),
  BUFFER_FLAG_HEADER = (GST_MINI_OBJECT_FLAG_LAST << 6),
  BUFFER_FLAG_GAP = (GST_MINI_OBJECT_FLAG_LAST << 7),
  BUFFER_FLAG_DROPPABLE = (GST_MINI_OBJECT_FLAG_LAST << 8),
  BUFFER_FLAG_DELTA_UNIT = (GST_MINI_OBJECT_FLAG_LAST << 9),
  BUFFER_FLAG_LAST = (GST_MINI_OBJECT_FLAG_LAST << 16)
};

/** @ingroup gstreamermmEnums */
inline BufferFlags operator|(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator&(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator^(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator~(BufferFlags flags)
  { return static_cast<BufferFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator|=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator&=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator^=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferFlags> : public Glib::Value_Flags<Gst::BufferFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/** 
 *  @var BufferCopyFlags BUFFER_COPY_NONE
 *  copy nothing.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_FLAGS
 *  flag indicating that buffer flags should be copied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_TIMESTAMPS
 *  flag indicating that buffer pts, dts,duration, offset and offset_end should be copied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_MEMORY
 *  flag indicating that buffer memory should be reffedand appended to already existing memory. Unless the memory is marked asSHARE, no actual copy of the memory is made but it is simply reffed.Add @a BUFFER_COPY_DEEP to force a real copy.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_MERGE
 *  flag indicating that buffer memory should bemerged.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_META
 *  flag indicating that buffer meta should becopied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_DEEP
 *  flag indicating that memory should always becopied instead of reffed (Since 1.2).
 * 
 *  @enum BufferCopyFlags
 * 
 * A set of flags that can be provided to the gst_buffer_copy_into()
 * function to specify which items should be copied.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%BufferCopyFlags operator|(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator&(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator^(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator~(BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator|=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator&=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator^=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 */
enum BufferCopyFlags
{
  BUFFER_COPY_NONE = 0x0,
  BUFFER_COPY_FLAGS = (1 << 0),
  BUFFER_COPY_TIMESTAMPS = (1 << 1),
  BUFFER_COPY_META = (1 << 2),
  BUFFER_COPY_MEMORY = (1 << 3),
  BUFFER_COPY_MERGE = (1 << 4)
};

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator|(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator&(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator^(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator~(BufferCopyFlags flags)
  { return static_cast<BufferCopyFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator|=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator&=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator^=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferCopyFlags> : public Glib::Value_Flags<Gst::BufferCopyFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/** A data-passing buffer type, supporting sub-buffers.
 * Buffers are the basic unit of data transfer in GStreamer. The Gst::Buffer
 * type provides all the state necessary to define a region of memory as part
 * of a stream. Sub-buffers are also supported, allowing a smaller region of a
 * buffer to become its own buffer, with mechanisms in place to ensure that
 * neither memory space goes away prematurely.
 *
 * Buffers are usually created with create(). After a buffer has been created
 * one will typically allocate memory for it and set the size of the buffer
 * data. The following example creates a buffer that can hold a given video
 * frame with a given width, height and bits per plane.
 */
class Buffer : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Buffer CppObjectType;
  typedef GstBuffer BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<Buffer> create();

  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstBuffer*       gobj();

  ///Provides access to the underlying C instance.
  const GstBuffer* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBuffer* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Buffer can neither be constructed nor deleted.
  Buffer();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Buffer(const Buffer&);
  Buffer& operator=(const Buffer&);


public:
  /** Create a copy of the given buffer. This will also make a newly allocated
   * copy of the data the source buffer contains.
   * @return The Gst::Buffer copy.
   */
  Glib::RefPtr<Gst::Buffer> copy() const;

  
  /** Copies the information from @a src into @a dest.
   * 
   * If @a dest already contains memory and @a flags contains GST_BUFFER_COPY_MEMORY,
   * the memory from @a src will be appended to @a dest.
   * 
   *  @a flags indicate which fields will be copied.
   * @param src A source Gst::Buffer.
   * @param flags Flags indicating what metadata fields should be copied.
   * @param offset Offset to copy from.
   * @param size Total size to copy. If -1, all data is copied.
   * @return <tt>true</tt> if the copying succeeded, <tt>false</tt> otherwise.
   */
  void copy_into(Glib::RefPtr<Gst::Buffer> source_buffer, BufferCopyFlags flags, gsize offset, gsize size);

  static Glib::RefPtr<Gst::Buffer> create(guint size);

  /** Makes a writable buffer from the given buffer. If the source buffer is
   * already writable, this will simply return the same buffer. A copy will
   * otherwise be made.
   * @return A buffer (possibly the same pointer) that is writable.
   */
  Glib::RefPtr<Gst::Buffer> create_writable();

  
  /** Get the memory block at index @a idx in @a buffer.
   * @param idx An index.
   * @return A Gst::Memory that contains the data of the
   * memory block at @a idx. Use gst_memory_unref() after usage.
   */
  Glib::RefPtr<Gst::Memory> get_memory(guint idx) const;

  
  /** Get the total size of the memory blocks in @a buffer.
   * @return Total size of the memory blocks in @a buffer.
   */
  gsize get_size() const;

  
  /** Get all the memory block in @a buffer. The memory blocks will be merged
   * into one large Gst::Memory.
   * @return A Gst::Memory that contains the merged memory.
   * Use gst_memory_unref() after usage.
   */
  Glib::RefPtr<Gst::Memory> get_all_memory() const;

  
  /** Copy @a size bytes from @a src to @a buffer at @a offset.
   * @param offset The offset to fill.
   * @param src The source address.
   * @param size The size to fill.
   * @return The amount of bytes copied. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize fill(gsize offset, gconstpointer src, gsize size);

  
  /** Append all the memory from @a buf2 to @a buf1. The result buffer will contain a
   * concatenation of the memory of @a buf1 and @a buf2.
   * @param buf2 The second source Gst::Buffer to append.
   * @return The new Gst::Buffer that contains the memory
   * of the two source buffers.
   */
  Glib::RefPtr<Gst::Buffer> append(const Glib::RefPtr<Gst::Buffer>& buf) const;

  
  /** Append @a size bytes at @a offset from @a buf2 to @a buf1. The result buffer will
   * contain a concatenation of the memory of @a buf1 and the requested region of
   *  @a buf2.
   * @param buf2 The second source Gst::Buffer to append.
   * @param offset The offset in @a buf2.
   * @param size The size or -1 of @a buf2.
   * @return The new Gst::Buffer that contains the memory
   * of the two source buffers.
   */
  Glib::RefPtr<Gst::Buffer> append_region(const Glib::RefPtr<Gst::Buffer>& buf, gssize offset, gssize size) const;

  
  /** Replaces @a length memory blocks in @a buffer starting at @a idx with @a mem.
   * 
   * If @a length is -1, all memory starting from @a idx will be removed and
   * replaced with @a mem.
   * 
   *  @a buffer should be writable.
   * @param idx An index.
   * @param length A length should not be 0.
   * @param mem A Gst::Memory.
   */
  void replace_memory_range(guint idx, gint length, Glib::RefPtr<Gst::Memory> mem);

  
  /** Remove the memory block in @a b at index @a i.
   * @param idx An index.
   */
  void remove_memory(guint idx);

  
  /** Remove all the memory blocks in @a buffer.
   */
  void remove_all_memory();

  
  /** Fill @a buf with @a size bytes with @a val starting from @a offset.
   * @param offset The offset in @a buffer.
   * @param val The value to set.
   * @param size The size to set.
   * @return The amount of bytes filled. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize memset(gsize offset, guint8 val, gsize size);

  
  /** Replaces the memory block at index @a idx in @a buffer with @a mem.
   * @param idx An index.
   * @param mem A Gst::Memory.
   */
  void replace_memory(guint idx, Glib::RefPtr<Gst::Memory> mem);

  
  /** Copy @a size bytes starting from @a offset in @a buffer to @a dest.
   * @param offset The offset to extract.
   * @param dest The destination address.
   * @param size The size to extract.
   * @return The amount of bytes extracted. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize extract(gsize offset, gpointer dest, gsize size);

  
  /** Compare @a size bytes starting from @a offset in @a buffer with the memory in @a mem.
   * @param offset The offset in @a buffer.
   * @param mem The memory to compare.
   * @param size The size to compare.
   * @return 0 if the memory is equal.
   */
  int memcmp(gsize offset, gconstpointer mem, gsize size);

   ClockTime get_pts() const;
    void set_pts(const ClockTime& value);
 
   ClockTime get_dts() const;
    void set_dts(const ClockTime& value);
 
  /** Get duration of this buffer.
   * @return he duration in nanoseconds (as a Gst::ClockTime) of the data in
   * the buffer. Value will be Gst::CLOCK_TIME_NONE if the duration is unknown.
   */
   ClockTime get_duration() const;
    void set_duration(const ClockTime& value);
 
  
  /** This function fills @a info with the Gst::MapInfo of all merged memory
   * blocks in @a buffer.
   * 
   *  @a flags describe the desired access of the memory. When @a flags is
   * Gst::MAP_WRITE, @a buffer should be writable (as returned from
   * gst_buffer_is_writable()).
   * 
   * When @a buffer is writable but the memory isn't, a writable copy will
   * automatically be created and returned. The readonly copy of the
   * buffer memory will then also be replaced with this writable copy.
   * 
   * The memory in @a info should be unmapped with gst_buffer_unmap() after
   * usage.
   * @param info Info about the mapping.
   * @param flags Flags for the mapping.
   * @return <tt>true</tt> if the map succeeded and @a info contains valid data.
   */
  bool map(const Glib::RefPtr<Gst::MapInfo>& info, MapFlags flags);

  
  /** Release the memory previously mapped with gst_buffer_map().
   * @param info A Gst::MapInfo.
   */
  void unmap(const Glib::RefPtr<Gst::MapInfo>& info);
  /** Get the offset of this buffer.
   * @return The offset in the source file of the beginning of this buffer.
   */
   guint64 get_offset() const;
 
  /** Get the offset end of this buffer.
   * @return The offset in the source file of the end of this buffer.
   */
   guint64 get_offset_end() const;
 

};

}//namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Buffer
   */
  Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_BUFFER_H */

