
/*
   This file is part of Valgrind, a dynamic binary instrumentation
   framework.

   Copyright (C) 2000-2005 Julian Seward 
      jseward@acm.org

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.

   The GNU General Public License is contained in the file COPYING.
*/

#ifndef __VKI_UNISTD_OPENBSD_H
#define __VKI_UNISTD_OPENBSD_H

#define VG_OPENBSD_SYSCALL_STD	0
#define VG_OPENBSD_SYSCALL0	1
#define VG_OPENBSD_SYSCALL198	2

// From sys/syscall.h

#define	__NR_syscall		0
#define	__NR_exit		1
#define	__NR_fork		2
#define	__NR_read		3
#define	__NR_write		4
#define	__NR_open		5
#define	__NR_close		6
#define	__NR_getentropy		7
#define	__NR___tfork		8
#define	__NR_link		9
#define	__NR_unlink		10
#define	__NR_wait4		11
#define	__NR_chdir		12
#define	__NR_fchdir		13
#define	__NR_mknod		14
#define	__NR_chmod		15
#define	__NR_chown		16
#define	__NR_break		17
#define	__NR_getdtablecount	18
#define	__NR_getrusage		19
#define	__NR_getpid		20
#define	__NR_mount		21
#define	__NR_unmount		22
#define	__NR_setuid		23
#define	__NR_getuid		24
#define	__NR_geteuid		25
#define	__NR_ptrace		26
#define	__NR_recvmsg		27
#define	__NR_sendmsg		28
#define	__NR_recvfrom		29
#define	__NR_accept		30
#define	__NR_getpeername	31
#define	__NR_getsockname	32
#define	__NR_access		33
#define	__NR_chflags		34
#define	__NR_fchflags		35
#define	__NR_sync		36
#define	__NR_kill		37
#define	__NR_stat		38
#define	__NR_getppid		39
#define	__NR_lstat		40
#define	__NR_dup		41
#define	__NR_fstatat		42
#define	__NR_getegid		43
#define	__NR_profil		44
#define	__NR_ktrace		45
#define	__NR_sigaction		46
#define	__NR_getgid		47
#define	__NR_sigprocmask	48
#define	__NR_getlogin		49
#define	__NR_setlogin		50
#define	__NR_acct		51
#define	__NR_sigpending		52
#define	__NR_fstat		53
#define	__NR_ioctl		54
#define	__NR_reboot		55
#define	__NR_revoke		56
#define	__NR_symlink		57
#define	__NR_readlink		58
#define	__NR_execve		59
#define	__NR_umask		60
#define	__NR_chroot		61
#define	__NR_getfsstat		62
#define	__NR_statfs		63
#define	__NR_fstatfs		64
#define	__NR_fhstatfs		65
#define	__NR_vfork		66
#define __NR_gettimeofday	67
#define __NR_settimeofday	68
#define __NR_setitimer		69
#define __NR_getitimer		70
#define __NR_select		71
#define __NR_kevent		72
#define	__NR_munmap		73
#define	__NR_mprotect		74
#define	__NR_madvise		75
#define	__NR_utimes		76
#define	__NR_futimes		77
#define	__NR_mincore		78
#define	__NR_getgroups		79
#define	__NR_setgroups		80
#define	__NR_getpgrp		81
#define	__NR_setpgid		82
#define __NR_utimensat		84
#define __NR_futimens		85
#define __NR_clock_gettime	87
#define __NR_clock_settime	88
#define __NR_clock_getres	89
#define	__NR_dup2		90
#define	__NR_nanosleep		91
#define	__NR_fcntl		92
#define	__NR___thrsleep		94
#define	__NR_fsync		95
#define	__NR_setpriority	96
#define	__NR_socket		97
#define	__NR_connect		98
#define	__NR_getdents		99
#define	__NR_getpriority	100
#define	__NR_sigreturn		103
#define	__NR_bind		104
#define	__NR_setsockopt		105
#define	__NR_listen		106
#define	__NR_ppoll		109
#define	__NR_pselect		110
#define	__NR_sigsuspend		111
#define	__NR_getsockopt		118
#define	__NR_readv		120
#define	__NR_writev		121
#define	__NR_fchown		123
#define	__NR_fchmod		124
#define	__NR_setreuid		126
#define	__NR_setregid		127
#define	__NR_rename		128
#define	__NR_flock		131
#define	__NR_mkfifo		132
#define	__NR_sendto		133
#define	__NR_shutdown		134
#define	__NR_socketpair		135
#define	__NR_mkdir		136
#define	__NR_rmdir		137
#define	__NR_adjtime		140
#define	__NR_setsid		147
#define	__NR_quotactl		148
#define	__NR_nfssvc		155
#define	__NR_getfh		161
#define	__NR_sysarch		165
#define	__NR_pread		173
#define	__NR_pwrite		174
#define	__NR_setgid		181
#define	__NR_setegid		182
#define	__NR_seteuid		183
#define	__NR_pathconf		191
#define	__NR_fpathconf		192
#define	__NR_swapctl		193
#define	__NR_getrlimit		194
#define	__NR_setrlimit		195
#define	__NR_mmap		197
#define	__NR___syscall		198
#define	__NR_lseek		199
#define	__NR_truncate		200
#define	__NR_ftruncate		201
#define	__NR___sysctl		202
#define	__NR_mlock		203
#define	__NR_munlock		204
#define	__NR_getpgid		207
#define	__NR_utrace		209
#define	__NR_semget		221
#define	__NR_msgget		225
#define	__NR_msgsnd		226
#define	__NR_msgrcv		227
#define	__NR_shmat		228
#define	__NR_shmdt		230
#define	__NR_minherit		250
#define	__NR_poll		252
#define	__NR_issetugid		253
#define	__NR_lchown		254
#define	__NR_getsid		255
#define	__NR_msync		256
#define	__NR_pipe		263
#define	__NR_fhopen		264
#define	__NR_preadv		267
#define	__NR_pwritev		268
#define	__NR_kqueue		269
#define	__NR_mlockall		271
#define	__NR_munlockall		272
#define	__NR_getresuid		281
#define	__NR_setresuid		282
#define	__NR_getresgid		283
#define	__NR_setresgid		284
#define	__NR_mquery		286
#define	__NR_closefrom		287
#define	__NR_sigaltstack	288
#define	__NR_shmget		289
#define	__NR_semop		290
#define	__NR_fhstat		294
#define	__NR___semctl		295
#define	__NR_shmctl		296
#define	__NR_msgctl		297
#define	__NR_sched_yield	298
#define	__NR_getthrid		299
#define	__NR___thrwakeup	301
#define	__NR___threxit		302
#define	__NR___thrsigdivert	303
#define	__NR___getcwd		304
#define	__NR_adjfreq		305
#define	__NR_setrtable		310
#define	__NR_getrtable		311
#define	__NR_faccessat		313
#define	__NR_fchmodat		314
#define	__NR_fchownat		315
#define	__NR_linkat		317
#define	__NR_mkdirat		318
#define	__NR_mkfifoat		319
#define	__NR_mknodat		320
#define	__NR_openat		321
#define	__NR_readlinkat		322
#define	__NR_renameat		323
#define	__NR_symlinkat		324
#define	__NR_unlinkat		325
#define	__NR___set_tcb		329
#define	__NR___get_tcb		330

#define	__NR_MAXSYSCALL		331

#define __NR_fake_sigreturn	1000

#endif /* __VKI_UNISTD_OPENBSD_H */
