/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.membership;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.catalina.tribes.Member;

public class Membership
implements Cloneable {
    protected static final Member[] EMPTY_MEMBERS = new Member[0];
    private final Object membersLock = new Object();
    protected final Member local;
    protected HashMap<Member, MbrEntry> map = new HashMap();
    protected Member[] members = EMPTY_MEMBERS;
    protected final Comparator<Member> memberComparator;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        Object object = this.membersLock;
        synchronized (object) {
            HashMap tmpclone;
            Membership clone = new Membership(this.local, this.memberComparator);
            clone.map = tmpclone = (HashMap)this.map.clone();
            clone.members = new Member[this.members.length];
            System.arraycopy(this.members, 0, clone.members, 0, this.members.length);
            return clone;
        }
    }

    public Membership(Member local, boolean includeLocal) {
        this(local, new MemberComparator(), includeLocal);
    }

    public Membership(Member local) {
        this(local, false);
    }

    public Membership(Member local, Comparator<Member> comp) {
        this(local, comp, false);
    }

    public Membership(Member local, Comparator<Member> comp, boolean includeLocal) {
        this.local = local;
        if (includeLocal) {
            this.addMember(local);
        }
        this.memberComparator = comp;
    }

    public synchronized void reset() {
        this.map.clear();
        this.members = EMPTY_MEMBERS;
    }

    public synchronized boolean memberAlive(Member member) {
        boolean result = false;
        if (member.equals(this.local)) {
            return result;
        }
        MbrEntry entry = this.map.get(member);
        if (entry == null) {
            entry = this.addMember(member);
            result = true;
        } else {
            Member updateMember = entry.getMember();
            if (updateMember.getMemberAliveTime() != member.getMemberAliveTime()) {
                updateMember.setMemberAliveTime(member.getMemberAliveTime());
                updateMember.setPayload(member.getPayload());
                updateMember.setCommand(member.getCommand());
                Arrays.sort(this.members, this.memberComparator);
            }
        }
        entry.accessed();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized MbrEntry addMember(Member member) {
        Object object = this.membersLock;
        synchronized (object) {
            MbrEntry entry = new MbrEntry(member);
            if (!this.map.containsKey(member)) {
                this.map.put(member, entry);
                Member[] results = new Member[this.members.length + 1];
                for (int i = 0; i < this.members.length; ++i) {
                    results[i] = this.members[i];
                }
                results[this.members.length] = member;
                this.members = results;
                Arrays.sort(this.members, this.memberComparator);
            }
            return entry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMember(Member member) {
        this.map.remove(member);
        Object object = this.membersLock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] != member && !this.members[i].equals(member)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            Member[] results = new Member[this.members.length - 1];
            int j = 0;
            for (int i = 0; i < this.members.length; ++i) {
                if (i == n) continue;
                results[j++] = this.members[i];
            }
            this.members = results;
        }
    }

    public synchronized Member[] expire(long maxtime) {
        if (!this.hasMembers()) {
            return EMPTY_MEMBERS;
        }
        ArrayList<Member> list = null;
        for (MbrEntry entry : this.map.values()) {
            if (!entry.hasExpired(maxtime)) continue;
            if (list == null) {
                list = new ArrayList<Member>();
            }
            list.add(entry.getMember());
        }
        if (list != null) {
            Member[] result = new Member[list.size()];
            list.toArray(result);
            for (int j = 0; j < result.length; ++j) {
                this.removeMember(result[j]);
            }
            return result;
        }
        return EMPTY_MEMBERS;
    }

    public boolean hasMembers() {
        return this.members.length > 0;
    }

    public Member getMember(Member mbr) {
        if (this.hasMembers()) {
            Member result = null;
            for (int i = 0; i < this.members.length && result == null; ++i) {
                if (!this.members[i].equals(mbr)) continue;
                result = this.members[i];
            }
            return result;
        }
        return null;
    }

    public boolean contains(Member mbr) {
        return this.getMember(mbr) != null;
    }

    public Member[] getMembers() {
        if (this.hasMembers()) {
            return this.members;
        }
        return EMPTY_MEMBERS;
    }

    protected synchronized MbrEntry[] getMemberEntries() {
        MbrEntry[] result = new MbrEntry[this.map.size()];
        Iterator<Map.Entry<Member, MbrEntry>> i = this.map.entrySet().iterator();
        int pos = 0;
        while (i.hasNext()) {
            result[pos++] = i.next().getValue();
        }
        return result;
    }

    protected static class MbrEntry {
        protected final Member mbr;
        protected long lastHeardFrom;

        public MbrEntry(Member mbr) {
            this.mbr = mbr;
        }

        public void accessed() {
            this.lastHeardFrom = System.currentTimeMillis();
        }

        public Member getMember() {
            return this.mbr;
        }

        public boolean hasExpired(long maxtime) {
            long delta = System.currentTimeMillis() - this.lastHeardFrom;
            return delta > maxtime;
        }
    }

    private static class MemberComparator
    implements Comparator<Member>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private MemberComparator() {
        }

        @Override
        public int compare(Member m1, Member m2) {
            long result = m2.getMemberAliveTime() - m1.getMemberAliveTime();
            if (result < 0L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
    }
}

