/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.spdy;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.tomcat.spdy.SpdyConnection;
import org.apache.tomcat.spdy.SpdyFrame;

public class SpdyStream
implements Runnable {
    private final SpdyConnection spdy;
    public SpdyFrame reqFrame;
    public SpdyFrame resFrame;
    private final BlockingQueue<SpdyFrame> inData = new LinkedBlockingQueue<SpdyFrame>();
    protected boolean finSent;
    protected boolean finRcvd;
    private static final SpdyFrame END_FRAME = new SpdyFrame(16);

    public SpdyStream(SpdyConnection spdy) {
        this.spdy = spdy;
    }

    public void dump(PrintWriter out) {
        if (this.reqFrame != null) {
            out.println("Req: " + this.reqFrame);
        }
        if (this.resFrame != null) {
            out.println("Res: " + this.resFrame);
        }
        out.println("In: " + this.inData.size() + (this.finRcvd ? " FIN" : ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDataFrame(SpdyFrame inFrame) {
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            this.inData.add(inFrame);
            if (inFrame.closed()) {
                this.finRcvd = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCtlFrame(SpdyFrame frame) {
        if (frame.type == 1) {
            this.reqFrame = frame;
        } else if (frame.type == 2) {
            this.resFrame = frame;
        }
        SpdyStream spdyStream = this;
        synchronized (spdyStream) {
            this.inData.add(frame);
            if (frame.isHalfClose()) {
                this.finRcvd = true;
            }
        }
    }

    public void onReset() {
        this.finRcvd = true;
        this.finSent = true;
        this.inData.add(END_FRAME);
    }

    public boolean isFinished() {
        return this.finSent && this.finRcvd;
    }

    public SpdyFrame getDataFrame(long to) throws IOException {
        SpdyFrame res;
        do {
            if ((res = this.getFrame(to)) != null && !res.isData()) continue;
            return res;
        } while (res.type != 3);
        throw new IOException("Reset");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpdyFrame getFrame(long to) {
        try {
            SpdyStream spdyStream = this;
            synchronized (spdyStream) {
                if (this.inData.size() == 0 && this.finRcvd) {
                    return END_FRAME;
                }
            }
            SpdyFrame in = this.inData.poll(to, TimeUnit.MILLISECONDS);
            return in;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public void getHeaders(Map<String, String> resHeaders) {
        SpdyFrame f = this.resFrame;
        int nvCount = f.nvCount;
        for (int i = 0; i < nvCount; ++i) {
            int len = f.read16();
            String n = new String(f.data, f.off, len, StandardCharsets.UTF_8);
            f.advance(len);
            len = f.read16();
            String v = new String(f.data, f.off, len, StandardCharsets.UTF_8);
            f.advance(len);
            resHeaders.put(n, v);
        }
    }

    public SpdyFrame getRequest() {
        if (this.reqFrame == null) {
            this.reqFrame = this.spdy.getFrame(1);
        }
        return this.reqFrame;
    }

    public SpdyFrame getResponse() {
        if (this.resFrame == null) {
            this.resFrame = this.spdy.getFrame(2);
            this.resFrame.streamId = this.reqFrame.streamId;
        }
        return this.resFrame;
    }

    public synchronized void sendDataFrame(byte[] data, int start, int length, boolean close) {
        SpdyFrame oframe = this.spdy.getDataFrame();
        if (close) {
            oframe.halfClose();
        }
        oframe.append(data, start, length);
        this.spdy.send(oframe, this);
    }

    public void send() {
        this.send("http", "GET");
    }

    public void send(String host, String url, String scheme, String method) {
        this.getRequest().addHeader("host", host);
        this.getRequest().addHeader("url", url);
        this.send(scheme, method);
    }

    public void send(String scheme, String method) {
        this.getRequest();
        if ("GET".equalsIgnoreCase(method)) {
            this.reqFrame.halfClose();
        }
        this.getRequest().addHeader("scheme", scheme);
        this.getRequest().addHeader("method", method);
        this.getRequest().addHeader("version", "HTTP/1.1");
        if (this.reqFrame.isHalfClose()) {
            this.finSent = true;
        }
        this.spdy.send(this.reqFrame, this);
    }

    @Override
    public void run() {
        try {
            this.spdy.spdyContext.handler.onStream(this.spdy, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public InputStream getInputStream() {
        return new SpdyInputStream();
    }

    static {
        SpdyStream.END_FRAME.endData = 0;
        SpdyStream.END_FRAME.off = 0;
        SpdyStream.END_FRAME.c = false;
        SpdyStream.END_FRAME.flags = 1;
    }

    private class SpdyInputStream
    extends InputStream {
        private SpdyFrame current = null;
        private long to = 10000L;

        private SpdyInputStream() {
        }

        private void fill() {
            if (this.current == null || this.current.off == this.current.endData) {
                this.current = SpdyStream.this.getFrame(this.to);
            }
        }

        @Override
        public int read() throws IOException {
            this.fill();
            if (this.current == null) {
                return -1;
            }
            return this.current.readByte();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            this.fill();
            if (this.current == null) {
                return -1;
            }
            int rd = Math.min(len, this.current.endData - this.current.off);
            System.arraycopy(this.current.data, this.current.off, b, off, rd);
            this.current.off += rd;
            return rd;
        }

        @Override
        public int available() throws IOException {
            return 0;
        }

        @Override
        public void close() throws IOException {
        }
    }
}

