/*
 * Decompiled with CFR 0.152.
 */
package com.github.arara.utils;

import com.github.arara.utils.AraraLocalization;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.WordUtils;
import org.yaml.snakeyaml.error.MarkedYAMLException;

public class AraraUtils {
    static final AraraLocalization localization = AraraLocalization.getInstance();

    public static String removeKeyword(String line) {
        Pattern pattern = Pattern.compile("^(\\s)*<arara>\\s");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            line = line.substring(matcher.end(), line.length()).trim();
        }
        return line;
    }

    public static void printHeader() {
        System.out.println("  __ _ _ __ __ _ _ __ __ _ ");
        System.out.println(" / _` | '__/ _` | '__/ _` |");
        System.out.println("| (_| | | | (_| | | | (_| |");
        System.out.println(" \\__,_|_|  \\__,_|_|  \\__,_|\n");
    }

    public static String wrap(String message) {
        StringTokenizer tokens = new StringTokenizer(message, "\n", true);
        String result = "";
        while (tokens.hasMoreTokens()) {
            result = result.concat(WordUtils.wrap(tokens.nextToken(), 65));
        }
        return result;
    }

    public static String getVariableFromException(RuntimeException runtimeException) {
        Pattern pattern = Pattern.compile("^\\[Error: could not access: (.*);");
        Matcher matcher = pattern.matcher(runtimeException.getMessage());
        if (matcher.find()) {
            if (matcher.groupCount() != 0) {
                return matcher.group(1);
            }
        } else {
            pattern = Pattern.compile("^\\[Error: unable to access property \\((.*)\\): (.*)\\]");
            matcher = pattern.matcher(runtimeException.getMessage());
            if (matcher.find() && matcher.groupCount() > 1) {
                return matcher.group(2);
            }
        }
        return "<unknown>";
    }

    public static String extractInformationFromYAMLException(MarkedYAMLException yamlException) {
        StringBuilder stringBuilder = new StringBuilder();
        if (yamlException.getContext() != null) {
            stringBuilder.append(localization.getMessage("YamlError_Context", yamlException.getContext())).append("\n");
        }
        if (yamlException.getProblem() != null) {
            stringBuilder.append(localization.getMessage("YamlError_Problem", yamlException.getProblem())).append("\n");
        }
        if (yamlException.getProblemMark() != null) {
            stringBuilder.append(localization.getMessage("YamlError_ErrorLocation", yamlException.getProblemMark().getLine(), yamlException.getProblemMark().getColumn())).append("\n");
        }
        if (yamlException.getProblemMark().get_snippet() != null) {
            stringBuilder.append(yamlException.getProblemMark().get_snippet());
        }
        return stringBuilder.toString();
    }

    public static boolean checkForFullDirective(String line) {
        Pattern pattern = Pattern.compile("^\\s*(\\w+)\\s*:\\s*\\{.*\\}\\s*$");
        Matcher m = pattern.matcher(line);
        return m.find();
    }

    public static boolean checkForEmptyDirective(String line) {
        Pattern pattern = Pattern.compile("^\\s*(\\w+)\\s*$");
        Matcher m = pattern.matcher(line);
        return m.find();
    }
}

