/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jffmpeg.codecs.video.mpeg4.divx;

import java.awt.Dimension;
import javax.media.Buffer;
import javax.media.Codec;
import javax.media.Format;
import javax.media.format.RGBFormat;
import javax.media.format.VideoFormat;
import net.sourceforge.jffmpeg.JMFCodec;
import net.sourceforge.jffmpeg.codecs.utils.BitStream;
import net.sourceforge.jffmpeg.codecs.utils.FFMpegException;
import net.sourceforge.jffmpeg.codecs.utils.VLCTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg.DisplayOutput;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.div3.rltables.RLTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.Tables;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.rltables.RLInter;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.rltables.RLIntra;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.rltables.RLRVlcRLInter;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.rltables.RLRVlcRLIntra;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.tables.ScanTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.CbpyVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.InterMcbpc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.IntraMcbpc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.MVTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.MbTypeBTable;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.dcChrominanceVlc;
import net.sourceforge.jffmpeg.codecs.video.mpeg4.divx.vlc.dcLuminanceVlc;

public class DIVXCodec
implements Codec,
JMFCodec {
    public static final boolean debug = false;
    public static final boolean debug2 = false;
    int width;
    int height;
    int mbWidth;
    int mbHeight;
    private int[] mb_type;
    private int[] cbp_table;
    private int[] qscale_table;
    private int[][] motion_val;
    private int[] ac_val;
    private int[] dc_val;
    private int[] pred_dir_table;
    private int[] mbintra_table;
    private int[] mb_type_b_frame;
    private int[] mb_type_ip_frame;
    private int[][] next_motion_val;
    private VideoFormat inputFormat;
    private DisplayOutput displayOutput;
    protected BitStream in = new BitStream();
    private boolean[][] skipTable;
    private boolean[][] mb_skiptable;
    private int h263_predMotionX;
    private int h263_predMotionY;
    private VLCTable mv_vlc = new MVTable();
    private VLCTable dc_lumTable = new dcLuminanceVlc();
    private VLCTable dc_chromTable = new dcChrominanceVlc();
    private RLTable rvlc_rl_intra = new RLRVlcRLIntra();
    private RLTable rl_intra = new RLIntra();
    private RLTable rvlc_rl_inter = new RLRVlcRLInter();
    private RLTable rl_inter = new RLInter();
    private boolean dc_pred_dir;
    private boolean mb_intra;
    private int mv_dir;
    private int mv_type;
    private boolean mcsel;
    private boolean mb_skipped;
    private int motion_pred_x;
    private int motion_pred_y;
    private boolean interlaced_dct;
    int[] quant_tab = new int[]{-1, -2, 1, 2};
    private int[] chroma_qscale_table = ff_default_chroma_qscale_table;
    private static int[] ff_default_chroma_qscale_table = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    private VLCTable inter_MCBPC = new InterMcbpc();
    private VLCTable intra_MCBPC = new IntraMcbpc();
    private VLCTable cbpyVlc = new CbpyVlc();
    private static final int IS_INTRA_MASK = 7;
    private static final int IS_DIRECT_MASK = 256;
    private static final int IS_SKIP_MASK = 2048;
    private static final int IS_8X8_MASK = 64;
    private static final int IS_INTERLACED_MASK = 128;
    private static final int MB_TYPE_DIRECT2 = 256;
    private static final int MB_TYPE_ACPRED = 512;
    private static final int MB_TYPE_GMC = 1024;
    private static final int MB_TYPE_SKIP = 2048;
    private static final int MB_TYPE_INTRA = 1;
    private static final int MB_TYPE_INTERLACED = 128;
    private static final int MB_TYPE_8x8 = 64;
    private static final int MB_TYPE_16x8 = 16;
    private static final int MB_TYPE_16x16 = 8;
    private static final int MB_TYPE_P0L0 = 4096;
    private static final int MB_TYPE_P1L0 = 8192;
    private static final int MB_TYPE_P0L1 = 16384;
    private static final int MB_TYPE_P1L1 = 32768;
    private static final int MB_TYPE_L0 = 12288;
    private static final int MB_TYPE_L1 = 49152;
    private static final int MB_TYPE_L0L1 = 61440;
    private static final int MV_TYPE_FIELD = 3;
    private static final int MV_DIR_FORWARD = 2;
    private static final int MV_DIR_BACKWARD = 1;
    private static final int MV_DIRECT = 4;
    private static final int MV_TYPE_8X8 = 1;
    private static final int MV_TYPE_16X16 = 0;
    private VLCTable mb_type_b = new MbTypeBTable();
    private static final int[] mb_type_b_map = new int[]{61696, 61448, 49160, 12296};
    private int[][][] mv = new int[2][4][2];
    private int[][][] last_mv = new int[2][4][2];
    private boolean ac_pred;
    private int[] ff_mpeg4_y_dc_scale_table = new int[]{0, 8, 8, 8, 8, 10, 12, 14, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 34, 36, 38, 40, 42, 44, 46};
    private int[] ff_mpeg4_c_dc_scale_table = new int[]{0, 8, 8, 8, 8, 9, 9, 10, 10, 11, 11, 12, 12, 13, 13, 14, 14, 15, 15, 16, 16, 17, 17, 18, 18, 19, 20, 21, 22, 23, 24, 25};
    private static final int NUMBER_OF_BLOCKS = 6;
    private int[] blockWrap = new int[6];
    private int[] blockIndex = new int[6];
    private int[][] block = new int[6][64];
    private int[] block_last_index = new int[6];
    private int[] blank = new int[64];
    private int y_dc_scale;
    private int c_dc_scale;
    private boolean first_slice_line;
    private int resync_mb_x;
    private int resync_mb_y;
    private int vo_type;
    private int vo_ver_id;
    private int shape;
    private static int FF_ASPECT_EXTENDED = 15;
    private static final int RECT_SHAPE = 0;
    private static final int BIN_ONLY_SHAPE = 2;
    private static final int GRAY_SHAPE = 3;
    private static final int STATIC_SPRITE = 1;
    private static final int GMC_SPRITE = 2;
    private int[] intra_matrix = new int[64];
    private int[] chroma_intra_matrix = new int[64];
    private int[] inter_matrix = new int[64];
    private int[] chroma_inter_matrix = new int[64];
    private boolean data_partitioning;
    private int time_increment_resolution;
    private int time_increment_bits;
    private boolean vol_control_parameters;
    private int quant_precision;
    private int qscale;
    private boolean mpeg_quant;
    private static int I_TYPE = 1;
    private static int P_TYPE = 2;
    private static int B_TYPE = 3;
    private static int S_TYPE = 4;
    private boolean progressive_sequence;
    private boolean alternate_scan;
    private int vol_sprite_usage;
    private boolean scalability;
    private boolean enhancement_type;
    private boolean top_field_first;
    private boolean quarter_sample;
    private boolean resync_marker;
    private int num_sprite_warping_points;
    private int sprite_warping_accuracy;
    private int intra_dc_threshold = 0;
    private int decode_mb;
    private int pict_type;
    private boolean partitioned_frame;
    private boolean no_rounding;
    private int f_code;
    private int b_code;
    private int[][] field_select = new int[2][2];
    private int time_base;
    private int last_time_base;
    private int last_non_b_time;
    private int pp_time;
    private int pb_time;
    private int[] inter_scantable;
    private int[] intra_scantable;
    private int[] intra_h_scantable;
    private int[] intra_v_scantable;
    private static final int[] ff_zigzag_direct = ScanTable.getZigZagDirectTable();
    private static final int[] ff_alternate_horizontal_scan = ScanTable.getAlternativeHScanTable();
    private static final int[] ff_alternate_vertical_scan = ScanTable.getAlternativeVScanTable();
    private static final int[] mpeg4_dc_threshold = new int[]{99, 13, 15, 17, 19, 21, 23, 0};
    public static final int VOL_HEADER = 288;
    public static final int USER_DATA_STARTCODE = 434;
    public static final int GOP_STARTCODE = 435;
    public static final int VOP_STARTCODE = 438;
    private int mb_x;
    private int mb_y;
    private int mb_stride;

    protected void dct_unquantize_h263(int n) {
        int n2 = 0;
        if (this.mb_intra) {
            int[] nArray = this.block[n];
            nArray[0] = nArray[0] * (n < 4 ? this.y_dc_scale : this.c_dc_scale);
            n2 = 1;
        }
        int n3 = this.qscale << 1;
        int n4 = this.qscale - 1 | 1;
        while (n2 < 64) {
            if (this.block[n][n2] > 0) {
                this.block[n][n2] = this.block[n][n2] * n3 + n4;
            } else if (this.block[n][n2] < 0) {
                this.block[n][n2] = this.block[n][n2] * n3 - n4;
            }
            ++n2;
        }
    }

    protected void MPV_decode_mb(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.mv[0][0][0];
        int n6 = this.mv[0][0][1];
        boolean bl = true;
        boolean bl2 = false;
        this.qscale_table[n + n2 * this.mbWidth] = this.qscale;
        if (!this.mb_intra) {
            if ((bl || bl2) && this.mbintra_table[n2 * this.mbWidth + n] != 0) {
                this.mbintra_table[n2 * this.mbWidth + n] = 0;
                n4 = this.blockIndex[0];
                n3 = this.blockWrap[0];
                this.dc_val[n4] = 1024;
                this.dc_val[n4 + 1] = 1024;
                this.dc_val[n4 + n3] = 1024;
                this.dc_val[n4 + 1 + n3] = 1024;
                System.arraycopy(this.blank, 0, this.ac_val, n4 * 16 + this.mbWidth * 16, 32);
                System.arraycopy(this.blank, 0, this.ac_val, (n4 + n3) * 16 + this.mbWidth * 16, 32);
                this.dc_val[this.blockIndex[4]] = 1024;
                this.dc_val[this.blockIndex[5]] = 1024;
                System.arraycopy(this.blank, 0, this.ac_val, this.blockIndex[4] * 16 + this.mbWidth * 16, 16);
                System.arraycopy(this.blank, 0, this.ac_val, this.blockIndex[5] * 16 + this.mbWidth * 16, 16);
            }
            if (this.pict_type == I_TYPE || this.pict_type == P_TYPE) {
                this.mb_skiptable[n][n2] = this.mb_skipped;
            }
            this.mb_skipped = false;
            if (!this.mb_skipped || !this.skipTable[n][n2]) {
                this.skipTable[n][n2] = this.mb_skipped;
                if (this.pict_type == B_TYPE) {
                    if ((this.mv_dir & 2) != 0) {
                        if (this.mv_type == 0) {
                            this.displayOutput.move(n, n2, n5, n6, !this.no_rounding);
                        } else if (this.mv_type == 3) {
                            this.displayOutput.moveField(n, n2, this.mv[0][0][0], this.mv[0][0][1], !this.no_rounding, false);
                            this.displayOutput.moveField(n, n2, this.mv[0][1][0], this.mv[0][1][1], !this.no_rounding, true);
                        } else if (this.mv_type == 1) {
                            this.displayOutput.move8x8(n, n2, this.mv[0][0][0], this.mv[0][0][1], !this.no_rounding, 0, 0);
                            this.displayOutput.move8x8(n, n2, this.mv[0][1][0], this.mv[0][1][1], !this.no_rounding, 8, 0);
                            this.displayOutput.move8x8(n, n2, this.mv[0][2][0], this.mv[0][2][1], !this.no_rounding, 0, 8);
                            this.displayOutput.move8x8(n, n2, this.mv[0][3][0], this.mv[0][3][1], !this.no_rounding, 8, 8);
                        }
                    }
                    if ((this.mv_dir & 1) != 0) {
                        int n7 = n4 = (this.mv_dir & 2) != 0 ? 1 : 0;
                        if (this.mv_type == 0) {
                            this.displayOutput.moveFromNext(n, n2, this.mv[1][0][0], this.mv[1][0][1], !this.no_rounding, n4 != 0);
                        } else if (this.mv_type == 3) {
                            this.displayOutput.moveFieldFromNext(n, n2, this.mv[1][0][0], this.mv[1][0][1], !this.no_rounding, false, n4 != 0);
                            this.displayOutput.moveFieldFromNext(n, n2, this.mv[1][1][0], this.mv[1][1][1], !this.no_rounding, true, n4 != 0);
                        } else if (this.mv_type == 1) {
                            this.displayOutput.move8x8FromNext(n, n2, this.mv[1][0][0], this.mv[1][0][1], !this.no_rounding, 0, 0, n4 != 0);
                            this.displayOutput.move8x8FromNext(n, n2, this.mv[1][1][0], this.mv[1][1][1], !this.no_rounding, 8, 0, n4 != 0);
                            this.displayOutput.move8x8FromNext(n, n2, this.mv[1][2][0], this.mv[1][2][1], !this.no_rounding, 0, 8, n4 != 0);
                            this.displayOutput.move8x8FromNext(n, n2, this.mv[1][3][0], this.mv[1][3][1], !this.no_rounding, 8, 8, n4 != 0);
                        }
                    }
                } else if (this.mv_type == 0) {
                    this.displayOutput.moveFromIPFrame(n, n2, n5, n6, !this.no_rounding);
                } else if (this.mv_type == 3) {
                    this.displayOutput.moveFieldFromIPFrame(n, n2, this.mv[0][0][0], this.mv[0][0][1], !this.no_rounding, false);
                    this.displayOutput.moveFieldFromIPFrame(n, n2, this.mv[0][1][0], this.mv[0][1][1], !this.no_rounding, true);
                } else if (this.mv_type == 1) {
                    this.displayOutput.move8x8FromIPFrame(n, n2, this.mv[0][0][0], this.mv[0][0][1], !this.no_rounding, 0, 0);
                    this.displayOutput.move8x8FromIPFrame(n, n2, this.mv[0][1][0], this.mv[0][1][1], !this.no_rounding, 8, 0);
                    this.displayOutput.move8x8FromIPFrame(n, n2, this.mv[0][2][0], this.mv[0][2][1], !this.no_rounding, 0, 8);
                    this.displayOutput.move8x8FromIPFrame(n, n2, this.mv[0][3][0], this.mv[0][3][1], !this.no_rounding, 8, 8);
                }
                this.displayOutput.addLuminanceIdct(n * 2, n2 * 2, this.block[0]);
                this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2, this.block[1]);
                this.displayOutput.addLuminanceIdct(n * 2, n2 * 2 + 1, this.block[2]);
                this.displayOutput.addLuminanceIdct(n * 2 + 1, n2 * 2 + 1, this.block[3]);
                this.displayOutput.addBlueIdct(n, n2, this.block[4]);
                this.displayOutput.addRedIdct(n, n2, this.block[5]);
            }
        } else {
            this.skipTable[n][n2] = false;
            if (bl || bl2) {
                this.mbintra_table[n2 * this.mbWidth + n] = 1;
            }
            this.mv_type = 0;
            n5 = 0;
            n6 = 0;
            n4 = n;
            n3 = n2;
            this.dct_unquantize_h263(0);
            this.dct_unquantize_h263(1);
            this.dct_unquantize_h263(2);
            this.dct_unquantize_h263(3);
            this.dct_unquantize_h263(4);
            this.dct_unquantize_h263(5);
            this.displayOutput.putLuminanceIdct(n * 2, n2 * 2, this.block[0]);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n2 * 2, this.block[1]);
            this.displayOutput.putLuminanceIdct(n * 2, n2 * 2 + 1, this.block[2]);
            this.displayOutput.putLuminanceIdct(n * 2 + 1, n2 * 2 + 1, this.block[3]);
            this.displayOutput.putBlueIdct(n, n2, this.block[4]);
            this.displayOutput.putRedIdct(n, n2, this.block[5]);
        }
        if (this.pict_type != B_TYPE) {
            // empty if block
        }
        if (this.pict_type != B_TYPE && this.mv_type != 1) {
            for (n4 = 0; n4 < 4; ++n4) {
                this.motion_val[this.blockIndex[n4]][0] = n5;
                this.motion_val[this.blockIndex[n4]][1] = n6;
            }
        }
        System.arraycopy(this.blank, 0, this.block[0], 0, 64);
        System.arraycopy(this.blank, 0, this.block[1], 0, 64);
        System.arraycopy(this.blank, 0, this.block[2], 0, 64);
        System.arraycopy(this.blank, 0, this.block[3], 0, 64);
        System.arraycopy(this.blank, 0, this.block[4], 0, 64);
        System.arraycopy(this.blank, 0, this.block[5], 0, 64);
    }

    protected void initialise(int n, int n2) {
        int n3;
        this.width = n;
        this.height = n2;
        this.mbWidth = (n + 15) / 16;
        this.mbHeight = (n2 + 15) / 16;
        this.mb_stride = this.mbWidth;
        this.blockWrap[0] = this.mbWidth * 2 + 1;
        this.blockWrap[1] = this.mbWidth * 2 + 1;
        this.blockWrap[2] = this.mbWidth * 2 + 1;
        this.blockWrap[3] = this.mbWidth * 2 + 1;
        this.blockWrap[4] = this.mbWidth + 1;
        this.blockWrap[5] = this.mbWidth + 1;
        this.mb_type_b_frame = new int[this.mbWidth * this.mbHeight * 2];
        this.mb_type_ip_frame = new int[this.mbWidth * this.mbHeight * 2];
        this.cbp_table = new int[this.mbWidth * this.mbHeight * 2];
        this.qscale_table = new int[this.mbWidth * this.mbHeight * 2];
        for (n3 = 0; n3 < this.qscale_table.length; ++n3) {
            this.qscale_table[n3] = 4;
        }
        this.motion_val = new int[this.mbWidth * this.mbHeight * 4 * 2][2];
        this.ac_val = new int[this.mbWidth * (this.mbHeight + 2) * 4 * 16 * 2];
        this.dc_val = new int[this.mbWidth * this.mbHeight * 4 * 2];
        this.pred_dir_table = new int[this.mbWidth * this.mbHeight * 2];
        this.skipTable = new boolean[this.mbWidth * 2][this.mbHeight * 2];
        this.mb_skiptable = new boolean[this.mbWidth * 2][this.mbHeight * 2];
        this.mbintra_table = new int[this.mbWidth * this.mbHeight * 2];
        for (n3 = 0; n3 < this.dc_val.length; ++n3) {
            this.dc_val[n3] = 1024;
        }
        this.displayOutput = new DisplayOutput(this.mbWidth, this.mbHeight);
    }

    public DIVXCodec() {
    }

    public DIVXCodec(int n, int n2) {
        this.initialise(n, n2);
    }

    public Format[] getSupportedInputFormats() {
        return new Format[]{new VideoFormat("DIVX")};
    }

    public Format[] getSupportedOutputFormats(Format format) {
        return new Format[]{new RGBFormat()};
    }

    public Format setInputFormat(Format format) {
        this.inputFormat = (VideoFormat)format;
        this.initialise((int)this.inputFormat.getSize().getWidth(), (int)this.inputFormat.getSize().getHeight());
        return format;
    }

    public Format setOutputFormat(Format format) {
        return new RGBFormat(new Dimension(this.mbWidth * 16, this.mbHeight * 16), -1, new int[0].getClass(), this.inputFormat.getFrameRate(), 32, 0xFF0000, 65280, 255);
    }

    private static final int mid_pred(int n, int n2, int n3) {
        if (n > n2) {
            if (n3 > n2) {
                n2 = n3 > n ? n : n3;
            }
        } else if (n2 > n3) {
            n2 = n3 > n ? n3 : n;
        }
        return n2;
    }

    private void h263_pred_motion(int n) {
        boolean bl = true;
        int[] nArray = new int[]{2, 1, 1, -1};
        int n2 = this.blockIndex[n];
        int n3 = this.blockWrap[n];
        int[] nArray2 = this.motion_val[n2 - 1];
        if (!this.first_slice_line || n >= 3) {
            int[] nArray3 = this.motion_val[n2 - n3];
            int[] nArray4 = this.motion_val[n2 + nArray[n] - n3];
            this.h263_predMotionX = DIVXCodec.mid_pred(nArray2[0], nArray3[0], nArray4[0]);
            this.h263_predMotionY = DIVXCodec.mid_pred(nArray2[1], nArray3[1], nArray4[1]);
        } else if (n == 0) {
            if (this.mb_x == this.resync_mb_x) {
                this.h263_predMotionX = 0;
                this.h263_predMotionY = 0;
            } else if (this.mb_x + 1 == this.resync_mb_x && bl) {
                int[] nArray5 = this.motion_val[n2 + nArray[n] - n3];
                if (this.mb_x == 0) {
                    this.h263_predMotionX = nArray5[0];
                    this.h263_predMotionY = nArray5[1];
                } else {
                    this.h263_predMotionX = DIVXCodec.mid_pred(nArray2[0], 0, nArray5[0]);
                    this.h263_predMotionY = DIVXCodec.mid_pred(nArray2[1], 0, nArray5[1]);
                }
            } else {
                this.h263_predMotionX = nArray2[0];
                this.h263_predMotionY = nArray2[1];
            }
        } else if (n == 1) {
            if (this.mb_x + 1 == this.resync_mb_x && bl) {
                int[] nArray6 = this.motion_val[n2 + nArray[n] - n3];
                this.h263_predMotionX = DIVXCodec.mid_pred(nArray2[0], 0, nArray6[0]);
                this.h263_predMotionY = DIVXCodec.mid_pred(nArray2[1], 0, nArray6[1]);
            } else {
                this.h263_predMotionX = nArray2[0];
                this.h263_predMotionY = nArray2[1];
            }
        } else {
            int[] nArray7 = this.motion_val[n2 - n3];
            int[] nArray8 = this.motion_val[n2 + nArray[n] - n3];
            if (this.mb_x == this.resync_mb_x) {
                nArray2[0] = 0;
                nArray2[1] = 0;
            }
            this.h263_predMotionX = DIVXCodec.mid_pred(nArray2[0], nArray7[0], nArray8[0]);
            this.h263_predMotionY = DIVXCodec.mid_pred(nArray2[1], nArray7[1], nArray8[1]);
        }
    }

    private int h263_decode_motion(int n, int n2) throws FFMpegException {
        int n3 = this.in.getVLC(this.mv_vlc);
        if (n3 == 0) {
            return n;
        }
        boolean bl = this.in.getTrueFalse();
        int n4 = n2 - 1;
        int n5 = n3;
        if (n4 != 0) {
            n5 = n5 - 1 << n4;
            n5 |= this.in.getBits(n4);
            ++n5;
        }
        if (bl) {
            n5 = -n5;
        }
        n5 += n;
        boolean bl2 = false;
        if (!bl2) {
            int n6 = 27 - n2;
            n5 = (n5 << n6 & 0xFFFFFFFF) >> n6;
        } else {
            if (n < -31 && n5 < -63) {
                n5 += 64;
            }
            if (n > 32 && n5 > 63) {
                n5 -= 64;
            }
        }
        return n5;
    }

    private static final int ROUNDED_DIV(int n, int n2) {
        return (n > 0 ? n + (n2 >> 1) : n - (n2 >> 1)) / n2;
    }

    private void mpeg4_pred_ac(int[] nArray, int n) {
        int n2;
        int n3;
        int n4 = n3 = this.blockIndex[n] * 16 + this.mbWidth * 16;
        if (this.ac_pred) {
            int n5;
            if (!this.dc_pred_dir) {
                n5 = this.mb_x - 1 + this.mb_y * this.mbWidth - 1;
                n3 -= 16;
                if (this.mb_x == 0 || this.qscale == this.qscale_table[n5 + 1] || n == 1 || n == 3) {
                    for (n2 = 1; n2 < 8; ++n2) {
                        int n6 = n2 << 3;
                        nArray[n6] = nArray[n6] + this.ac_val[n2 + n3];
                    }
                } else {
                    for (n2 = 1; n2 < 8; ++n2) {
                        int n7 = n2 << 3;
                        nArray[n7] = nArray[n7] + DIVXCodec.ROUNDED_DIV(this.ac_val[n2 + n3] * this.qscale_table[n5 + 1], this.qscale);
                    }
                }
            } else {
                n5 = this.mb_x + (this.mb_y - 1) * this.mbWidth - 1;
                n3 -= 16 * this.blockWrap[n];
                if (this.mb_y == 0 || this.qscale == this.qscale_table[n5 + 1] || n == 2 || n == 3) {
                    for (n2 = 1; n2 < 8; ++n2) {
                        int n8 = n2;
                        nArray[n8] = nArray[n8] + this.ac_val[n2 + 8 + n3];
                    }
                } else {
                    for (n2 = 1; n2 < 8; ++n2) {
                        int n9 = n2;
                        nArray[n9] = nArray[n9] + DIVXCodec.ROUNDED_DIV(this.ac_val[n2 + 8 + n3] * this.qscale_table[n5 + 1], this.qscale);
                    }
                }
            }
        }
        for (n2 = 1; n2 < 8; ++n2) {
            this.ac_val[n2 + n4] = nArray[n2 << 3];
        }
        for (n2 = 1; n2 < 8; ++n2) {
            this.ac_val[8 + n2 + n4] = nArray[n2];
        }
    }

    private int mpeg4_decode_dc(int n) throws FFMpegException {
        int n2;
        int n3 = 0;
        int n4 = n < 4 ? this.in.getVLC(this.dc_lumTable) : this.in.getVLC(this.dc_chromTable);
        if (n4 != 0) {
            n3 = this.in.getBits(n4);
            if ((n3 & 1 << n4 - 1) == 0) {
                n3 = -1 << n4 | n3 + 1;
            }
            if (n4 > 8) {
                this.in.getTrueFalse();
            }
        }
        int n5 = n < 4 ? this.y_dc_scale : this.c_dc_scale;
        int n6 = this.blockIndex[n];
        int n7 = this.blockWrap[n];
        int n8 = this.dc_val[n6 - 1];
        int n9 = this.dc_val[n6 - 1 - n7];
        int n10 = this.dc_val[n6 - n7];
        if (this.first_slice_line && n != 3) {
            if (n != 2) {
                n9 = 1024;
                n10 = 1024;
            }
            if (n != 1 && this.mb_x == this.resync_mb_x) {
                n8 = 1024;
                n9 = 1024;
            }
        }
        if (this.mb_x == this.resync_mb_x && this.mb_y == this.resync_mb_y + 1 && (n == 0 || n == 4 || n == 5)) {
            n9 = 1024;
        }
        if ((n8 - n9) * (n8 - n9) < (n9 - n10) * (n9 - n10)) {
            n2 = n10;
            this.dc_pred_dir = true;
        } else {
            n2 = n8;
            this.dc_pred_dir = false;
        }
        n2 = (n2 + (n5 >> 1)) / n5;
        if ((n3 += n2) < 0) {
            n3 = 0;
        }
        this.dc_val[n6] = n3 * (n < 4 ? this.y_dc_scale : this.c_dc_scale);
        return n3;
    }

    private void mpeg4_decode_block(int[] nArray, int n, boolean bl, boolean bl2) throws FFMpegException {
        int n2;
        boolean bl3 = false;
        int[] nArray2 = this.intra_scantable;
        RLTable rLTable = null;
        int n3 = 0;
        int n4 = 1;
        int n5 = 0;
        if (bl2) {
            if (this.qscale < this.intra_dc_threshold) {
                if (this.partitioned_frame) {
                    n2 = this.dc_val[this.blockIndex[n]];
                    n2 = n < 4 ? (n2 + (this.y_dc_scale >> 1)) / this.y_dc_scale : (n2 + (this.c_dc_scale >> 1)) / this.c_dc_scale;
                    this.dc_pred_dir = 0 != (this.pred_dir_table[this.mb_x + this.mb_y * this.mb_stride] << n & 0x20);
                } else {
                    n2 = this.mpeg4_decode_dc(n);
                }
                nArray[0] = n2;
                n3 = 0;
            } else {
                n3 = -1;
            }
            if (bl) {
                RLTable rLTable2 = rLTable = bl3 ? this.rvlc_rl_intra : this.rl_intra;
                nArray2 = this.ac_pred ? (!this.dc_pred_dir ? this.intra_v_scantable : this.intra_h_scantable) : this.intra_scantable;
                n4 = 1;
                n5 = 0;
            }
        } else {
            n3 = -1;
            if (!bl) {
                this.block_last_index[n] = n3;
                return;
            }
            rLTable = bl3 ? this.rvlc_rl_inter : this.rl_inter;
            nArray2 = this.intra_scantable;
            if (this.mpeg_quant) {
                n4 = 1;
                n5 = 0;
            } else {
                n4 = this.qscale << 1;
                n5 = this.qscale - 1 | 1;
            }
        }
        while (bl) {
            int n6 = this.in.getVLC(rLTable);
            n2 = rLTable.getLevel(n6);
            int n7 = rLTable.getRun(n6);
            boolean bl4 = false;
            if (n2 == 0) {
                if (!bl3) {
                    if (this.in.getTrueFalse()) {
                        if (this.in.getTrueFalse()) {
                            bl4 = this.in.getTrueFalse();
                            n7 = this.in.getBits(6);
                            this.in.getTrueFalse();
                            n2 = this.in.getBits(12);
                            if ((n2 & 0x800) != 0) {
                                n2 |= 0xFFFFF800;
                            }
                            this.in.getTrueFalse();
                            n2 = n2 * n4 + (n2 > 0 ? n5 : -n5);
                            n3 += n7 + 1;
                            if (bl4) {
                                n3 += 192;
                            }
                        } else {
                            n6 = this.in.getVLC(rLTable);
                            n2 = rLTable.getLevel(n6);
                            n7 = rLTable.getRun(n6);
                            n3 += n7 + rLTable.getMaxRun()[n7 >> 7][n2] + 1;
                            n2 = n2 * n4 + n5;
                            if (this.in.getTrueFalse()) {
                                n2 = -n2;
                            }
                        }
                    } else {
                        n6 = this.in.getVLC(rLTable);
                        n7 = rLTable.getRun(n6);
                        n2 = rLTable.getLevel(n6) * n4 + n5;
                        n3 += n7;
                        n2 += rLTable.getMaxLevel()[n7 >> 7][n7 - 1 & 0x3F] * n4;
                        if (this.in.getTrueFalse()) {
                            n2 = -n2;
                        }
                    }
                }
            } else {
                n3 += n7;
                n2 = n2 * n4 + n5;
                if (this.in.getTrueFalse()) {
                    n2 = -n2;
                }
            }
            if (n3 > 62) {
                nArray[nArray2[n3 -= 192]] = n2;
                break;
            }
            nArray[nArray2[n3]] = n2;
        }
        if (this.mb_intra) {
            if (this.qscale >= this.intra_dc_threshold) {
                System.out.println("TODO preddc");
                if (n3 == -1) {
                    n3 = 0;
                }
            }
            this.mpeg4_pred_ac(nArray, n);
            if (this.ac_pred) {
                n3 = 63;
            }
        }
        this.block_last_index[n] = n3;
    }

    private int get_amv(int n) throws FFMpegException {
        System.out.println("get_amv " + n);
        return n;
    }

    private void ff_mpeg4_decode_mb() throws FFMpegException {
        int n;
        int n2;
        int n3;
        int n4;
        boolean bl = false;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = this.mb_x + this.mb_y * this.mbWidth;
        if (this.pict_type == P_TYPE || this.pict_type == S_TYPE) {
            do {
                if (!this.in.getTrueFalse()) continue;
                this.mb_intra = false;
                for (int i = 0; i < 6; ++i) {
                    this.block_last_index[i] = -1;
                }
                this.mv_dir = 2;
                this.mv_type = 0;
                if (this.pict_type == S_TYPE && this.vol_sprite_usage == 2) {
                    this.mb_type[n8] = 15368;
                    this.mcsel = true;
                    this.mv[0][0][0] = this.get_amv(0);
                    this.mv[0][0][1] = this.get_amv(1);
                    this.mb_skipped = false;
                } else {
                    this.mb_type[n8] = 14344;
                    this.mcsel = false;
                    this.mv[0][0][0] = 0;
                    this.mv[0][0][1] = 0;
                    this.mb_skipped = true;
                }
                return;
            } while ((n6 = this.in.getVLC(this.inter_MCBPC)) == 20);
            n7 = n6 & 8;
            boolean bl2 = this.mb_intra = (n6 & 4) != 0;
            if (!this.mb_intra) {
                Object object;
                n4 = 0;
                n3 = 0;
                this.mcsel = false;
                if (this.pict_type == S_TYPE && this.vol_sprite_usage == 2 && (n6 & 0x10) == 0) {
                    this.mcsel = this.in.getTrueFalse();
                }
                n2 = this.in.getVLC(this.cbpyVlc) ^ 0xF;
                n5 = n6 & 3 | n2 << 2;
                if (n7 != 0) {
                    object = new int[]{-1, -2, 1, 2};
                    this.ff_set_qscale(this.qscale + object[this.in.getBits(2)]);
                }
                if (!this.progressive_sequence && n5 != 0) {
                    boolean bl3 = this.in.getTrueFalse();
                }
                this.mv_dir = 2;
                if ((n6 & 0x10) == 0) {
                    if (this.mcsel) {
                        this.mb_type[n8] = 13320;
                        this.mv_type = 0;
                        n4 = this.get_amv(0);
                        n3 = this.get_amv(1);
                        this.mv[0][0][0] = n4;
                        this.mv[0][0][1] = n3;
                    } else if (!this.progressive_sequence && this.in.getTrueFalse()) {
                        this.mb_type[n8] = 12432;
                        this.mv_type = 3;
                        object = new boolean[2][2];
                        object[0][0] = this.in.getTrueFalse();
                        object[0][1] = this.in.getTrueFalse();
                        this.h263_pred_motion(0);
                        for (n = 0; n < 2; ++n) {
                            n4 = this.h263_decode_motion(this.h263_predMotionX, this.f_code);
                            n3 = this.h263_decode_motion(this.h263_predMotionY / 2, this.f_code);
                            this.mv[0][n][0] = n4;
                            this.mv[0][n][1] = n3;
                        }
                    } else {
                        this.mb_type[n8] = 12296;
                        this.mv_type = 0;
                        this.h263_pred_motion(0);
                        n4 = this.h263_decode_motion(this.h263_predMotionX, this.f_code);
                        n3 = this.h263_decode_motion(this.h263_predMotionY, this.f_code);
                        this.mv[0][0][0] = n4;
                        this.mv[0][0][1] = n3;
                    }
                } else {
                    this.mb_type[n8] = 12352;
                    this.mv_type = 1;
                    for (int i = 0; i < 4; ++i) {
                        this.h263_pred_motion(i);
                        n4 = this.h263_decode_motion(this.h263_predMotionX, this.f_code);
                        n3 = this.h263_decode_motion(this.h263_predMotionY, this.f_code);
                        this.mv[0][i][0] = n4;
                        this.mv[0][i][1] = n3;
                        this.motion_val[this.blockIndex[i]][0] = n4;
                        this.motion_val[this.blockIndex[i]][1] = n3;
                    }
                }
            }
        } else if (this.pict_type == B_TYPE) {
            this.mb_intra = false;
            n4 = 0;
            n3 = 0;
            if (this.mb_x == 0) {
                for (n2 = 0; n2 < 2; ++n2) {
                    this.last_mv[n2][0][0] = 0;
                    this.last_mv[n2][0][1] = 0;
                    this.last_mv[n2][1][0] = 0;
                    this.last_mv[n2][1][1] = 0;
                }
            }
            if (this.mb_skiptable[this.mb_x][this.mb_y]) {
                this.mv_dir = 2;
                this.mv_type = 0;
                this.mv[0][0][0] = 0;
                this.mv[0][0][1] = 0;
                this.mv[1][0][0] = 0;
                this.mv[1][0][1] = 0;
                this.mb_type[n8] = 14344;
                return;
            }
            n2 = this.in.getTrueFalse() ? 1 : 0;
            if (n2 != 0) {
                this.mb_type[n8] = 63744;
                n5 = 0;
            } else {
                boolean bl4 = this.in.getTrueFalse();
                this.mb_type[n8] = this.in.getVLC(this.mb_type_b);
                this.mb_type[n8] = mb_type_b_map[this.mb_type[n8]];
                n5 = bl4 ? 0 : this.in.getBits(6);
                if ((0x100 & this.mb_type[n8]) == 0 && n5 != 0 && this.in.getTrueFalse()) {
                    this.ff_set_qscale(this.qscale + this.in.getBits(1) * 4 - 2);
                }
                if (!this.progressive_sequence) {
                    if (n5 != 0) {
                        this.interlaced_dct = this.in.getTrueFalse();
                    }
                    if ((0x100 & this.mb_type[n8]) == 0 && this.in.getTrueFalse()) {
                        int n9 = n8;
                        this.mb_type[n9] = this.mb_type[n9] | 0x90;
                        int n10 = n8;
                        this.mb_type[n10] = this.mb_type[n10] & 0xFFFFFFF7;
                        if (DIVXCodec.USES_LIST(this.mb_type[n8], 0)) {
                            this.field_select[0][0] = this.in.getBits(1);
                            this.field_select[0][1] = this.in.getBits(1);
                        }
                        if (DIVXCodec.USES_LIST(this.mb_type[n8], 1)) {
                            this.field_select[1][0] = this.in.getBits(1);
                            this.field_select[1][1] = this.in.getBits(1);
                        }
                    }
                }
                this.mv_dir = 0;
                if ((this.mb_type[n8] & 0x180) == 0) {
                    this.mv_type = 0;
                    if (DIVXCodec.USES_LIST(this.mb_type[n8], 0)) {
                        this.mv_dir = 2;
                        n4 = this.h263_decode_motion(this.last_mv[0][0][0], this.f_code);
                        n3 = this.h263_decode_motion(this.last_mv[0][0][1], this.f_code);
                        this.last_mv[0][1][0] = n4;
                        this.last_mv[0][0][0] = n4;
                        this.mv[0][0][0] = n4;
                        this.last_mv[0][1][1] = n3;
                        this.last_mv[0][0][1] = n3;
                        this.mv[0][0][1] = n3;
                    }
                    if (DIVXCodec.USES_LIST(this.mb_type[n8], 1)) {
                        this.mv_dir |= 1;
                        n4 = this.h263_decode_motion(this.last_mv[1][0][0], this.b_code);
                        n3 = this.h263_decode_motion(this.last_mv[1][0][1], this.b_code);
                        this.last_mv[1][1][0] = n4;
                        this.last_mv[1][0][0] = n4;
                        this.mv[1][0][0] = n4;
                        this.last_mv[1][1][1] = n3;
                        this.last_mv[1][0][1] = n3;
                        this.mv[1][0][1] = n3;
                    }
                } else if ((0x100 & this.mb_type[n8]) == 0) {
                    this.mv_type = 3;
                    if (DIVXCodec.USES_LIST(this.mb_type[n8], 0)) {
                        this.mv_dir = 2;
                        for (n = 0; n < 2; ++n) {
                            n4 = this.h263_decode_motion(this.last_mv[0][n][0], this.f_code);
                            n3 = this.h263_decode_motion(this.last_mv[0][n][1] / 2, this.f_code);
                            this.last_mv[0][n][0] = n4;
                            this.mv[0][n][0] = n4;
                            this.last_mv[0][n][1] = n3 * 2;
                            this.mv[0][n][1] = n3;
                        }
                    }
                    if (DIVXCodec.USES_LIST(this.mb_type[n8], 1)) {
                        this.mv_dir |= 1;
                        for (n = 0; n < 2; ++n) {
                            n4 = this.h263_decode_motion(this.last_mv[1][n][0], this.b_code);
                            n3 = this.h263_decode_motion(this.last_mv[1][n][1] / 2, this.b_code);
                            this.last_mv[1][n][0] = n4;
                            this.mv[1][n][0] = n4;
                            this.last_mv[1][n][1] = n3 * 2;
                            this.mv[1][n][1] = n3;
                        }
                    }
                }
            }
            if ((0x100 & this.mb_type[n8]) != 0) {
                if ((0x800 & this.mb_type[n8]) != 0) {
                    n4 = 0;
                    n3 = 0;
                } else {
                    n4 = this.h263_decode_motion(0, 1);
                    n3 = this.h263_decode_motion(0, 1);
                }
                this.mv_dir = 7;
                int n11 = n8;
                this.mb_type[n11] = this.mb_type[n11] | this.ff_mpeg4_set_direct_mv(n4, n3);
            }
        } else {
            while ((n6 = this.in.getVLC(this.intra_MCBPC)) == 8) {
            }
            n7 = n6 & 4;
            this.mb_intra = true;
        }
        if (this.mb_intra) {
            this.ac_pred = this.in.getTrueFalse();
            this.mb_type[n8] = 1;
            if (this.ac_pred) {
                this.mb_type[n8] = 513;
            }
            n4 = this.in.getVLC(this.cbpyVlc);
            n5 = n6 & 3 | n4 << 2;
            if (n7 != 0) {
                this.ff_set_qscale(this.qscale + this.quant_tab[this.in.getBits(2)]);
            }
            if (!this.progressive_sequence) {
                this.interlaced_dct = this.in.getTrueFalse();
            }
            bl = true;
        }
        for (n4 = 0; n4 < 6; ++n4) {
            this.mpeg4_decode_block(this.block[n4], n4, (n5 & 0x20) != 0, bl);
            n5 <<= 1;
        }
    }

    private int ff_mpeg4_set_direct_mv(int n, int n2) {
        int n3;
        int n4 = this.pb_time;
        int n5 = this.pp_time;
        int n6 = this.mb_x + this.mb_y * this.mbWidth;
        int n7 = this.mb_type_ip_frame[n6];
        int n8 = this.blockIndex[0];
        this.next_motion_val = this.motion_val;
        if ((0x40 & n7) != 0) {
            this.mv_type = 1;
            for (int i = 0; i < 4; ++i) {
                n8 = this.blockIndex[i];
                this.mv[0][i][0] = this.next_motion_val[n8][0] * n4 / n5 + n;
                this.mv[0][i][1] = this.next_motion_val[n8][1] * n4 / n5 + n2;
                this.mv[1][i][0] = n == 0 ? this.mv[0][i][0] - this.next_motion_val[n8][0] : this.next_motion_val[n8][0] * (n4 - n5) / n5;
                this.mv[1][i][1] = n2 == 0 ? this.mv[0][i][1] - this.next_motion_val[n8][1] : this.next_motion_val[n8][1] * (n4 - n5) / n5;
            }
            return 61760;
        }
        if ((0x80 & n7) != 0) {
            System.out.println("TODO:  IS_INTERLACED");
            return 61840;
        }
        this.mv[0][0][0] = n3 = this.next_motion_val[n8][0] * n4 / n5 + n;
        this.mv[0][1][0] = n3;
        this.mv[0][2][0] = n3;
        this.mv[0][3][0] = n3;
        this.mv[0][0][1] = n3 = this.next_motion_val[n8][1] * n4 / n5 + n2;
        this.mv[0][1][1] = n3;
        this.mv[0][2][1] = n3;
        this.mv[0][3][1] = n3;
        this.mv[1][0][0] = n3 = n != 0 ? this.mv[0][0][0] - this.next_motion_val[n8][0] : this.next_motion_val[n8][0] * (n4 - n5) / n5;
        this.mv[1][1][0] = n3;
        this.mv[1][2][0] = n3;
        this.mv[1][3][0] = n3;
        this.mv[1][0][1] = n3 = n2 != 0 ? this.mv[0][0][1] - this.next_motion_val[n8][1] : this.next_motion_val[n8][1] * (n4 - n5) / n5;
        this.mv[1][1][1] = n3;
        this.mv[1][2][1] = n3;
        this.mv[1][3][1] = n3;
        this.mv_type = !this.quarter_sample ? 0 : 1;
        return 61704;
    }

    private void ff_set_qscale(int n) {
        if (n < 1) {
            n = 1;
        } else if (n > 31) {
            n = 31;
        }
        this.qscale = n;
        int n2 = this.chroma_qscale_table[n];
        this.y_dc_scale = this.ff_mpeg4_y_dc_scale_table[n];
        this.c_dc_scale = this.ff_mpeg4_c_dc_scale_table[n2];
    }

    private static final boolean USES_LIST(int n, int n2) {
        return (n & 12288 << 2 * n2) != 0;
    }

    private void mpeg4_decode_partitioned_mb() throws FFMpegException {
        int n;
        int n2;
        int n3 = this.mb_x + this.mb_y * this.mbWidth;
        int n4 = this.mb_type[n3];
        int n5 = this.cbp_table[n3];
        if (this.qscale != this.qscale_table[n3]) {
            this.ff_set_qscale(this.qscale_table[n3]);
        }
        if (this.pict_type == P_TYPE || this.pict_type == S_TYPE) {
            boolean bl;
            int n6;
            for (n2 = 0; n2 < 4; ++n2) {
                this.mv[0][n2][0] = this.motion_val[this.blockIndex[n2]][0];
                this.mv[0][n2][1] = this.motion_val[this.blockIndex[n2]][1];
            }
            this.mb_intra = (7 & n4) != 0;
            int n7 = n2 = (0x800 & n4) != 0 ? 1 : 0;
            if (n2 != 0) {
                for (n = 0; n < 6; ++n) {
                    this.block_last_index[n] = -1;
                }
                n6 = 2;
                bl = false;
                n = 0;
                this.mb_skipped = true;
                if (this.pict_type == S_TYPE && this.vol_sprite_usage == 2) {
                    n = 1;
                    this.mb_skipped = false;
                }
            } else if (this.mb_intra) {
                this.ac_pred = (0x200 & n4) != 0;
                bl = false;
            } else if (!this.mb_intra) {
                n6 = 2;
                bl = false;
                if ((0x40 & n4) != 0) {
                    bl = true;
                }
            }
        } else {
            this.mb_intra = true;
            this.ac_pred = (0x200 & n4) != 0;
        }
        int n8 = n2 = (0x800 & n4) != 0 ? 1 : 0;
        if (n2 == 0) {
            for (n = 0; n < 6; ++n) {
                n5 <<= 1;
            }
        }
    }

    private void decode_slice() throws FFMpegException {
        int n = this.in.getPos();
        this.first_slice_line = true;
        this.resync_mb_x = this.mb_x;
        this.resync_mb_y = this.mb_y;
        this.ff_set_qscale(this.qscale);
        while (this.mb_y < this.mbHeight) {
            this.blockIndex[0] = this.blockWrap[0] * (this.mb_y * 2 + 1) - 1;
            this.blockIndex[1] = this.blockIndex[0] + 1;
            this.blockIndex[2] = this.blockIndex[0] + this.blockWrap[0];
            this.blockIndex[3] = this.blockIndex[2] + 1;
            this.blockIndex[4] = this.blockWrap[0] * (this.mbHeight * 2 + 1) + this.blockWrap[4] * (this.mb_y + 1);
            this.blockIndex[5] = this.blockIndex[4] + this.blockWrap[4] * (this.mbHeight + 1);
            while (this.mb_x < this.mbWidth) {
                int n2;
                this.blockIndex[0] = this.blockIndex[0] + 2;
                this.blockIndex[1] = this.blockIndex[1] + 2;
                this.blockIndex[2] = this.blockIndex[2] + 2;
                this.blockIndex[3] = this.blockIndex[3] + 2;
                this.blockIndex[4] = this.blockIndex[4] + 1;
                this.blockIndex[5] = this.blockIndex[5] + 1;
                if (this.resync_mb_x == this.mb_x && this.resync_mb_y == this.mb_y - 1) {
                    this.first_slice_line = false;
                }
                for (n2 = 0; n2 < 6; ++n2) {
                    System.arraycopy(this.blank, 0, this.block[n2], 0, this.blank.length);
                }
                n2 = 0;
                boolean bl = false;
                if (this.decode_mb == 0) {
                    this.ff_mpeg4_decode_mb();
                } else {
                    this.mpeg4_decode_partitioned_mb();
                }
                this.MPV_decode_mb(this.mb_x, this.mb_y);
                ++this.mb_x;
            }
            this.mb_x = 0;
            ++this.mb_y;
        }
    }

    private void decode_vol_header() throws FFMpegException {
        int n;
        int n2;
        int n3;
        this.in.getTrueFalse();
        this.vo_type = this.in.getBits(8);
        this.vo_ver_id = 1;
        if (this.in.getTrueFalse()) {
            this.vo_ver_id = this.in.getBits(4);
            this.in.getBits(3);
        }
        if ((n3 = this.in.getBits(4)) == FF_ASPECT_EXTENDED) {
            n2 = this.in.getBits(8);
            n = this.in.getBits(8);
        }
        this.vol_control_parameters = this.in.getTrueFalse();
        if (this.vol_control_parameters) {
            n2 = this.in.getBits(2);
            if (n2 != 1) {
                throw new FFMpegException("Illegal Chroma");
            }
            n = this.in.getTrueFalse() ? 1 : 0;
            if (this.in.getTrueFalse()) {
                this.in.getBits(15);
                this.in.getTrueFalse();
                this.in.getBits(15);
                this.in.getTrueFalse();
                this.in.getBits(15);
                this.in.getTrueFalse();
                this.in.getBits(3);
                this.in.getBits(11);
                this.in.getTrueFalse();
                this.in.getBits(15);
                this.in.getTrueFalse();
            }
        } else {
            n2 = 0;
        }
        this.shape = this.in.getBits(2);
        if (this.shape != 0) {
            // empty if block
        }
        if (this.shape == 3) {
            this.in.getBits(4);
        }
        this.in.getTrueFalse();
        this.time_increment_resolution = this.in.getBits(16);
        this.time_increment_bits = DIVXCodec.av_log2(this.time_increment_resolution - 1);
        if (this.time_increment_bits < 1) {
            this.time_increment_bits = 1;
        }
        this.in.getTrueFalse();
        if (this.in.getTrueFalse()) {
            this.in.getBits(this.time_increment_bits);
        }
        if (this.shape != 2) {
            int n4;
            int n5;
            if (this.shape == 0) {
                this.in.getTrueFalse();
                n2 = this.in.getBits(13);
                this.in.getTrueFalse();
                n = this.in.getBits(13);
                this.in.getTrueFalse();
                if (n2 != 0 && n != 0) {
                    this.width = n2;
                    this.height = n;
                }
            }
            this.progressive_sequence = !this.in.getTrueFalse();
            this.in.getTrueFalse();
            this.vol_sprite_usage = this.in.getBits(this.vo_ver_id == 1 ? 1 : 2);
            if (this.vol_sprite_usage == 1 || this.vol_sprite_usage == 2) {
                if (this.vol_sprite_usage == 1) {
                    n2 = this.in.getBits(13);
                    this.in.getTrueFalse();
                    n = this.in.getBits(13);
                    this.in.getTrueFalse();
                    n5 = this.in.getBits(13);
                    this.in.getTrueFalse();
                    n4 = this.in.getBits(13);
                    this.in.getTrueFalse();
                }
                this.num_sprite_warping_points = this.in.getBits(6);
                this.sprite_warping_accuracy = this.in.getBits(2);
                n2 = this.in.getTrueFalse() ? 1 : 0;
                if (this.vol_sprite_usage == 1) {
                    n = this.in.getTrueFalse() ? 1 : 0;
                }
            }
            this.quant_precision = 5;
            if (this.in.getTrueFalse()) {
                this.quant_precision = this.in.getBits(4);
                this.in.getBits(4);
            }
            this.mpeg_quant = this.in.getTrueFalse();
            if (this.mpeg_quant) {
                for (n2 = 0; n2 < 64; ++n2) {
                    this.intra_matrix[n2] = Tables.ff_mpeg4_default_intra_matrix[n2];
                    this.chroma_intra_matrix[n2] = Tables.ff_mpeg4_default_intra_matrix[n2];
                    this.inter_matrix[n2] = Tables.ff_mpeg4_default_non_intra_matrix[n2];
                    this.chroma_inter_matrix[n2] = Tables.ff_mpeg4_default_non_intra_matrix[n2];
                }
                if (this.in.getTrueFalse()) {
                    n2 = 0;
                    for (n = 0; n < 64 && (n5 = this.in.getBits(8)) != 0; ++n) {
                        n2 = n5;
                        this.intra_matrix[n] = n5;
                        this.chroma_intra_matrix[n] = n5;
                    }
                    while (n < 64) {
                        this.intra_matrix[n] = n2;
                        this.chroma_intra_matrix[n] = n2;
                        ++n;
                    }
                }
                if (this.in.getTrueFalse()) {
                    n2 = 0;
                    for (n = 0; n < 64 && (n5 = this.in.getBits(8)) != 0; ++n) {
                        n2 = n5;
                        this.inter_matrix[n] = n5;
                        this.chroma_inter_matrix[n] = n5;
                    }
                    while (n < 64) {
                        this.inter_matrix[n] = n2;
                        this.chroma_inter_matrix[n] = n2;
                        ++n;
                    }
                }
            }
            this.quarter_sample = false;
            if (this.vo_ver_id != 1) {
                this.quarter_sample = this.in.getTrueFalse();
            }
            this.in.getTrueFalse();
            this.resync_marker = !this.in.getTrueFalse();
            this.data_partitioning = this.in.getTrueFalse();
            if (this.data_partitioning) {
                n2 = this.in.getTrueFalse() ? 1 : 0;
            }
            n2 = 0;
            n = 0;
            if (this.vo_ver_id != 1) {
                n2 = this.in.getTrueFalse() ? 1 : 0;
                if (n2 != 0) {
                    this.in.getBits(3);
                }
                n = this.in.getTrueFalse() ? 1 : 0;
            }
            this.scalability = this.in.getTrueFalse();
            if (this.scalability) {
                n5 = this.in.getTrueFalse() ? 1 : 0;
                n4 = this.in.getBits(4);
                boolean bl = this.in.getTrueFalse();
                int n6 = this.in.getBits(5);
                int n7 = this.in.getBits(5);
                int n8 = this.in.getBits(5);
                int n9 = this.in.getBits(5);
                this.enhancement_type = this.in.getTrueFalse();
            }
        }
    }

    private static final int av_log2(int n) {
        int n2 = 0;
        while (n != 0) {
            n = n >> 1 & 0xFFFF;
            ++n2;
        }
        return n2;
    }

    private void decode_user_data() throws FFMpegException {
        int n;
        char[] cArray = new char[256];
        cArray[0] = (char)this.in.getBits(8);
        for (n = 1; n < 256; ++n) {
            cArray[n] = (char)this.in.showBits(8);
            if (cArray[n] == '\u0000') break;
            this.in.getBits(8);
        }
        String string = new String(cArray, 0, n);
    }

    private void mpeg4_decode_gop_header() throws FFMpegException {
        int n = this.in.getBits(5);
        int n2 = this.in.getBits(6);
        this.in.getTrueFalse();
        int n3 = this.in.getBits(6);
        this.in.getTrueFalse();
        this.in.getTrueFalse();
    }

    private boolean decode_vop_header() throws FFMpegException {
        int n;
        int n2;
        this.pict_type = this.in.getBits(2) + I_TYPE;
        this.partitioned_frame = this.data_partitioning & this.pict_type != B_TYPE;
        int n3 = this.decode_mb = this.partitioned_frame ? 1 : 0;
        if (this.time_increment_resolution == 0) {
            this.time_increment_resolution = 1;
        }
        int n4 = 0;
        while (this.in.getTrueFalse()) {
            ++n4;
        }
        if (!this.in.getTrueFalse()) {
            throw new FFMpegException("before_time_incr");
        }
        int n5 = this.in.getBits(this.time_increment_bits);
        if (this.pict_type != B_TYPE) {
            this.last_time_base = this.time_base;
            this.time_base += n4;
            n2 = this.time_base * this.time_increment_resolution + n5;
            this.pp_time = n2 - this.last_non_b_time;
            this.last_non_b_time = n2;
        } else {
            n2 = (this.last_time_base + n4) * this.time_increment_resolution + n5;
            this.pb_time = this.pp_time - (this.last_non_b_time - n2);
        }
        if (!this.in.getTrueFalse()) {
            throw new FFMpegException("before_vop_coded");
        }
        if (!this.in.getTrueFalse()) {
            return false;
        }
        this.no_rounding = false;
        if (this.shape != 2 && (this.pict_type == P_TYPE || this.pict_type == S_TYPE && this.vol_sprite_usage == 2)) {
            this.no_rounding = this.in.getTrueFalse();
        }
        if (this.shape != 0) {
            if (this.vol_sprite_usage != 1 || this.pict_type != I_TYPE) {
                n2 = this.in.getBits(13);
                this.in.getTrueFalse();
                n = this.in.getBits(13);
                this.in.getTrueFalse();
                int n6 = this.in.getBits(13);
                this.in.getTrueFalse();
                int n7 = this.in.getBits(13);
            }
            this.in.getTrueFalse();
            if (this.in.getTrueFalse()) {
                this.in.getBits(8);
            }
        }
        if (this.shape != 2) {
            n2 = this.in.getBits(3);
            this.intra_dc_threshold = mpeg4_dc_threshold[n2];
            this.alternate_scan = false;
            if (!this.progressive_sequence) {
                this.top_field_first = this.in.getTrueFalse();
                this.alternate_scan = this.in.getTrueFalse();
            }
        }
        if (this.alternate_scan) {
            this.inter_scantable = ff_alternate_vertical_scan;
            this.intra_scantable = ff_alternate_vertical_scan;
            this.intra_h_scantable = ff_alternate_vertical_scan;
            this.intra_v_scantable = ff_alternate_vertical_scan;
        } else {
            this.inter_scantable = ff_zigzag_direct;
            this.intra_scantable = ff_zigzag_direct;
            this.intra_h_scantable = ff_alternate_horizontal_scan;
            this.intra_v_scantable = ff_alternate_vertical_scan;
        }
        if (this.pict_type == S_TYPE && (this.vol_sprite_usage == 1 || this.vol_sprite_usage == 2)) {
            throw new FFMpegException("mpeg4_decode_sprite_trajectory");
        }
        if (this.shape != 2) {
            n2 = this.qscale = this.in.getBits(this.quant_precision);
            this.f_code = 1;
            if (this.pict_type != I_TYPE) {
                this.f_code = this.in.getBits(3);
            }
            this.b_code = 1;
            if (this.pict_type == B_TYPE) {
                this.b_code = this.in.getBits(3);
            }
            if (!this.scalability) {
                if (this.shape != 0 && this.pict_type != I_TYPE) {
                    this.in.getTrueFalse();
                }
            } else {
                if (this.enhancement_type && (n = (int)(this.in.getTrueFalse() ? 1 : 0)) != 0) {
                    throw new FFMpegException("backward");
                }
                this.in.getBits(2);
            }
        }
        return true;
    }

    private void ff_mpeg4_decode_picture_header() throws FFMpegException {
        this.in.seek(this.in.getPos() - (this.in.getPos() & 7));
        long l = 255L;
        while (this.in.availableBits() >= 8) {
            if ((int)((l = (l << 8 | (long)this.in.getBits(8)) & 0xFFFFFFFFFFFFFFFFL) & 0xFFFFFFFFFFFFFF00L) != 256) continue;
            switch ((int)(l & 0x1FFL)) {
                case 288: {
                    this.decode_vol_header();
                    break;
                }
                case 434: {
                    this.decode_user_data();
                    break;
                }
                case 435: {
                    this.mpeg4_decode_gop_header();
                    break;
                }
                case 438: {
                    if (!this.decode_vop_header()) break;
                    return;
                }
            }
            l = 255L;
            this.in.seek(this.in.getPos() - (this.in.getPos() & 7));
        }
    }

    protected void decodeFrame(Buffer buffer) throws FFMpegException {
        this.ff_mpeg4_decode_picture_header();
        this.mb_type = this.pict_type == B_TYPE ? this.mb_type_b_frame : this.mb_type_ip_frame;
        this.mb_x = 0;
        this.mb_y = 0;
        do {
            this.decode_slice();
        } while (this.mb_y < this.mbHeight);
        this.displayOutput.expandIntoBoarder();
        if (this.pict_type != B_TYPE) {
            this.displayOutput.showNextScreen(buffer);
            this.displayOutput.endIPFrame();
        } else {
            this.displayOutput.endBFrame();
            this.displayOutput.showScreen(buffer);
        }
    }

    public int process(Buffer buffer, Buffer buffer2) {
        try {
            byte[] byArray = (byte[])buffer.getData();
            this.in.addData(byArray, buffer.getOffset(), buffer.getLength());
            this.decodeFrame(buffer2);
            buffer2.setTimeStamp(buffer.getTimeStamp());
            buffer2.setFlags(buffer.getFlags());
        }
        catch (Throwable throwable) {
            System.out.println(throwable);
            throwable.printStackTrace();
            return 0;
        }
        return 0;
    }

    public void open() {
    }

    public void close() {
    }

    public void reset() {
    }

    public String getName() {
        return "DIVX video decoder";
    }

    public Object[] getControls() {
        return new Object[0];
    }

    public Object getControl(String string) {
        return null;
    }

    public boolean isCodecAvailable() {
        return true;
    }

    public void setVideoSize(Dimension dimension) {
        this.setInputFormat((Format)new VideoFormat("DIVX", dimension, -1, new byte[0].getClass(), 0.0f));
    }

    public void setEncoding(String string) {
    }

    public void setIsRtp(boolean bl) {
    }

    public void setIsTruncated(boolean bl) {
    }
}

