/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xqxp.functions.builtIns;

import java.math.BigDecimal;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLItem;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xqxp.datamodel.OXMLSequenceType;
import oracle.xml.xqxp.functions.OXMLFunction;
import oracle.xml.xqxp.functions.OXMLFunctionContext;
import oracle.xml.xqxp.functions.builtIns.FNUtil;

class Ceiling
extends OXMLFunction {
    Ceiling() {
    }

    public String getFunctionName() {
        return "ceiling";
    }

    public int getNumberArgs() {
        return 1;
    }

    public OXMLSequenceType getReturnType() {
        return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
    }

    public OXMLSequenceType getArgType(int n) {
        if (n == 0) {
            return OXMLSequenceType.NUMERIC_ZERO_OR_ONE;
        }
        return null;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence oXMLSequence) throws XQException {
        OXMLSequence oXMLSequence2 = oXMLFunctionContext.createSequence();
        OXMLItem oXMLItem = FNUtil.getEmptyOrSingleItem(oXMLSequence);
        if (oXMLItem != null) {
            OXMLItem oXMLItem2 = oXMLFunctionContext.createItem();
            int n = oXMLItem.getPrimitiveType();
            OXMLSequenceType oXMLSequenceType = OXMLSequenceType.getConstantType(1, n);
            if (n == 3 || n == 4) {
                oXMLItem2.setDouble(oXMLSequenceType, Math.ceil(oXMLItem.getDouble()));
                oXMLSequence2.appendItem(oXMLItem2);
            } else if (n == 5 || n == 22) {
                if (oXMLItem.withinRange()) {
                    oXMLItem2.setInt(oXMLSequenceType, oXMLItem.getInt());
                    oXMLSequence2.appendItem(oXMLItem2);
                } else {
                    BigDecimal bigDecimal = oXMLItem.getDecimal().setScale(0, 2);
                    oXMLItem2.setDecimal(oXMLSequenceType, bigDecimal);
                    oXMLSequence2.appendItem(oXMLItem2);
                }
            }
        }
        return oXMLSequence2;
    }

    public OXMLSequence invoke(OXMLFunctionContext oXMLFunctionContext, OXMLSequence[] oXMLSequenceArray) throws XQException {
        if (oXMLSequenceArray.length != 1) {
            throw new XQException("FORT0001");
        }
        return this.invoke(oXMLFunctionContext, oXMLSequenceArray[0]);
    }
}

