/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xpath;

import oracle.xml.util.FastVector;
import oracle.xml.xpath.PathExpr;
import oracle.xml.xpath.XPathException;
import oracle.xml.xpath.XPathSequence;
import oracle.xml.xpath.XSLExprBase;
import oracle.xml.xpath.XSLParseString;
import oracle.xml.xqxp.XQException;
import oracle.xml.xqxp.datamodel.OXMLSequence;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLTContext;

class IntersectExceptExpr
extends XSLExprBase {
    private FastVector opList;
    private FastVector exprList = new FastVector();

    IntersectExceptExpr() throws XSLException {
        super.setExprType(0x2200000);
        this.opList = new FastVector();
    }

    static XSLExprBase parse(XSLParseString xSLParseString) throws XSLException, XQException {
        int n = xSLParseString.peekToken();
        XSLExprBase xSLExprBase = PathExpr.parse(xSLParseString);
        if (xSLParseString.peekToken() == 103) {
            IntersectExceptExpr intersectExceptExpr = new IntersectExceptExpr();
            intersectExceptExpr.setCompatibilityFlags(xSLParseString.getXSLTVersion(), xSLParseString.isBackwardCompatibilityMode(), xSLParseString.isForwardCompatibilityMode());
            intersectExceptExpr.exprList.addElement(xSLExprBase);
            intersectExceptExpr.opList.addElement(new Integer(xSLParseString.getOperator()));
            if (!xSLExprBase.isExprType(0x200000)) {
                throw new XPathException(1038);
            }
            while (xSLParseString.peekToken(103)) {
                n = xSLParseString.peekToken();
                xSLExprBase = PathExpr.parse(xSLParseString);
                if (!xSLExprBase.isExprType(0x200000)) {
                    throw new XPathException(1038);
                }
                intersectExceptExpr.exprList.addElement(xSLExprBase);
                intersectExceptExpr.opList.addElement(new Integer(xSLParseString.getOperator()));
                if (!(intersectExceptExpr.priority < xSLExprBase.priority)) continue;
                intersectExceptExpr.priority = xSLExprBase.priority;
            }
            xSLExprBase = intersectExceptExpr;
            if (xSLParseString.isCachingExpr() && !intersectExceptExpr.canCacheExpr()) {
                intersectExceptExpr.cacheSubExpr();
            }
        }
        return xSLExprBase;
    }

    void cacheSubExpr() throws XQException {
        int n = this.exprList.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i);
            if (!xSLExprBase.canCacheExpr()) continue;
            this.exprList.setElementAt(xSLExprBase.createCachedExpr(), i);
        }
    }

    boolean canCacheExpr() {
        int n = this.exprList.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i);
            if (xSLExprBase.canCacheExpr()) continue;
            return false;
        }
        return true;
    }

    String getNormalizedExpr() throws XQException {
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(0);
        StringBuffer stringBuffer = new StringBuffer(xSLExprBase.getNormalizedExpr());
        int n = this.exprList.size();
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprList.elementAt(i);
            stringBuffer.append((Integer)this.opList.elementAt(i - 1));
            stringBuffer.append(xSLExprBase.getNormalizedExpr());
        }
        return stringBuffer.toString();
    }

    boolean checkPosLastFN() {
        int n = this.exprList.size();
        for (int i = 0; i < n; ++i) {
            XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(i);
            if (!xSLExprBase.checkPosLastFN()) continue;
            return true;
        }
        return false;
    }

    public void evaluate(XSLTContext xSLTContext) throws XSLException, XQException {
        xSLTContext.setCompatibilityFlags(this.getXSLTVersion(), this.isBackwardCompatibilityMode(), this.isForwardCompatibilityMode());
        int n = this.exprList.size();
        XSLExprBase xSLExprBase = (XSLExprBase)this.exprList.elementAt(0);
        xSLExprBase.evaluate(xSLTContext);
        OXMLSequence oXMLSequence = xSLTContext.peekExprValue();
        for (int i = 1; i < n; ++i) {
            xSLExprBase = (XSLExprBase)this.exprList.elementAt(i);
            xSLExprBase.evaluate(xSLTContext);
            if ((Integer)this.opList.elementAt(i - 1) == 206) {
                XPathSequence.intersectSequence(oXMLSequence, xSLTContext.popExprValue());
                continue;
            }
            XPathSequence.exceptSequence(oXMLSequence, xSLTContext.popExprValue());
        }
    }
}

