/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import java.io.UnsupportedEncodingException;
import org.apache.poi.hwpf.model.PieceDescriptor;
import org.apache.poi.hwpf.model.PropertyNode;

public class TextPiece
extends PropertyNode
implements Comparable {
    private boolean _usesUnicode;
    private int _length;
    private PieceDescriptor _pd;

    public TextPiece(int n, int n2, byte[] byArray, PieceDescriptor pieceDescriptor) throws UnsupportedEncodingException {
        super(n, n2, new StringBuffer(new String(byArray, pieceDescriptor.isUnicode() ? "UTF-16LE" : "Cp1252")));
        this._usesUnicode = pieceDescriptor.isUnicode();
        this._length = n2 - n;
        this._pd = pieceDescriptor;
    }

    public boolean usesUnicode() {
        return this._usesUnicode;
    }

    public PieceDescriptor getPieceDescriptor() {
        return this._pd;
    }

    public StringBuffer getStringBuffer() {
        return (StringBuffer)this._buf;
    }

    public byte[] getRawBytes() {
        try {
            byte[] byArray = ((StringBuffer)this._buf).toString().getBytes(this._usesUnicode ? "UTF-16LE" : "Cp1252");
            return byArray;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byte[] byArray = ((StringBuffer)this._buf).toString().getBytes();
            return byArray;
        }
    }

    public String substring(int n, int n2) {
        int n3 = this._usesUnicode ? 2 : 1;
        return ((StringBuffer)this._buf).substring(n / n3, n2 / n3);
    }

    public boolean equals(Object object) {
        if (this.limitsAreEqual(object)) {
            TextPiece textPiece = (TextPiece)object;
            return this.getStringBuffer().toString().equals(textPiece.getStringBuffer().toString()) && textPiece._usesUnicode == this._usesUnicode && this._pd.equals(textPiece._pd);
        }
        return false;
    }
}

