/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.awt.Graphics;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.pdfbox.afmtypes.FontMetric;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.common.COSObjectable;
import org.pdfbox.pdmodel.common.PDStream;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.font.PDFontDescriptor;
import org.pdfbox.pdmodel.font.PDFontDescriptorAFM;
import org.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public abstract class PDSimpleFont
extends PDFont {
    private static Logger log = Logger.getLogger((Class)(class$org$pdfbox$pdmodel$font$PDSimpleFont == null ? (class$org$pdfbox$pdmodel$font$PDSimpleFont = PDSimpleFont.class$("org.pdfbox.pdmodel.font.PDSimpleFont")) : class$org$pdfbox$pdmodel$font$PDSimpleFont));
    static /* synthetic */ Class class$org$pdfbox$pdmodel$font$PDSimpleFont;

    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public void drawString(String string, Graphics g, float fontSize, float xScale, float yScale, float x, float y) throws IOException {
        log.warn((Object)("Not yet implemented:" + this.getClass().getName()));
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float fontWidth = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        COSInteger firstChar = (COSInteger)this.font.getDictionaryObject(COSName.FIRSTCHAR);
        COSInteger lastChar = (COSInteger)this.font.getDictionaryObject(COSName.LASTCHAR);
        if (firstChar != null && lastChar != null) {
            long first = firstChar.intValue();
            long last = lastChar.intValue();
            if ((long)code >= first && (long)code <= last && this.font.getDictionaryObject(COSName.WIDTHS) != null) {
                COSArray widthArray = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
                COSNumber fontWidthObject = (COSNumber)widthArray.get((int)((long)code - first));
                fontWidth = fontWidthObject.floatValue();
            } else {
                fontWidth = this.getFontWidthFromAFMFile(code);
            }
        } else {
            fontWidth = this.getFontWidthFromAFMFile(code);
        }
        return fontWidth;
    }

    public float getAverageFontWidth() throws IOException {
        float average = 0.0f;
        float totalWidth = 0.0f;
        float characterCount = 0.0f;
        COSArray widths = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
        if (widths != null) {
            for (int i = 0; i < widths.size(); ++i) {
                COSNumber fontWidth = (COSNumber)widths.getObject(i);
                if (!(fontWidth.floatValue() > 0.0f)) continue;
                totalWidth += fontWidth.floatValue();
                characterCount += 1.0f;
            }
        }
        average = totalWidth > 0.0f ? totalWidth / characterCount : this.getAverageFontWidthFromAFMFile();
        return average;
    }

    public PDFontDescriptor getFontDescriptor() throws IOException {
        PDFontDescriptor retval = null;
        COSDictionary fd = (COSDictionary)this.font.getDictionaryObject(COSName.getPDFName("FontDescriptor"));
        if (fd == null) {
            FontMetric afm = this.getAFM();
            if (afm == null) {
                throw new IOException("Error: Can't create font descriptor file");
            }
            retval = new PDFontDescriptorAFM(afm);
        } else {
            retval = new PDFontDescriptorDictionary(fd);
        }
        return retval;
    }

    public void setFontDescriptor(PDFontDescriptorDictionary fontDescriptor) {
        COSDictionary dic = null;
        if (fontDescriptor != null) {
            dic = fontDescriptor.getCOSDictionary();
        }
        this.font.setItem(COSName.getPDFName("FontDescriptor"), (COSBase)dic);
    }

    public PDStream getToUnicode() throws IOException {
        return PDStream.createFromCOS(this.font.getDictionaryObject("ToUnicode"));
    }

    public void setToUnicode(PDStream unicode) {
        this.font.setItem("ToUnicode", (COSObjectable)unicode);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

