/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.filters;

import java.io.IOException;
import java.io.InputStream;

public abstract class ChunkingInputStream
extends InputStream {
    protected InputStream in = null;
    protected byte[] buffer = null;
    private int bufferPosition = 0;
    private int bufferAvailable = 0;

    protected void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    protected void setBufferSize(int n) {
        this.buffer = new byte[n];
    }

    protected int fillBufferFromInputStream() throws IOException {
        return this.fillBufferFromInputStream(0, this.buffer.length);
    }

    protected int fillBufferFromInputStream(int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            n4 = this.in.read(this.buffer, n + n3, n2 - n3);
            if (n4 < 0 && n3 == 0) {
                return n4;
            }
            if (n4 <= 0) break;
        }
        return n3;
    }

    protected abstract int fillInternalBuffer() throws IOException;

    private int ensureDataAvailable() throws IOException {
        if (this.bufferAvailable > 0) {
            return this.bufferAvailable;
        }
        this.bufferPosition = 0;
        this.bufferAvailable = 0;
        int n = this.fillInternalBuffer();
        if (n > 0) {
            this.bufferAvailable = n;
        }
        return this.bufferAvailable;
    }

    public boolean markSupported() {
        return false;
    }

    public void mark(int n) {
    }

    public void reset() throws IOException {
    }

    public int read() throws IOException {
        int n = this.ensureDataAvailable();
        if (n <= 0) {
            return -1;
        }
        byte by = this.buffer[this.bufferPosition];
        ++this.bufferPosition;
        --this.bufferAvailable;
        return by & 0xFF;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4;
        for (n3 = 0; n3 < n2; n3 += n4) {
            int n5 = this.ensureDataAvailable();
            if (n5 <= 0) {
                if (n3 > 0) {
                    return n3;
                }
                return -1;
            }
            n4 = Math.min(n2 - n3, n5);
            int n6 = this.bufferPosition;
            int n7 = n + n3;
            for (int i = 0; i < n4; ++i) {
                byArray[n7++] = this.buffer[n6++];
            }
            this.bufferPosition += n4;
            this.bufferAvailable -= n4;
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        long l3;
        for (l2 = 0L; l2 < l; l2 += l3) {
            int n = this.ensureDataAvailable();
            if (n <= 0) {
                if (l2 > 0L) {
                    return l2;
                }
                return -1L;
            }
            l3 = Math.min(l - l2, (long)n);
            this.bufferPosition = (int)((long)this.bufferPosition + l3);
            this.bufferAvailable = (int)((long)this.bufferAvailable - l3);
        }
        return l2;
    }

    public int available() throws IOException {
        return this.bufferAvailable;
    }

    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
            this.in = null;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append(": ");
        if (this.in == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append(this.in.toString());
        }
        return stringBuffer.toString();
    }
}

