/*
 * Decompiled with CFR 0.152.
 */
package com.jezhumble.javasysmon;

import java.text.DecimalFormat;

public class ProcessInfo {
    private int pid;
    private int parentPid;
    private String command;
    private String name;
    private String owner;
    private long userMillis;
    private long systemMillis;
    private long residentBytes;
    private long totalBytes;
    private static final String PADDING = "                                                                                   ";

    public ProcessInfo(int pid, int parentPid, String command, String name, String owner, long userMillis, long systemMillis, long residentBytes, long totalBytes) {
        this.pid = pid;
        this.parentPid = parentPid;
        this.command = command;
        this.name = name;
        this.owner = owner;
        this.userMillis = userMillis;
        this.systemMillis = systemMillis;
        this.residentBytes = residentBytes;
        this.totalBytes = totalBytes;
    }

    public int getPid() {
        return this.pid;
    }

    public int getParentPid() {
        return this.parentPid;
    }

    public String getCommand() {
        return this.command;
    }

    public String getName() {
        return this.name;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getUserMillis() {
        return this.userMillis;
    }

    public long getSystemMillis() {
        return this.systemMillis;
    }

    public long getResidentBytes() {
        return this.residentBytes;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public static String header() {
        return "  pid name        ppid user        total    res     time command\n================================================================================";
    }

    public String toString() {
        return ProcessInfo.stringFormat(this.pid, 5) + " " + ProcessInfo.stringFormat(this.name, 10) + " " + ProcessInfo.stringFormat(this.parentPid, 5) + " " + ProcessInfo.stringFormat(this.owner, 10) + " " + ProcessInfo.stringFormat(this.totalBytes / 0x100000L, 4) + "Mb " + ProcessInfo.stringFormat(this.residentBytes / 0x100000L, 4) + "Mb " + ProcessInfo.formatMillisecs(this.userMillis + this.systemMillis) + " " + ProcessInfo.stringFormat(this.command, 23);
    }

    private static String stringFormat(int intToFormat, int fieldSize) {
        return ProcessInfo.stringFormat(Integer.toString(intToFormat), fieldSize, true);
    }

    private static String stringFormat(long longToFormat, int fieldSize) {
        return ProcessInfo.stringFormat(Long.toString(longToFormat), fieldSize, true);
    }

    private static String stringFormat(String stringToFormat, int fieldSize) {
        return ProcessInfo.stringFormat(stringToFormat, fieldSize, false);
    }

    private static String stringFormat(String stringToFormat, int fieldSize, boolean rightJustify) {
        if (stringToFormat.length() >= fieldSize) {
            return stringToFormat.substring(0, fieldSize);
        }
        return rightJustify ? PADDING.substring(0, fieldSize - stringToFormat.length()) + stringToFormat : stringToFormat + PADDING.substring(0, fieldSize - stringToFormat.length());
    }

    private static String formatMillisecs(long millisecs) {
        long secs = millisecs / 1000L;
        long hours = secs / 3600L;
        long mins = (secs - hours * 3600L) / 60L;
        secs = secs - hours * 3600L - mins * 60L;
        DecimalFormat format = new DecimalFormat("00");
        return format.format(hours) + ":" + format.format(mins) + ":" + format.format(secs);
    }
}

