/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T2CCallableStatement;
import oracle.jdbc.driver.T2CConnection;
import oracle.jdbc.driver.T2CInputStream;
import oracle.jdbc.driver.T2CPreparedStatement;
import oracle.jdbc.driver.T2CStatement;
import oracle.jdbc.oci.OracleOCIConnection;

class T2CDriverExtension
extends OracleDriverExtension {
    static final int T2C_DEFAULT_BATCHSIZE = 1;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "051228";

    T2CDriverExtension() {
    }

    Connection getConnection(String string, String string2, String string3, String string4, Properties properties) throws SQLException {
        T2CConnection t2CConnection = null;
        if (properties.getProperty("is_connection_pooling") == "true") {
            properties.put("database", string4 == null ? "" : string4);
            t2CConnection = new OracleOCIConnection(string, string2, string3, string4, properties, (Object)this);
        } else {
            t2CConnection = new T2CConnection(string, string2, string3, string4, properties, this);
        }
        return t2CConnection;
    }

    OracleStatement allocateStatement(PhysicalConnection physicalConnection, int n, int n2) throws SQLException {
        T2CStatement t2CStatement = null;
        t2CStatement = new T2CStatement((T2CConnection)physicalConnection, 1, physicalConnection.default_row_prefetch, n, n2);
        return t2CStatement;
    }

    OraclePreparedStatement allocatePreparedStatement(PhysicalConnection physicalConnection, String string, int n, int n2) throws SQLException {
        T2CPreparedStatement t2CPreparedStatement = null;
        t2CPreparedStatement = new T2CPreparedStatement((T2CConnection)physicalConnection, string, physicalConnection.default_batch, physicalConnection.default_row_prefetch, n, n2);
        return t2CPreparedStatement;
    }

    OracleCallableStatement allocateCallableStatement(PhysicalConnection physicalConnection, String string, int n, int n2) throws SQLException {
        T2CCallableStatement t2CCallableStatement = null;
        Object var6_6 = null;
        t2CCallableStatement = new T2CCallableStatement((T2CConnection)physicalConnection, string, physicalConnection.default_batch, physicalConnection.default_row_prefetch, n, n2);
        return t2CCallableStatement;
    }

    OracleInputStream createInputStream(OracleStatement oracleStatement, int n, Accessor accessor) throws SQLException {
        T2CInputStream t2CInputStream = null;
        t2CInputStream = new T2CInputStream(oracleStatement, n, accessor);
        return t2CInputStream;
    }
}

