/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.CSSStyleDeclarationImpl;
import com.steadystate.css.dom.CSSStyleSheetImpl;
import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.parser.CSSOMParser;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.SelectorList;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSStyleRule;
import org.w3c.dom.css.CSSStyleSheet;

public class CSSStyleRuleImpl
implements CSSStyleRule,
Serializable {
    private CSSStyleSheetImpl _parentStyleSheet = null;
    private CSSRule _parentRule = null;
    private SelectorList _selectors = null;
    private CSSStyleDeclaration _style = null;

    public CSSStyleRuleImpl(CSSStyleSheetImpl parentStyleSheet, CSSRule parentRule, SelectorList selectors) {
        this._parentStyleSheet = parentStyleSheet;
        this._parentRule = parentRule;
        this._selectors = selectors;
    }

    public short getType() {
        return 1;
    }

    public String getCssText() {
        return String.valueOf(this.getSelectorText()) + " " + this.getStyle().toString();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            CSSRule r = parser.parseRule(is);
            if (r.getType() != 1) {
                throw new DOMExceptionImpl(13, 4);
            }
            this._selectors = ((CSSStyleRuleImpl)r)._selectors;
            this._style = ((CSSStyleRuleImpl)r)._style;
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleSheet getParentStyleSheet() {
        return this._parentStyleSheet;
    }

    public CSSRule getParentRule() {
        return this._parentRule;
    }

    public String getSelectorText() {
        return this._selectors.toString();
    }

    public void setSelectorText(String selectorText) throws DOMException {
        if (this._parentStyleSheet != null && this._parentStyleSheet.isReadOnly()) {
            throw new DOMExceptionImpl(7, 2);
        }
        try {
            InputSource is = new InputSource(new StringReader(selectorText));
            CSSOMParser parser = new CSSOMParser();
            this._selectors = parser.parseSelectors(is);
        }
        catch (CSSException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
        catch (IOException e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    public CSSStyleDeclaration getStyle() {
        return this._style;
    }

    public void setStyle(CSSStyleDeclarationImpl style) {
        this._style = style;
    }

    public String toString() {
        return this.getCssText();
    }
}

