/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpp;

import net.sf.mpxj.Day;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.RecurrenceType;
import net.sf.mpxj.RecurringTask;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPUtility;

final class RecurringTaskReader {
    private ProjectFile m_file;

    public RecurringTaskReader(ProjectFile projectFile) {
        this.m_file = projectFile;
    }

    public void processRecurringTask(Task task, byte[] byArray) {
        RecurringTask recurringTask = task.addRecurringTask();
        recurringTask.setStartDate(MPPUtility.getDate(byArray, 6));
        recurringTask.setFinishDate(MPPUtility.getDate(byArray, 10));
        recurringTask.setDuration(MPPUtility.getAdjustedDuration(this.m_file, MPPUtility.getInt(byArray, 12), MPPUtility.getDurationTimeUnits(MPPUtility.getShort(byArray, 16))));
        recurringTask.setOccurrences(MPPUtility.getShort(byArray, 18));
        recurringTask.setRecurrenceType(RecurrenceType.getInstance(MPPUtility.getShort(byArray, 20)));
        recurringTask.setUseEndDate(MPPUtility.getShort(byArray, 24) == 1);
        recurringTask.setDailyWorkday(MPPUtility.getShort(byArray, 26) == 1);
        int n = 0;
        n += MPPUtility.getShort(byArray, 28) == 1 ? 64 : 0;
        n += MPPUtility.getShort(byArray, 30) == 1 ? 32 : 0;
        n += MPPUtility.getShort(byArray, 32) == 1 ? 16 : 0;
        n += MPPUtility.getShort(byArray, 34) == 1 ? 8 : 0;
        n += MPPUtility.getShort(byArray, 36) == 1 ? 4 : 0;
        n += MPPUtility.getShort(byArray, 38) == 1 ? 2 : 0;
        recurringTask.setWeeklyDays(n += MPPUtility.getShort(byArray, 40) == 1 ? 1 : 0);
        recurringTask.setMonthlyRelative(MPPUtility.getShort(byArray, 42) == 1);
        recurringTask.setYearlyAbsolute(MPPUtility.getShort(byArray, 44) == 1);
        recurringTask.setDailyFrequency(MPPUtility.getShort(byArray, 46));
        recurringTask.setWeeklyFrequency(MPPUtility.getShort(byArray, 48));
        recurringTask.setMonthlyRelativeOrdinal(MPPUtility.getShort(byArray, 50));
        recurringTask.setMonthlyRelativeDay(Day.getInstance(MPPUtility.getShort(byArray, 52) + 1));
        recurringTask.setMonthlyAbsoluteFrequency(MPPUtility.getShort(byArray, 54));
        recurringTask.setMonthlyAbsoluteDay(MPPUtility.getShort(byArray, 56));
        recurringTask.setMonthlyRelativeFrequency(MPPUtility.getShort(byArray, 58));
        recurringTask.setYearlyRelativeOrdinal(MPPUtility.getShort(byArray, 60));
        recurringTask.setYearlyRelativeDay(Day.getInstance(MPPUtility.getShort(byArray, 62) + 1));
        recurringTask.setYearlyRelativeMonth(MPPUtility.getShort(byArray, 64));
        recurringTask.setYearlyAbsoluteDate(MPPUtility.getDate(byArray, 70));
    }
}

