/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.mpd;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.AccrueType;
import net.sf.mpxj.AssignmentField;
import net.sf.mpxj.ConstraintType;
import net.sf.mpxj.DataType;
import net.sf.mpxj.DateRange;
import net.sf.mpxj.Day;
import net.sf.mpxj.Duration;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.MPPAssignmentField;
import net.sf.mpxj.MPPResourceField;
import net.sf.mpxj.MPPTaskField;
import net.sf.mpxj.Priority;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectCalendarException;
import net.sf.mpxj.ProjectCalendarHours;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.Rate;
import net.sf.mpxj.Relation;
import net.sf.mpxj.RelationType;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.ResourceField;
import net.sf.mpxj.ResourceType;
import net.sf.mpxj.ScheduleFrom;
import net.sf.mpxj.Task;
import net.sf.mpxj.TaskField;
import net.sf.mpxj.TaskType;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.WorkContour;
import net.sf.mpxj.WorkGroup;
import net.sf.mpxj.mpd.MPDUtility;
import net.sf.mpxj.mpd.Row;
import net.sf.mpxj.utility.NumberUtility;
import net.sf.mpxj.utility.Pair;
import net.sf.mpxj.utility.RTFUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MPD9AbstractReader {
    protected Integer m_projectID;
    protected ProjectFile m_project;
    private boolean m_preserveNoteFormatting;
    private boolean m_autoWBS = true;
    private RTFUtility m_rtf = new RTFUtility();
    private Map<Integer, ProjectCalendar> m_calendarMap = new HashMap<Integer, ProjectCalendar>();
    private List<Pair<ProjectCalendar, Integer>> m_baseCalendars = new LinkedList<Pair<ProjectCalendar, Integer>>();
    private Map<Integer, ProjectCalendar> m_resourceMap = new HashMap<Integer, ProjectCalendar>();
    private Map<Integer, ResourceAssignment> m_assignmentMap = new HashMap<Integer, ResourceAssignment>();

    MPD9AbstractReader() {
    }

    protected void reset() {
        this.m_calendarMap.clear();
        this.m_baseCalendars.clear();
        this.m_resourceMap.clear();
        this.m_assignmentMap.clear();
    }

    protected void processProjectListItem(Map<Integer, String> map, Row row) {
        Integer n = row.getInteger("PROJ_ID");
        String string = row.getString("PROJ_NAME");
        map.put(n, string);
    }

    protected void processProjectHeader(Row row) {
        ProjectHeader projectHeader = this.m_project.getProjectHeader();
        projectHeader.setCurrencySymbol(row.getString("PROJ_OPT_CURRENCY_SYMBOL"));
        projectHeader.setSymbolPosition(MPDUtility.getSymbolPosition(row.getInt("PROJ_OPT_CURRENCY_POSITION")));
        projectHeader.setCurrencyDigits(row.getInteger("PROJ_OPT_CURRENCY_DIGITS"));
        projectHeader.setDefaultDurationUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_DUR_ENTRY_FMT")));
        projectHeader.setDefaultWorkUnits(MPDUtility.getDurationTimeUnits(row.getInt("PROJ_OPT_WORK_ENTRY_FMT")));
        projectHeader.setMinutesPerDay(row.getInteger("PROJ_OPT_MINUTES_PER_DAY"));
        projectHeader.setMinutesPerWeek(row.getInteger("PROJ_OPT_MINUTES_PER_WEEK"));
        projectHeader.setDefaultStandardRate(new Rate(row.getDouble("PROJ_OPT_DEF_STD_RATE"), TimeUnit.HOURS));
        projectHeader.setDefaultOvertimeRate(new Rate(row.getDouble("PROJ_OPT_DEF_OVT_RATE"), TimeUnit.HOURS));
        projectHeader.setUpdatingTaskStatusUpdatesResourceStatus(row.getBoolean("PROJ_OPT_TASK_UPDATES_RES"));
        projectHeader.setSplitInProgressTasks(row.getBoolean("PROJ_OPT_SPLIT_IN_PROGRESS"));
        projectHeader.setDefaultStartTime(row.getDate("PROJ_OPT_DEF_START_TIME"));
        projectHeader.setProjectTitle(row.getString("PROJ_PROP_TITLE"));
        projectHeader.setCompany(row.getString("PROJ_PROP_COMPANY"));
        projectHeader.setManager(row.getString("PROJ_PROP_MANAGER"));
        projectHeader.setCalendarName(row.getString("PROJ_INFO_CAL_NAME"));
        projectHeader.setStartDate(row.getDate("PROJ_INFO_START_DATE"));
        projectHeader.setFinishDate(row.getDate("PROJ_INFO_FINISH_DATE"));
        projectHeader.setScheduleFrom(ScheduleFrom.getInstance(1 - row.getInt("PROJ_INFO_SCHED_FROM")));
        projectHeader.setCurrentDate(row.getDate("PROJ_INFO_CURRENT_DATE"));
        projectHeader.setSubject(row.getString("PROJ_PROP_SUBJECT"));
        projectHeader.setAuthor(row.getString("PROJ_PROP_AUTHOR"));
        projectHeader.setKeywords(row.getString("PROJ_PROP_KEYWORDS"));
        projectHeader.setDefaultEndTime(row.getDate("PROJ_OPT_DEF_FINISH_TIME"));
        projectHeader.setProjectExternallyEdited(row.getBoolean("PROJ_EXT_EDITED_FLAG"));
        projectHeader.setCategory(row.getString("PROJ_PROP_CATEGORY"));
        projectHeader.setDaysPerMonth(row.getInteger("PROJ_OPT_DAYS_PER_MONTH"));
        projectHeader.setFiscalYearStart(row.getBoolean("PROJ_OPT_FY_USE_START_YR"));
        projectHeader.setNewTasksEstimated(row.getBoolean("PROJ_OPT_NEW_TASK_EST"));
        projectHeader.setSpreadActualCost(row.getBoolean("PROJ_OPT_SPREAD_ACT_COSTS"));
        projectHeader.setMultipleCriticalPaths(row.getBoolean("PROJ_OPT_MULT_CRITICAL_PATHS"));
        projectHeader.setLastSaved(row.getDate("PROJ_LAST_SAVED"));
        projectHeader.setStatusDate(row.getDate("PROJ_INFO_STATUS_DATE"));
        projectHeader.setHonorConstraints(row.getBoolean("PROJ_OPT_HONOR_CONSTRAINTS"));
        projectHeader.setName(row.getString("PROJ_NAME"));
        projectHeader.setSpreadPercentComplete(row.getBoolean("PROJ_OPT_SPREAD_PCT_COMP"));
        projectHeader.setNewTasksEffortDriven(row.getBoolean("PROJ_OPT_NEW_ARE_EFFORT_DRIVEN"));
        projectHeader.setDefaultTaskType(TaskType.getInstance(row.getInt("PROJ_OPT_DEF_TASK_TYPE")));
        projectHeader.setCreationDate(row.getDate("PROJ_CREATION_DATE"));
        projectHeader.setDefaultFixedCostAccrual(AccrueType.getInstance(row.getInt("PROJ_OPT_DEF_FIX_COST_ACCRUAL")));
        projectHeader.setCriticalSlackLimit(row.getInteger("PROJ_OPT_CRITICAL_SLACK_LIMIT"));
        projectHeader.setFiscalYearStartMonth(row.getInteger("PROJ_OPT_FY_START_MONTH"));
        projectHeader.setWeekStartDay(Day.getInstance(row.getInt("PROJ_OPT_WEEK_START_DAY") + 1));
        projectHeader.setMultipleCriticalPaths(row.getBoolean("PROJ_OPT_MULT_CRITICAL_PATHS"));
    }

    protected void processCalendar(Row row) {
        Integer n = row.getInteger("CAL_UID");
        if (NumberUtility.getInt(n) > 0) {
            boolean bl = row.getBoolean("CAL_IS_BASE_CAL");
            ProjectCalendar projectCalendar = null;
            if (bl) {
                projectCalendar = this.m_project.addBaseCalendar();
                projectCalendar.setName(row.getString("CAL_NAME"));
            } else {
                Integer n2 = row.getInteger("RES_UID");
                if (n2 != null && n2 != 0) {
                    projectCalendar = this.m_project.addResourceCalendar();
                    this.m_baseCalendars.add(new Pair<ProjectCalendar, Integer>(projectCalendar, row.getInteger("CAL_BASE_UID")));
                    this.m_resourceMap.put(n2, projectCalendar);
                }
            }
            if (projectCalendar != null) {
                projectCalendar.setUniqueID(n);
                this.m_calendarMap.put(n, projectCalendar);
                this.m_project.fireCalendarReadEvent(projectCalendar);
            }
        }
    }

    protected void processCalendarData(ProjectCalendar projectCalendar, Row row) {
        int n = row.getInt("CD_DAY_OR_EXCEPTION");
        if (n == 0) {
            this.processCalendarException(projectCalendar, row);
        } else {
            this.processCalendarHours(projectCalendar, row, n);
        }
    }

    private void processCalendarException(ProjectCalendar projectCalendar, Row row) {
        Date date = row.getDate("CD_FROM_DATE");
        Date date2 = row.getDate("CD_TO_DATE");
        boolean bl = row.getInt("CD_WORKING") != 0;
        ProjectCalendarException projectCalendarException = projectCalendar.addCalendarException(date, date2);
        if (bl) {
            projectCalendarException.addRange(new DateRange(row.getDate("CD_FROM_TIME1"), row.getDate("CD_TO_TIME1")));
            projectCalendarException.addRange(new DateRange(row.getDate("CD_FROM_TIME2"), row.getDate("CD_TO_TIME2")));
            projectCalendarException.addRange(new DateRange(row.getDate("CD_FROM_TIME3"), row.getDate("CD_TO_TIME3")));
            projectCalendarException.addRange(new DateRange(row.getDate("CD_FROM_TIME4"), row.getDate("CD_TO_TIME4")));
            projectCalendarException.addRange(new DateRange(row.getDate("CD_FROM_TIME5"), row.getDate("CD_TO_TIME5")));
        }
    }

    private void processCalendarHours(ProjectCalendar projectCalendar, Row row, int n) {
        Day day = Day.getInstance(n);
        boolean bl = row.getInt("CD_WORKING") != 0;
        projectCalendar.setWorkingDay(day, bl);
        if (bl) {
            ProjectCalendarHours projectCalendarHours = projectCalendar.addCalendarHours(day);
            Date date = row.getDate("CD_FROM_TIME1");
            Date date2 = row.getDate("CD_TO_TIME1");
            if (date != null && date2 != null) {
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
            date = row.getDate("CD_FROM_TIME2");
            date2 = row.getDate("CD_TO_TIME2");
            if (date != null && date2 != null) {
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
            date = row.getDate("CD_FROM_TIME3");
            date2 = row.getDate("CD_TO_TIME3");
            if (date != null && date2 != null) {
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
            date = row.getDate("CD_FROM_TIME4");
            date2 = row.getDate("CD_TO_TIME4");
            if (date != null && date2 != null) {
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
            date = row.getDate("CD_FROM_TIME5");
            date2 = row.getDate("CD_TO_TIME5");
            if (date != null && date2 != null) {
                projectCalendarHours.addRange(new DateRange(date, date2));
            }
        }
    }

    protected void updateBaseCalendarNames() {
        for (Pair<ProjectCalendar, Integer> pair : this.m_baseCalendars) {
            ProjectCalendar projectCalendar = pair.getFirst();
            Integer n = pair.getSecond();
            ProjectCalendar projectCalendar2 = this.m_calendarMap.get(n);
            if (projectCalendar2 == null) continue;
            projectCalendar.setParent(projectCalendar2);
        }
    }

    protected void processResource(Row row) {
        Integer n = row.getInteger("RES_UID");
        if (n != null && n >= 0) {
            Resource resource = this.m_project.addResource();
            resource.setAccrueAt(AccrueType.getInstance(row.getInt("RES_ACCRUE_AT")));
            resource.setActualCost(this.getDefaultOnNull(row.getCurrency("RES_ACT_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setActualOvertimeCost(row.getCurrency("RES_ACT_OVT_COST"));
            resource.setActualOvertimeWork(row.getDuration("RES_ACT_OVT_WORK"));
            resource.setActualWork(row.getDuration("RES_ACT_WORK"));
            resource.setACWP(row.getCurrency("RES_ACWP"));
            resource.setAvailableFrom(row.getDate("RES_AVAIL_FROM"));
            resource.setAvailableTo(row.getDate("RES_AVAIL_TO"));
            resource.setBaselineCost(this.getDefaultOnNull(row.getCurrency("RES_BASE_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setBaselineWork(row.getDuration("RES_BASE_WORK"));
            resource.setBCWP(row.getCurrency("RES_BCWP"));
            resource.setBCWS(row.getCurrency("RES_BCWS"));
            resource.setCanLevel(row.getBoolean("RES_CAN_LEVEL"));
            resource.setCost(this.getDefaultOnNull(row.getCurrency("RES_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setCostPerUse(row.getCurrency("RES_COST_PER_USE"));
            resource.setID(row.getInteger("RES_ID"));
            resource.setInitials(row.getString("RES_INITIALS"));
            resource.setMaterialLabel(row.getString("RES_MATERIAL_LABEL"));
            resource.setMaxUnits(NumberUtility.getDouble(row.getDouble("RES_MAX_UNITS")) * 100.0);
            resource.setName(row.getString("RES_NAME"));
            resource.setObjects(this.getNullOnValue(row.getInteger("RES_NUM_OBJECTS"), 0));
            resource.setOverAllocated(row.getBoolean("RES_IS_OVERALLOCATED"));
            resource.setOvertimeCost(row.getCurrency("RES_OVT_COST"));
            resource.setOvertimeRate(new Rate(row.getDouble("RES_OVT_RATE"), TimeUnit.HOURS));
            resource.setOvertimeRateUnits(TimeUnit.getInstance(row.getInt("RES_OVT_RATE_FMT") - 1));
            resource.setOvertimeWork(row.getDuration("RES_OVT_WORK"));
            resource.setPeakUnits(NumberUtility.getDouble(row.getDouble("RES_PEAK")) * 100.0);
            resource.setPhonetics(row.getString("RES_PHONETICS"));
            resource.setRegularWork(row.getDuration("RES_REG_WORK"));
            resource.setRemainingCost(this.getDefaultOnNull(row.getCurrency("RES_REM_COST"), NumberUtility.DOUBLE_ZERO));
            resource.setRemainingOvertimeCost(row.getCurrency("RES_REM_OVT_COST"));
            resource.setRemainingOvertimeWork(row.getDuration("RES_REM_OVT_WORK"));
            resource.setRemainingWork(row.getDuration("RES_REM_WORK"));
            resource.setStandardRate(new Rate(row.getDouble("RES_STD_RATE"), TimeUnit.HOURS));
            resource.setStandardRateUnits(TimeUnit.getInstance(row.getInt("RES_STD_RATE_FMT") - 1));
            resource.setType(row.getBoolean("RES_TYPE") ? ResourceType.WORK : ResourceType.MATERIAL);
            resource.setUniqueID(n);
            resource.setWork(row.getDuration("RES_WORK"));
            resource.setWorkGroup(WorkGroup.getInstance(row.getInt("RES_WORKGROUP_MESSAGING")));
            String string = row.getString("RES_RTF_NOTES");
            if (string != null) {
                if (!this.m_preserveNoteFormatting) {
                    string = this.m_rtf.strip(string);
                }
                resource.setNotes(string);
            }
            resource.setResourceCalendar(this.m_project.getBaseCalendarByUniqueID(row.getInteger("RES_CAL_UID")));
            if (resource.getCost() != null && resource.getBaselineCost() != null) {
                resource.setCostVariance(NumberUtility.getDouble(resource.getCost().doubleValue() - resource.getBaselineCost().doubleValue()));
            }
            if (resource.getWork() != null && resource.getBaselineWork() != null) {
                resource.setWorkVariance(Duration.getInstance(resource.getWork().getDuration() - resource.getBaselineWork().getDuration(), TimeUnit.HOURS));
            }
            resource.setOverAllocated(NumberUtility.getDouble(resource.getPeakUnits()) > NumberUtility.getDouble(resource.getMaxUnits()));
            this.m_project.fireResourceReadEvent(resource);
        }
    }

    protected void processResourceBaseline(Row row) {
        Integer n = row.getInteger("RES_UID");
        Resource resource = this.m_project.getResourceByUniqueID(n);
        if (resource != null) {
            int n2 = row.getInt("RB_BASE_NUM");
            resource.setBaselineWork(n2, row.getDuration("RB_BASE_WORK"));
            resource.setBaselineCost(n2, row.getCurrency("RB_BASE_COST"));
        }
    }

    protected void processTextField(Row row) {
        this.processField(row, "TEXT_FIELD_ID", "TEXT_REF_UID", (Object)row.getString("TEXT_VALUE"));
    }

    protected void processNumberField(Row row) {
        this.processField(row, "NUM_FIELD_ID", "NUM_REF_UID", (Object)row.getDouble("NUM_VALUE"));
    }

    protected void processFlagField(Row row) {
        this.processField(row, "FLAG_FIELD_ID", "FLAG_REF_UID", (Object)row.getBoolean("FLAG_VALUE"));
    }

    protected void processDurationField(Row row) {
        this.processField(row, "DUR_FIELD_ID", "DUR_REF_UID", (Object)MPDUtility.getAdjustedDuration(this.m_project, row.getInt("DUR_VALUE"), MPDUtility.getDurationTimeUnits(row.getInt("DUR_FMT"))));
    }

    protected void processDateField(Row row) {
        this.processField(row, "DATE_FIELD_ID", "DATE_REF_UID", (Object)row.getDate("DATE_VALUE"));
    }

    protected void processOutlineCodeField(Integer n, Row row) {
        this.processField(row, "OC_FIELD_ID", n, (Object)row.getString("OC_NAME"));
    }

    protected void processField(Row row, String string, String string2, Object object) {
        this.processField(row, string, row.getInteger(string2), object);
    }

    protected void processField(Row row, String string, Integer n, Object object) {
        int n2 = row.getInt(string);
        int n3 = n2 & 0xFFFF0000;
        int n4 = n2 & 0xFFFF;
        switch (n3) {
            case 0xB400000: {
                Task task;
                TaskField taskField = MPPTaskField.getInstance(n4);
                if (taskField == null || taskField == TaskField.NOTES || (task = this.m_project.getTaskByUniqueID(n)) == null) break;
                if (taskField.getDataType() == DataType.CURRENCY) {
                    object = (Double)object / 100.0;
                }
                task.set((FieldType)taskField, object);
                break;
            }
            case 0xC400000: {
                Resource resource;
                ResourceField resourceField = MPPResourceField.getInstance(n4);
                if (resourceField == null || resourceField == ResourceField.NOTES || (resource = this.m_project.getResourceByUniqueID(n)) == null) break;
                if (resourceField.getDataType() == DataType.CURRENCY) {
                    object = (Double)object / 100.0;
                }
                resource.set((FieldType)resourceField, object);
                break;
            }
            case 0xF400000: {
                ResourceAssignment resourceAssignment;
                AssignmentField assignmentField = MPPAssignmentField.getInstance(n4);
                if (assignmentField == null || assignmentField == AssignmentField.NOTES || (resourceAssignment = this.m_assignmentMap.get(n)) == null) break;
                if (assignmentField.getDataType() == DataType.CURRENCY) {
                    object = (Double)object / 100.0;
                }
                resourceAssignment.set((FieldType)assignmentField, object);
                break;
            }
        }
    }

    protected void processTask(Row row) {
        Integer n = row.getInteger("TASK_UID");
        if (n != null && n >= 0) {
            Task task = this.m_project.addTask();
            TimeUnit timeUnit = MPDUtility.getDurationTimeUnits(row.getInt("TASK_DUR_FMT"));
            task.setActualCost(row.getCurrency("TASK_ACT_COST"));
            task.setActualDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_ACT_DUR"), timeUnit));
            task.setActualFinish(row.getDate("TASK_ACT_FINISH"));
            task.setActualOvertimeCost(row.getCurrency("TASK_ACT_OVT_COST"));
            task.setActualOvertimeWork(row.getDuration("TASK_ACT_OVT_WORK"));
            task.setActualStart(row.getDate("TASK_ACT_START"));
            task.setActualWork(row.getDuration("TASK_ACT_WORK"));
            task.setACWP(row.getCurrency("TASK_ACWP"));
            task.setBaselineCost(row.getCurrency("TASK_BASE_COST"));
            task.setBaselineDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_BASE_DUR"), timeUnit));
            task.setBaselineFinish(row.getDate("TASK_BASE_FINISH"));
            task.setBaselineStart(row.getDate("TASK_BASE_START"));
            task.setBaselineWork(row.getDuration("TASK_BASE_WORK"));
            task.setCalendar(this.m_project.getBaseCalendarByUniqueID(row.getInteger("TASK_CAL_UID")));
            task.setConstraintDate(row.getDate("TASK_CONSTRAINT_DATE"));
            task.setConstraintType(ConstraintType.getInstance(row.getInt("TASK_CONSTRAINT_TYPE")));
            task.setCost(row.getCurrency("TASK_COST"));
            task.setCreateDate(row.getDate("TASK_CREATION_DATE"));
            task.setDeadline(row.getDate("TASK_DEADLINE"));
            task.setDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR"), timeUnit));
            task.setDurationVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_DUR_VAR"), timeUnit));
            task.setEarlyFinish(row.getDate("TASK_EARLY_FINISH"));
            task.setEarlyStart(row.getDate("TASK_EARLY_START"));
            task.setEffortDriven(row.getBoolean("TASK_IS_EFFORT_DRIVEN"));
            task.setEstimated(row.getBoolean("TASK_DUR_IS_EST"));
            task.setExpanded(!row.getBoolean("TASK_IS_COLLAPSED"));
            task.setExternalTask(row.getBoolean("TASK_IS_EXTERNAL"));
            task.setFinish(row.getDate("TASK_FINISH_DATE"));
            task.setFixedCost(row.getCurrency("TASK_FIXED_COST"));
            task.setFixedCostAccrual(AccrueType.getInstance(row.getInt("TASK_FIXED_COST_ACCRUAL")));
            task.setFreeSlack(row.getDuration("TASK_FREE_SLACK").convertUnits(timeUnit, this.m_project.getProjectHeader()));
            task.setHideBar(row.getBoolean("TASK_BAR_IS_HIDDEN"));
            task.setID(row.getInteger("TASK_ID"));
            task.setIgnoreResourceCalendar(row.getBoolean("TASK_IGNORES_RES_CAL"));
            task.setLateFinish(row.getDate("TASK_LATE_FINISH"));
            task.setLateStart(row.getDate("TASK_LATE_START"));
            task.setLevelAssignments(row.getBoolean("TASK_LEVELING_ADJUSTS_ASSN"));
            task.setLevelingCanSplit(row.getBoolean("TASK_LEVELING_CAN_SPLIT"));
            task.setLevelingDelayFormat(MPDUtility.getDurationTimeUnits(row.getInt("TASK_LEVELING_DELAY_FMT")));
            task.setLevelingDelay(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_LEVELING_DELAY"), task.getLevelingDelayFormat()));
            task.setMarked(row.getBoolean("TASK_IS_MARKED"));
            task.setMilestone(row.getBoolean("TASK_IS_MILESTONE"));
            task.setName(row.getString("TASK_NAME"));
            task.setObjects(this.getNullOnValue(row.getInteger("TASK_NUM_OBJECTS"), 0));
            task.setOutlineLevel(row.getInteger("TASK_OUTLINE_LEVEL"));
            task.setOutlineNumber(row.getString("TASK_OUTLINE_NUM"));
            task.setOverAllocated(row.getBoolean("TASK_IS_OVERALLOCATED"));
            task.setOvertimeCost(row.getCurrency("TASK_OVT_COST"));
            task.setPercentageComplete(row.getDouble("TASK_PCT_COMP"));
            task.setPercentageWorkComplete(row.getDouble("TASK_PCT_WORK_COMP"));
            task.setPreleveledFinish(row.getDate("TASK_PRELEVELED_FINISH"));
            task.setPreleveledStart(row.getDate("TASK_PRELEVELED_START"));
            task.setPriority(Priority.getInstance(row.getInt("TASK_PRIORITY")));
            task.setRecurring(row.getBoolean("TASK_IS_RECURRING"));
            task.setRegularWork(row.getDuration("TASK_REG_WORK"));
            task.setRemainingCost(row.getCurrency("TASK_REM_COST"));
            task.setRemainingDuration(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TASK_REM_DUR"), timeUnit));
            task.setRemainingOvertimeCost(row.getCurrency("TASK_REM_OVT_COST"));
            task.setRemainingOvertimeWork(row.getDuration("TASK_REM_OVT_WORK"));
            task.setRemainingWork(row.getDuration("TASK_REM_WORK"));
            task.setResume(row.getDate("TASK_RESUME_DATE"));
            task.setRollup(row.getBoolean("TASK_IS_ROLLED_UP"));
            task.setStart(row.getDate("TASK_START_DATE"));
            task.setStop(row.getDate("TASK_STOP_DATE"));
            task.setSummary(row.getBoolean("TASK_IS_SUMMARY"));
            task.setType(TaskType.getInstance(row.getInt("TASK_TYPE")));
            task.setUniqueID(n);
            task.setWBS(row.getString("TASK_WBS"));
            task.setWork(row.getDuration("TASK_WORK"));
            String string = row.getString("TASK_RTF_NOTES");
            if (string != null) {
                if (!this.m_preserveNoteFormatting) {
                    string = this.m_rtf.strip(string);
                }
                task.setNotes(string);
            }
            if (task.getCost() != null && task.getBaselineCost() != null) {
                task.setCostVariance(NumberUtility.getDouble(task.getCost().doubleValue() - task.getBaselineCost().doubleValue()));
            }
            task.setFlag1(false);
            task.setFlag2(false);
            task.setFlag3(false);
            task.setFlag4(false);
            task.setFlag5(false);
            task.setFlag6(false);
            task.setFlag7(false);
            task.setFlag8(false);
            task.setFlag9(false);
            task.setFlag10(false);
            if (task.getWBS() != null) {
                this.m_autoWBS = false;
            }
            if (task.getName() == null && task.getStart() == null && task.getFinish() == null) {
                task.setNull(true);
            }
            this.m_project.fireTaskReadEvent(task);
        }
    }

    protected void processTaskBaseline(Row row) {
        Integer n = row.getInteger("TASK_UID");
        Task task = this.m_project.getTaskByUniqueID(n);
        if (task != null) {
            int n2 = row.getInt("TB_BASE_NUM");
            task.setBaselineDuration(n2, MPDUtility.getAdjustedDuration(this.m_project, row.getInt("TB_BASE_DUR"), MPDUtility.getDurationTimeUnits(row.getInt("TB_BASE_DUR_FMT"))));
            task.setBaselineStart(n2, row.getDate("TB_BASE_START"));
            task.setBaselineFinish(n2, row.getDate("TB_BASE_FINISH"));
            task.setBaselineWork(n2, row.getDuration("TB_BASE_WORK"));
            task.setBaselineCost(n2, row.getCurrency("TB_BASE_COST"));
        }
    }

    protected void processLink(Row row) {
        Task task = this.m_project.getTaskByUniqueID(row.getInteger("LINK_PRED_UID"));
        Task task2 = this.m_project.getTaskByUniqueID(row.getInteger("LINK_SUCC_UID"));
        if (task != null && task2 != null) {
            RelationType relationType = RelationType.getInstance(row.getInt("LINK_TYPE"));
            TimeUnit timeUnit = MPDUtility.getDurationTimeUnits(row.getInt("LINK_LAG_FMT"));
            Duration duration = MPDUtility.getDuration(row.getDouble("LINK_LAG"), timeUnit);
            Relation relation = task2.addPredecessor(task, relationType, duration);
            this.m_project.fireRelationReadEvent(relation);
        }
    }

    protected void processAssignment(Row row) {
        Resource resource = this.m_project.getResourceByUniqueID(row.getInteger("RES_UID"));
        Task task = this.m_project.getTaskByUniqueID(row.getInteger("TASK_UID"));
        if (task != null && resource != null) {
            ResourceAssignment resourceAssignment = task.addResourceAssignment(resource);
            this.m_assignmentMap.put(row.getInteger("ASSN_UID"), resourceAssignment);
            resourceAssignment.setActualCost(row.getCurrency("ASSN_ACT_COST"));
            resourceAssignment.setActualFinish(row.getDate("ASSN_ACT_FINISH"));
            resourceAssignment.setActualOvertimeCost(row.getCurrency("ASSN_ACT_OVT_COST"));
            resourceAssignment.setActualOvertimeWork(row.getDuration("ASSN_ACT_OVT_WORK"));
            resourceAssignment.setActualStart(row.getDate("ASSN_ACT_START"));
            resourceAssignment.setActualWork(row.getDuration("ASSN_ACT_WORK"));
            resourceAssignment.setACWP(row.getCurrency("ASSN_ACWP"));
            resourceAssignment.setBaselineCost(row.getCurrency("ASSN_BASE_COST"));
            resourceAssignment.setBaselineFinish(row.getDate("ASSN_BASE_FINISH"));
            resourceAssignment.setBaselineStart(row.getDate("ASSN_BASE_START"));
            resourceAssignment.setBaselineWork(row.getDuration("ASSN_BASE_WORK"));
            resourceAssignment.setBCWP(row.getCurrency("ASSN_BCWP"));
            resourceAssignment.setBCWS(row.getCurrency("ASSN_BCWS"));
            resourceAssignment.setCost(row.getCurrency("ASSN_COST"));
            resourceAssignment.setCostRateTableIndex(row.getInt("ASSN_COST_RATE_TABLE"));
            resourceAssignment.setDelay(row.getDuration("ASSN_DELAY"));
            resourceAssignment.setFinish(row.getDate("ASSN_FINISH_DATE"));
            resourceAssignment.setFinishVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_FINISH_VAR"), TimeUnit.DAYS));
            resourceAssignment.setLevelingDelay(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_LEVELING_DELAY"), MPDUtility.getDurationTimeUnits(row.getInt("ASSN_DELAY_FMT"))));
            resourceAssignment.setLinkedFields(row.getBoolean("ASSN_HAS_LINKED_FIELDS"));
            resourceAssignment.setOvertimeWork(row.getDuration("ASSN_OVT_WORK"));
            resourceAssignment.setRemainingCost(row.getCurrency("ASSN_REM_COST"));
            resourceAssignment.setRemainingOvertimeCost(row.getCurrency("ASSN_REM_OVT_COST"));
            resourceAssignment.setRemainingOvertimeWork(row.getDuration("ASSN_REM_OVT_WORK"));
            resourceAssignment.setRegularWork(row.getDuration("ASSN_REG_WORK"));
            resourceAssignment.setRemainingWork(row.getDuration("ASSN_REM_WORK"));
            resourceAssignment.setResponsePending(row.getBoolean("ASSN_RESPONSE_PENDING"));
            resourceAssignment.setStart(row.getDate("ASSN_START_DATE"));
            resourceAssignment.setStartVariance(MPDUtility.getAdjustedDuration(this.m_project, row.getInt("ASSN_START_VAR"), TimeUnit.DAYS));
            resourceAssignment.setTeamStatusPending(row.getBoolean("ASSN_TEAM_STATUS_PENDING"));
            resourceAssignment.setUniqueID(row.getInteger("ASSN_UID"));
            resourceAssignment.setUnits(row.getDouble("ASSN_UNITS") * 100.0);
            resourceAssignment.setUpdateNeeded(row.getBoolean("ASSN_UPDATE_NEEDED"));
            resourceAssignment.setWork(row.getDuration("ASSN_WORK"));
            resourceAssignment.setWorkContour(WorkContour.getInstance(row.getInt("ASSN_WORK_CONTOUR")));
            String string = row.getString("ASSN_RTF_NOTES");
            if (string != null) {
                if (!this.m_preserveNoteFormatting) {
                    string = this.m_rtf.strip(string);
                }
                resourceAssignment.setNotes(string);
            }
            this.m_project.fireAssignmentReadEvent(resourceAssignment);
        }
    }

    protected void processAssignmentBaseline(Row row) {
        Integer n = row.getInteger("ASSN_UID");
        ResourceAssignment resourceAssignment = this.m_assignmentMap.get(n);
        if (resourceAssignment != null) {
            int n2 = row.getInt("AB_BASE_NUM");
            resourceAssignment.setBaselineStart(n2, row.getDate("AB_BASE_START"));
            resourceAssignment.setBaselineFinish(n2, row.getDate("AB_BASE_FINISH"));
            resourceAssignment.setBaselineWork(n2, row.getDuration("AB_BASE_WORK"));
            resourceAssignment.setBaselineCost(n2, row.getCurrency("AB_BASE_COST"));
        }
    }

    protected void postProcessing() {
        this.m_project.setAutoWBS(this.m_autoWBS);
        this.m_project.setAutoOutlineNumber(true);
        this.m_project.updateStructure();
        this.m_project.setAutoOutlineNumber(false);
        for (Task task : this.m_project.getAllTasks()) {
            task.setSummary(task.getChildTasks().size() != 0);
        }
        this.m_project.updateUniqueCounters();
    }

    private Integer getNullOnValue(Integer n, int n2) {
        return NumberUtility.getInt(n) == n2 ? null : n;
    }

    public Double getDefaultOnNull(Double d, Double d2) {
        return d == null ? d2 : d;
    }

    public Integer getDefaultOnNull(Integer n, Integer n2) {
        return n == null ? n2 : n;
    }

    public void setProjectID(Integer n) {
        this.m_projectID = n;
    }

    public void setPreserveNoteFormatting(boolean bl) {
        this.m_preserveNoteFormatting = bl;
    }
}

