/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.FieldContainer;
import net.sf.mpxj.FieldType;
import net.sf.mpxj.GraphicalIndicatorCriteria;
import net.sf.mpxj.Task;
import net.sf.mpxj.utility.NumberUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicalIndicator {
    private FieldType m_fieldType;
    private boolean m_displayGraphicalIndicators;
    private boolean m_summaryRowsInheritFromNonSummaryRows;
    private boolean m_projectSummaryInheritsFromSummaryRows;
    private boolean m_showDataValuesInToolTips;
    private List<GraphicalIndicatorCriteria> m_nonSummaryRowCriteria = new LinkedList<GraphicalIndicatorCriteria>();
    private List<GraphicalIndicatorCriteria> m_summaryRowCriteria = new LinkedList<GraphicalIndicatorCriteria>();
    private List<GraphicalIndicatorCriteria> m_projectSummaryCriteria = new LinkedList<GraphicalIndicatorCriteria>();

    public int evaluate(FieldContainer fieldContainer) {
        GraphicalIndicatorCriteria graphicalIndicatorCriteria;
        Task task;
        List<GraphicalIndicatorCriteria> list = fieldContainer instanceof Task ? (NumberUtility.getInt((task = (Task)fieldContainer).getUniqueID()) == 0 ? (!this.m_projectSummaryInheritsFromSummaryRows ? this.m_projectSummaryCriteria : (!this.m_summaryRowsInheritFromNonSummaryRows ? this.m_summaryRowCriteria : this.m_nonSummaryRowCriteria)) : (task.getSummary() ? (!this.m_summaryRowsInheritFromNonSummaryRows ? this.m_summaryRowCriteria : this.m_nonSummaryRowCriteria) : this.m_nonSummaryRowCriteria)) : this.m_nonSummaryRowCriteria;
        int n = -1;
        Iterator<GraphicalIndicatorCriteria> iterator = list.iterator();
        while (iterator.hasNext() && (n = (graphicalIndicatorCriteria = iterator.next()).evaluate(fieldContainer)) == -1) {
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public void setFieldType(FieldType fieldType) {
        this.m_fieldType = fieldType;
    }

    public FieldType getFieldType() {
        return this.m_fieldType;
    }

    public boolean getDisplayGraphicalIndicators() {
        return this.m_displayGraphicalIndicators;
    }

    public void setDisplayGraphicalIndicators(boolean bl) {
        this.m_displayGraphicalIndicators = bl;
    }

    public List<GraphicalIndicatorCriteria> getNonSummaryRowCriteria() {
        return this.m_nonSummaryRowCriteria;
    }

    public List<GraphicalIndicatorCriteria> getProjectSummaryCriteria() {
        return this.m_projectSummaryCriteria;
    }

    public List<GraphicalIndicatorCriteria> getSummaryRowCriteria() {
        return this.m_summaryRowCriteria;
    }

    public boolean getProjectSummaryInheritsFromSummaryRows() {
        return this.m_projectSummaryInheritsFromSummaryRows;
    }

    public void setProjectSummaryInheritsFromSummaryRows(boolean bl) {
        this.m_projectSummaryInheritsFromSummaryRows = bl;
    }

    public boolean getSummaryRowsInheritFromNonSummaryRows() {
        return this.m_summaryRowsInheritFromNonSummaryRows;
    }

    public void setSummaryRowsInheritFromNonSummaryRows(boolean bl) {
        this.m_summaryRowsInheritFromNonSummaryRows = bl;
    }

    public boolean getShowDataValuesInToolTips() {
        return this.m_showDataValuesInToolTips;
    }

    public void setShowDataValuesInToolTips(boolean bl) {
        this.m_showDataValuesInToolTips = bl;
    }

    public void addNonSummaryRowCriteria(GraphicalIndicatorCriteria graphicalIndicatorCriteria) {
        this.m_nonSummaryRowCriteria.add(graphicalIndicatorCriteria);
    }

    public void addSummaryRowCriteria(GraphicalIndicatorCriteria graphicalIndicatorCriteria) {
        this.m_summaryRowCriteria.add(graphicalIndicatorCriteria);
    }

    public void addProjectSummaryCriteria(GraphicalIndicatorCriteria graphicalIndicatorCriteria) {
        this.m_projectSummaryCriteria.add(graphicalIndicatorCriteria);
    }

    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        printWriter.println("[GraphicalIndicator");
        printWriter.println(" FieldType=" + this.m_fieldType);
        printWriter.println(" DisplayGraphicalIndicators=" + this.m_displayGraphicalIndicators);
        printWriter.println(" SummaryRowsInheritFromNonSummaryRows=" + this.m_summaryRowsInheritFromNonSummaryRows);
        printWriter.println(" ProjectSummaryInheritsFromSummaryRows=" + this.m_projectSummaryInheritsFromSummaryRows);
        printWriter.println(" ShowDataValuesInToolTips=" + this.m_showDataValuesInToolTips);
        printWriter.println(" NonSummaryRowCriteria=");
        for (GraphicalIndicatorCriteria graphicalIndicatorCriteria : this.m_nonSummaryRowCriteria) {
            printWriter.println("  " + graphicalIndicatorCriteria);
        }
        printWriter.println(" SummaryRowCriteria=");
        for (GraphicalIndicatorCriteria graphicalIndicatorCriteria : this.m_summaryRowCriteria) {
            printWriter.println("  " + graphicalIndicatorCriteria);
        }
        printWriter.println(" ProjectSummaryCriteria=");
        for (GraphicalIndicatorCriteria graphicalIndicatorCriteria : this.m_projectSummaryCriteria) {
            printWriter.println("  " + graphicalIndicatorCriteria);
        }
        printWriter.println("]");
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }
}

