/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import net.sf.mpxj.ProjectHeader;
import net.sf.mpxj.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Duration
implements Comparable<Duration> {
    private double m_duration;
    private TimeUnit m_units;
    private static final Duration[] ZERO_DURATIONS = new Duration[]{new Duration(0, TimeUnit.MINUTES), new Duration(0, TimeUnit.HOURS), new Duration(0, TimeUnit.DAYS), new Duration(0, TimeUnit.WEEKS), new Duration(0, TimeUnit.MONTHS), new Duration(0, TimeUnit.YEARS), new Duration(0, TimeUnit.PERCENT), new Duration(0, TimeUnit.ELAPSED_MINUTES), new Duration(0, TimeUnit.ELAPSED_HOURS), new Duration(0, TimeUnit.ELAPSED_DAYS), new Duration(0, TimeUnit.ELAPSED_WEEKS), new Duration(0, TimeUnit.ELAPSED_MONTHS), new Duration(0, TimeUnit.ELAPSED_YEARS), new Duration(0, TimeUnit.ELAPSED_PERCENT)};

    private Duration(double d, TimeUnit timeUnit) {
        this.m_duration = d;
        this.m_units = timeUnit;
    }

    private Duration(int n, TimeUnit timeUnit) {
        this.m_duration = n;
        this.m_units = timeUnit;
    }

    public double getDuration() {
        return this.m_duration;
    }

    public TimeUnit getUnits() {
        return this.m_units;
    }

    public Duration convertUnits(TimeUnit timeUnit, ProjectHeader projectHeader) {
        return Duration.convertUnits(this.m_duration, this.m_units, timeUnit, projectHeader);
    }

    public static Duration convertUnits(double d, TimeUnit timeUnit, TimeUnit timeUnit2, ProjectHeader projectHeader) {
        return Duration.convertUnits(d, timeUnit, timeUnit2, projectHeader.getMinutesPerDay().doubleValue(), projectHeader.getMinutesPerWeek().doubleValue(), projectHeader.getDaysPerMonth().doubleValue());
    }

    public static Duration convertUnits(double d, TimeUnit timeUnit, TimeUnit timeUnit2, double d2, double d3, double d4) {
        switch (timeUnit) {
            case YEARS: {
                d *= d3 * 52.0;
                break;
            }
            case ELAPSED_YEARS: {
                d *= 524160.0;
                break;
            }
            case MONTHS: {
                d *= d2 * d4;
                break;
            }
            case ELAPSED_MONTHS: {
                d *= 43200.0;
                break;
            }
            case WEEKS: {
                d *= d3;
                break;
            }
            case ELAPSED_WEEKS: {
                d *= 10080.0;
                break;
            }
            case DAYS: {
                d *= d2;
                break;
            }
            case ELAPSED_DAYS: {
                d *= 1440.0;
                break;
            }
            case HOURS: 
            case ELAPSED_HOURS: {
                d *= 60.0;
                break;
            }
        }
        if (timeUnit2 != TimeUnit.MINUTES && timeUnit2 != TimeUnit.ELAPSED_MINUTES) {
            switch (timeUnit2) {
                case HOURS: 
                case ELAPSED_HOURS: {
                    d /= 60.0;
                    break;
                }
                case DAYS: {
                    if (d2 != 0.0) {
                        d /= d2;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case ELAPSED_DAYS: {
                    d /= 1440.0;
                    break;
                }
                case WEEKS: {
                    if (d3 != 0.0) {
                        d /= d3;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case ELAPSED_WEEKS: {
                    d /= 10080.0;
                    break;
                }
                case MONTHS: {
                    if (d2 != 0.0 && d4 != 0.0) {
                        d /= d2 * d4;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case ELAPSED_MONTHS: {
                    d /= 43200.0;
                    break;
                }
                case YEARS: {
                    if (d3 != 0.0) {
                        d /= d3 * 52.0;
                        break;
                    }
                    d = 0.0;
                    break;
                }
                case ELAPSED_YEARS: {
                    d /= 524160.0;
                    break;
                }
            }
        }
        return Duration.getInstance(d, timeUnit2);
    }

    public static Duration getInstance(double d, TimeUnit timeUnit) {
        Duration duration = d == 0.0 ? ZERO_DURATIONS[timeUnit.getValue()] : new Duration(d, timeUnit);
        return duration;
    }

    public static Duration getInstance(int n, TimeUnit timeUnit) {
        Duration duration = n == 0 ? ZERO_DURATIONS[timeUnit.getValue()] : new Duration(n, timeUnit);
        return duration;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Duration) {
            Duration duration = (Duration)object;
            bl = this.m_duration == duration.m_duration && this.m_units == duration.m_units;
        }
        return bl;
    }

    public int hashCode() {
        return this.m_units.getValue() + (int)this.m_duration;
    }

    @Override
    public int compareTo(Duration duration) {
        if (this.m_units != duration.m_units) {
            duration = Duration.convertUnits(duration.m_duration, duration.m_units, this.m_units, 480.0, 2400.0, 20.0);
        }
        return this.m_duration < duration.m_duration ? -1 : (this.m_duration == duration.m_duration ? 0 : 1);
    }

    public String toString() {
        return this.m_duration + this.m_units.toString();
    }
}

