/*
 * Decompiled with CFR 0.152.
 */
package com.projity.server.data.mspdi;

import com.projity.association.AssociationList;
import com.projity.configuration.Settings;
import com.projity.contrib.util.Log;
import com.projity.contrib.util.LogFactory;
import com.projity.exchange.ImportedCalendarService;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.calendar.CalendarService;
import com.projity.pm.resource.ResourceImpl;
import com.projity.pm.snapshot.Snapshottable;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.TaskSnapshot;
import com.projity.server.data.MPXConverter;
import com.projity.server.data.mspdi.TimephasedConsumer;
import com.projity.server.data.mspdi.TimephasedService;
import com.projity.util.DateTime;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;
import net.sf.mpxj.ResourceAssignment;
import net.sf.mpxj.Task;
import net.sf.mpxj.mspdi.DatatypeConverter;
import net.sf.mpxj.mspdi.MSPDIWriter;
import net.sf.mpxj.mspdi.schema.Project;
import net.sf.mpxj.mspdi.schema.TimephasedDataType;

public class ModifiedMSPDIWriter
extends MSPDIWriter {
    static Log log = LogFactory.getLog(ModifiedMSPDIWriter.class);
    protected com.projity.pm.task.Project projityProject;
    protected Map projityTaskMap = new HashMap();
    protected Map projityAssignmentMap = new HashMap();
    protected Map projitySnapshotIdMap = new HashMap();
    protected Map timephasedMap = new HashMap();
    private static Resource UNASSIGNED = null;

    protected Boolean formatOutput() {
        return Boolean.FALSE;
    }

    public void setProjectFile(ProjectFile projectFile) {
        this.m_projectFile = projectFile;
    }

    private Resource unassignedResource() {
        if (UNASSIGNED == null) {
            UNASSIGNED = this.m_projectFile.addResource();
            UNASSIGNED.setUniqueID(-65535);
        }
        return UNASSIGNED;
    }

    protected void writeProjectCalendar(Project project) {
        int n = 1;
        ProjectCalendar projectCalendar = ImportedCalendarService.getInstance().findExportedCalendar(CalendarService.findBaseCalendar(this.m_projectFile.getProjectHeader().getCalendarName()));
        if (projectCalendar != null) {
            n = projectCalendar.getUniqueID();
        } else {
            log.warn("EXPORT: Could not export project calendar: Project: " + this.m_projectFile.getProjectHeader().getName() + " calendar " + this.m_projectFile.getProjectHeader().getCalendarName());
        }
        project.setCalendarUID(BigInteger.valueOf(n));
    }

    protected void writeResources(Project project) {
        Project.Resources resources = this.m_factory.createProjectResources();
        project.setResources(resources);
        List<Project.Resources.Resource> list = resources.getResource();
        for (Resource resource : this.m_projectFile.getAllResources()) {
            if (resource.getUniqueID() == -65535) continue;
            list.add(this.writeResource(resource));
        }
    }

    protected Project.Tasks.Task writeTask(Task task) {
        Number number = task.getFixedCost();
        if (number == null || Double.isNaN(number.doubleValue())) {
            task.setFixedCost(null);
        }
        Project.Tasks.Task task2 = super.writeTask(task);
        if (!task.getNull()) {
            this.writeTaskBaselinesAndTimephased(task2, task);
        }
        return task2;
    }

    protected Project.Assignments.Assignment writeAssignment(ResourceAssignment resourceAssignment) {
        Project.Assignments.Assignment assignment = super.writeAssignment(resourceAssignment);
        if (resourceAssignment.getResourceUniqueID() == 0) {
            assignment.setResourceUID(BigInteger.valueOf(-65535L));
        }
        Assignment assignment2 = (Assignment)this.projityAssignmentMap.get(resourceAssignment);
        GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
        gregorianCalendar.setTimeInMillis(assignment2.getStop());
        assignment.setStop(gregorianCalendar);
        GregorianCalendar gregorianCalendar2 = DateTime.calendarInstance();
        gregorianCalendar2.setTimeInMillis(assignment2.getResume());
        assignment.setResume(gregorianCalendar2);
        this.writeAssigmentBaselinesAndTimephased(assignment, resourceAssignment, assignment2.getStart(), assignment2.getFinish());
        return assignment;
    }

    public void setProjityProject(com.projity.pm.task.Project project) {
        this.projityProject = project;
    }

    public void putProjityTaskMap(Object object, Object object2) {
        this.projityTaskMap.put(object, object2);
    }

    public void putProjityAssignmentMap(Object object, Object object2) {
        this.projityAssignmentMap.put(object, object2);
    }

    public void putProjitySnapshotIdMap(Object object, Object object2) {
        this.projitySnapshotIdMap.put(object, object2);
    }

    public void putTimephasedList(Object object, Object object2) {
        if (object == null || object2 == null) {
            return;
        }
        this.timephasedMap.put(object, object2);
    }

    public List getTimephasedList(Object object) {
        return (List)this.timephasedMap.get(object);
    }

    public Resource getResourceByUniqueID(int n) {
        Resource resource = n == -65535 ? this.unassignedResource() : this.m_projectFile.getResourceByUniqueID(n);
        return resource;
    }

    private void writeTaskBaselinesAndTimephased(Project.Tasks.Task task, Task task2) {
        List<Project.Tasks.Task.Baseline> list = task.getBaseline();
        NormalTask normalTask = (NormalTask)this.projityTaskMap.get(task2);
        if (normalTask == null) {
            return;
        }
        for (int i = 0; i < Settings.numBaselines(); ++i) {
            AssociationList associationList;
            TaskSnapshot taskSnapshot;
            if (i == Snapshottable.CURRENT || (taskSnapshot = (TaskSnapshot)normalTask.getSnapshot(new Integer(i))) == null || (associationList = taskSnapshot.getHasAssignments().getAssignments()).size() <= 0) continue;
            for (Assignment assignment : associationList) {
                ResourceImpl resourceImpl = (ResourceImpl)assignment.getResource();
                if (resourceImpl.isDefault()) continue;
                Project.Assignments.Assignment.Baseline baseline = this.m_factory.createProjectAssignmentsAssignmentBaseline();
                baseline.setNumber(i + "");
                baseline.setStart(MPXConverter.dateToXMLString(DateTime.fromGmt(normalTask.getBaselineStart(i))));
                baseline.setFinish(MPXConverter.dateToXMLString(DateTime.fromGmt(normalTask.getBaselineFinish(i))));
                baseline.setWork(DatatypeConverter.printDuration(this, MPXConverter.toMPXDuration((long)normalTask.getBaselineWork(i))));
                list.add((Project.Tasks.Task.Baseline)((Object)baseline));
            }
        }
    }

    private void writeAssigmentBaselinesAndTimephased(final Project.Assignments.Assignment assignment, ResourceAssignment resourceAssignment, final long l, long l2) {
        int n = (Integer)this.projitySnapshotIdMap.get(resourceAssignment);
        Assignment assignment2 = (Assignment)this.projityAssignmentMap.get(resourceAssignment);
        final List<TimephasedDataType> list = assignment.getTimephasedData();
        final long[] lArray = new long[]{-1L};
        TimephasedService.getInstance().consumeTimephased(assignment2, new TimephasedConsumer(){

            public void consumeTimephased(Object object) {
                TimephasedDataType timephasedDataType = (TimephasedDataType)object;
                if (lArray[0] == -1L) {
                    lArray[0] = timephasedDataType.getStart().getTimeInMillis() < l ? l - timephasedDataType.getStart().getTimeInMillis() : 0L;
                }
                if (lArray[0] > 0L) {
                    timephasedDataType.getStart().setTimeInMillis(timephasedDataType.getStart().getTimeInMillis() + lArray[0]);
                    timephasedDataType.getFinish().setTimeInMillis(timephasedDataType.getFinish().getTimeInMillis() + lArray[0]);
                }
                ((TimephasedDataType)object).setUID(assignment.getUID());
                list.add(object);
            }

            public boolean acceptValue(double d) {
                return d != 0.0;
            }
        }, this.m_factory);
    }

    public ProjectFile getProjectFile() {
        return this.m_projectFile;
    }
}

