/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.pm.graphic.timescale.ScaledComponent;
import com.projity.pm.graphic.views.SplittedView;
import com.projity.pm.graphic.views.synchro.Synchronizer;
import com.projity.timescale.TimeScaleEvent;
import com.projity.timescale.TimeScaleListener;
import com.projity.workspace.SavableToWorkspace;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JViewport;

public class MainView
extends JSplitPane
implements TimeScaleListener,
SavableToWorkspace {
    private static final long serialVersionUID = -6427979080094712783L;
    protected int defaultDividerSize;
    protected double defaultDividerLocation = 0.7;
    private Synchronizer synchronizer;

    public MainView() {
        super(0);
        this.setOneTouchExpandable(true);
        this.defaultDividerSize = this.getDividerSize();
        this.setDividerSize(0);
    }

    public void setTop(Component component) {
        if (component == null) {
            return;
        }
        Component component2 = this.getBottomComponent();
        if (component2 != null) {
            this.setDividerSize(this.defaultDividerSize);
            this.setDividerLocation(this.defaultDividerLocation);
        }
        if (component instanceof SplittedView) {
            ((SplittedView)component).setParentView(this);
        }
        this.setTopComponent(component);
        if (this.viewsSynchronizable()) {
            if (component2 == null) {
                ((SplittedView)component).setDividerLocation(((SplittedView)component2).getDividerLocation());
            } else {
                ((SplittedView)component).setDividerLocationSilent(((SplittedView)component2).getDividerLocation() + ((SplittedView)component2).getDeltaDivider() - ((SplittedView)component).getDeltaDivider());
            }
            this.addScaledComponentsSynchro();
        }
    }

    public void setBottom(Component component) {
        if (component == null) {
            return;
        }
        Component component2 = this.getTopComponent();
        if (component2 != null) {
            this.setDividerSize(this.defaultDividerSize);
            this.setDividerLocation(this.defaultDividerLocation);
        }
        if (component instanceof SplittedView) {
            ((SplittedView)component).setParentView(this);
        }
        this.setBottomComponent(component);
        if (this.viewsSynchronizable()) {
            ((SplittedView)component).setDividerLocationSilent(((SplittedView)component2).getDividerLocation() + ((SplittedView)component2).getDeltaDivider() - ((SplittedView)component).getDeltaDivider());
            this.addScaledComponentsSynchro();
        }
    }

    public void removeTop() {
        this.removeScaledComponentsSynchro();
        this.setTopComponent(null);
        this.setDividerSize(0);
    }

    public void removeBottom() {
        this.removeScaledComponentsSynchro();
        this.setBottomComponent(null);
        this.setDividerSize(0);
    }

    public boolean viewsSynchronizable() {
        Component component = this.getTopComponent();
        Component component2 = this.getBottomComponent();
        return component != null && component2 != null && component instanceof SplittedView && component2 instanceof SplittedView;
    }

    public void addScaledComponentsSynchro() {
        if (this.viewsSynchronizable()) {
            SplittedView splittedView = (SplittedView)this.getTopComponent();
            SplittedView splittedView2 = (SplittedView)this.getBottomComponent();
            JViewport jViewport = splittedView2.rightScrollPane.getViewport();
            JViewport jViewport2 = splittedView.rightScrollPane.getViewport();
            JComponent jComponent = (JComponent)jViewport.getComponent(0);
            JComponent jComponent2 = (JComponent)jViewport2.getComponent(0);
            this.adjustSizes();
            ((ScaledComponent)((Object)jComponent2)).getCoord().addTimeScaleListener(this);
            this.synchronizer.addSynchro(splittedView.getRightScrollPane(), splittedView2.getRightScrollPane(), 1, splittedView2.isNeedVoidBar(), false);
        }
    }

    public void removeScaledComponentsSynchro() {
        if (this.viewsSynchronizable()) {
            SplittedView splittedView = (SplittedView)this.getTopComponent();
            SplittedView splittedView2 = (SplittedView)this.getBottomComponent();
            JViewport jViewport = splittedView.rightScrollPane.getViewport();
            JComponent jComponent = (JComponent)jViewport.getComponent(0);
            ((ScaledComponent)((Object)jComponent)).getCoord().removeTimeScaleListener(this);
            this.synchronizer.removeSynchro(splittedView.getRightScrollPane(), splittedView2 == null ? null : splittedView2.getRightScrollPane(), 1);
        }
    }

    public void setChildrenDividerLocation(Object object, int n) {
        int n2;
        int n3;
        SplittedView splittedView = null;
        SplittedView splittedView2 = null;
        Component component = this.getBottomComponent();
        if (component != null && component instanceof SplittedView) {
            splittedView2 = (SplittedView)component;
        }
        if ((component = this.getTopComponent()) != null && component instanceof SplittedView) {
            splittedView = (SplittedView)component;
        }
        if (splittedView == null || splittedView2 == null) {
            return;
        }
        if (splittedView2.getDeltaDivider() < splittedView.getDeltaDivider()) {
            SplittedView splittedView3 = splittedView2;
            splittedView2 = splittedView;
            splittedView = splittedView3;
        }
        int n4 = splittedView2.getDeltaDivider() - splittedView.getDeltaDivider();
        if (object == splittedView && splittedView2 != null) {
            n3 = splittedView.getMinimumDividerLocation();
            n2 = splittedView.getMaximumDividerLocation();
            if (n >= n2) {
                splittedView.setDividerLocationSilent(Integer.MAX_VALUE);
                splittedView2.setDividerLocationSilent(Integer.MAX_VALUE);
            } else if (n <= n3 + n4) {
                splittedView.setDividerLocationSilent(1 + n4);
                splittedView2.setDividerLocationSilent(1);
            } else {
                splittedView2.setDividerLocationSilent(n - n4);
            }
        }
        if (object == splittedView2 && splittedView != null) {
            n3 = splittedView2.getMinimumDividerLocation();
            n2 = splittedView2.getMaximumDividerLocation();
            if (n >= n2 - n4) {
                splittedView.setDividerLocationSilent(Integer.MAX_VALUE);
                splittedView2.setDividerLocationSilent(Integer.MAX_VALUE);
            } else if (n <= n3) {
                splittedView.setDividerLocationSilent(1 + n4);
                splittedView2.setDividerLocationSilent(1);
            } else {
                splittedView.setDividerLocationSilent(n + n4);
            }
        }
    }

    public void adjustSizes() {
        SplittedView splittedView = (SplittedView)this.getTopComponent();
        SplittedView splittedView2 = (SplittedView)this.getBottomComponent();
        JViewport jViewport = splittedView2.rightScrollPane.getViewport();
        JViewport jViewport2 = splittedView.rightScrollPane.getViewport();
        JComponent jComponent = (JComponent)jViewport.getView();
        JComponent jComponent2 = (JComponent)jViewport2.getView();
        Dimension dimension = jComponent2.getPreferredSize();
        Dimension dimension2 = jComponent.getPreferredSize();
        dimension2 = new Dimension((int)dimension.getWidth(), (int)dimension2.getHeight());
        jComponent.setPreferredSize(dimension2);
    }

    public void timeScaleChanged(TimeScaleEvent timeScaleEvent) {
        if (this.viewsSynchronizable()) {
            this.adjustSizes();
        }
    }

    public Synchronizer getSynchronizer() {
        if (this.synchronizer == null) {
            this.synchronizer = new Synchronizer();
        }
        return this.synchronizer;
    }

    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.dividerLocation = this.getDividerLocation();
        return workspace;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.setDividerLocation(workspace.dividerLocation);
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = -8129925562216728220L;
        int dividerLocation;

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }
    }
}

