/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.graphic.views;

import com.projity.graphic.configuration.GraphicConfiguration;
import com.projity.menu.MenuManager;
import com.projity.pm.graphic.chart.ChartInfo;
import com.projity.pm.graphic.chart.ChartLegend;
import com.projity.pm.graphic.chart.TimeChartPanel;
import com.projity.pm.graphic.frames.DocumentFrame;
import com.projity.pm.graphic.model.cache.NodeModelCache;
import com.projity.pm.graphic.model.cache.NodeModelCacheFactory;
import com.projity.pm.graphic.spreadsheet.SpreadSheet;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeEvent;
import com.projity.pm.graphic.spreadsheet.selection.event.SelectionNodeListener;
import com.projity.pm.graphic.timescale.CoordinatesConverter;
import com.projity.pm.graphic.timescale.ScaledScrollPane;
import com.projity.pm.graphic.views.BaseView;
import com.projity.pm.graphic.views.SplittedView;
import com.projity.pm.graphic.views.synchro.Synchronizer;
import com.projity.undo.UndoController;
import com.projity.workspace.WorkspaceSetting;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JScrollPane;
import org.apache.commons.collections.Closure;

public class ChartView
extends SplittedView
implements SelectionNodeListener,
BaseView {
    private static final long serialVersionUID = 3633037900192609747L;
    ScaledScrollPane scrollPane = null;
    ChartInfo chartInfo;
    MenuManager menuManager;
    DocumentFrame documentFrame;
    private ChartLegend chartLegend;
    private Closure transformerClosure;
    NodeModelCache cache = null;

    public ChartView(DocumentFrame documentFrame, boolean bl, MenuManager menuManager, Synchronizer synchronizer, Closure closure) {
        super(synchronizer);
        this.menuManager = menuManager;
        this.documentFrame = documentFrame;
        this.sync = false;
        this.transformerClosure = closure;
        this.chartInfo = new ChartInfo();
        this.chartInfo.setProject(documentFrame.getProject());
        this.chartInfo.setSimple(bl);
        if (!bl) {
            this.chartInfo.setCumulativeCostMode();
        }
        this.chartInfo.setChartView(this);
        this.chartInfo.setCache(this.getCache());
        this.setDeltaDivider(GraphicConfiguration.getInstance().getRowChartHeaderWidth());
        this.setNeedVoidBar(false);
    }

    public void init(CoordinatesConverter coordinatesConverter) {
        this.chartInfo.setCoord(coordinatesConverter);
        super.init();
    }

    public void cleanUp() {
        super.cleanUp();
        this.chartInfo.getCoord().removeTimeScaleListener(this.scrollPane);
        this.scrollPane = null;
        this.chartInfo = null;
        this.menuManager = null;
        this.documentFrame = null;
    }

    protected JScrollPane createLeftScrollPane() {
        this.chartLegend = new ChartLegend(this.chartInfo);
        this.chartInfo.setChartLegend(this.chartLegend);
        JScrollPane jScrollPane = new JScrollPane(this.chartLegend.createContentPanel());
        jScrollPane.getVerticalScrollBar().setUnitIncrement(20);
        return jScrollPane;
    }

    protected JScrollPane createRightScrollPane() {
        TimeChartPanel timeChartPanel = new TimeChartPanel(this.chartInfo);
        timeChartPanel.setPreferredSize(new Dimension(0, 0));
        this.chartInfo.setChartPanel(timeChartPanel);
        this.scrollPane = new ScaledScrollPane(timeChartPanel, this.chartInfo.getCoord(), this.documentFrame, 10);
        this.chartInfo.getAxisPanel().setPreferredSize(new Dimension(GraphicConfiguration.getInstance().getRowChartHeaderWidth(), (int)timeChartPanel.getPreferredSize().getHeight()));
        timeChartPanel.configureScrollPaneHeaders(this.scrollPane, this.chartInfo.getAxisPanel());
        this.chartInfo.setChartPanel(timeChartPanel);
        return this.scrollPane;
    }

    public void activateEmptyRowHeader(boolean bl) {
        this.scrollPane.activateEmptyRowHeader(bl);
    }

    public void resetScrollPane() {
        this.scrollPane.getViewport().add(this.chartInfo.getChartPanel());
    }

    public void selectionChanged(SelectionNodeEvent selectionNodeEvent) {
        this.chartInfo.selectionChanged(selectionNodeEvent);
    }

    public int getHeaderComponentHeight() {
        if (this.scrollPane == null) {
            return GraphicConfiguration.getInstance().getColumnHeaderHeight();
        }
        return this.scrollPane.getTimeScaleComponent().getHeight();
    }

    public UndoController getUndoController() {
        return null;
    }

    public void zoomIn() {
        this.chartInfo.getCoord().zoomIn();
    }

    public void zoomOut() {
        this.chartInfo.getCoord().zoomOut();
    }

    public boolean canZoomIn() {
        return this.chartInfo.getCoord().canZoomIn();
    }

    public boolean canZoomOut() {
        return this.chartInfo.getCoord().canZoomOut();
    }

    public int getScale() {
        return this.chartInfo.getCoord().getTimescaleManager().getCurrentScaleIndex();
    }

    public SpreadSheet getSpreadSheet() {
        return null;
    }

    public boolean hasNormalMinWidth() {
        return true;
    }

    public String getViewName() {
        if (this.chartInfo.isSimple()) {
            return "Histogram";
        }
        return "Charts";
    }

    public boolean showsTasks() {
        return false;
    }

    public boolean showsResources() {
        return false;
    }

    public NodeModelCache getCache() {
        if (this.cache == null) {
            this.cache = NodeModelCacheFactory.getInstance().createFilteredCache(this.documentFrame.getResourceNodeModelCache(), "Charts", this.transformerClosure);
        }
        return this.cache;
    }

    public void onActivate(boolean bl) {
    }

    public boolean isPrintable() {
        return false;
    }

    public void restoreWorkspace(WorkspaceSetting workspaceSetting, int n) {
        Workspace workspace = (Workspace)workspaceSetting;
        this.chartInfo.setRestoring(true);
        this.chartInfo.restoreWorkspace(workspace.chartInfo, n);
        this.scrollPane.restoreWorkspace(workspace.scrollPane, n);
        this.setDividerLocation(workspace.dividerLocation);
        this.chartLegend.setControlValues();
        this.chartLegend.restoreWorkspace(workspace.chartLegend, n);
        this.getLeftScrollPane().getViewport().setViewPosition(workspace.legendViewPosition);
        this.getRightScrollPane().getViewport().setViewPosition(workspace.chartViewPosition);
        this.chartInfo.setRestoring(false);
    }

    public WorkspaceSetting createWorkspace(int n) {
        Workspace workspace = new Workspace();
        workspace.chartInfo = this.chartInfo.createWorkspace(n);
        workspace.scrollPane = this.scrollPane.createWorkspace(n);
        workspace.dividerLocation = this.getDividerLocation();
        workspace.chartLegend = this.chartLegend.createWorkspace(n);
        workspace.legendViewPosition = this.getLeftScrollPane().getViewport().getViewPosition();
        workspace.chartViewPosition = this.getRightScrollPane().getViewport().getViewPosition();
        return workspace;
    }

    public boolean canScrollToTask() {
        return false;
    }

    public void scrollToTask() {
    }

    public static class Workspace
    implements WorkspaceSetting {
        private static final long serialVersionUID = 5497933936501158451L;
        WorkspaceSetting chartInfo;
        WorkspaceSetting scrollPane;
        WorkspaceSetting chartLegend;
        int dividerLocation;
        Point legendViewPosition;
        Point chartViewPosition;

        public WorkspaceSetting getChartInfo() {
            return this.chartInfo;
        }

        public void setChartInfo(WorkspaceSetting workspaceSetting) {
            this.chartInfo = workspaceSetting;
        }

        public WorkspaceSetting getScrollPane() {
            return this.scrollPane;
        }

        public void setScrollPane(WorkspaceSetting workspaceSetting) {
            this.scrollPane = workspaceSetting;
        }

        public int getDividerLocation() {
            return this.dividerLocation;
        }

        public void setDividerLocation(int n) {
            this.dividerLocation = n;
        }

        public WorkspaceSetting getChartLegend() {
            return this.chartLegend;
        }

        public void setChartLegend(WorkspaceSetting workspaceSetting) {
            this.chartLegend = workspaceSetting;
        }

        public Point getLegendViewPosition() {
            return this.legendViewPosition;
        }

        public void setLegendViewPosition(Point point) {
            this.legendViewPosition = point;
        }

        public Point getChartViewPosition() {
            return this.chartViewPosition;
        }

        public void setChartViewPosition(Point point) {
            this.chartViewPosition = point;
        }
    }
}

