/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.assignment;

import com.projity.grouping.core.Node;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.resource.Resource;
import com.projity.pm.resource.ResourcePool;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.pm.task.Task;
import com.projity.undo.NodeUndoInfo;
import com.projity.undo.ScheduleBackupEdit;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.undo.UndoableEditSupport;

public class AssignmentService {
    private static AssignmentService instance = null;

    public static AssignmentService getInstance() {
        if (instance == null) {
            instance = new AssignmentService();
        }
        return instance;
    }

    public void newAssignments(Collection collection, Collection collection2, double d, long l, Object object, boolean bl) {
        if (collection.size() == 0 || collection2.size() == 0) {
            return;
        }
        int n = 0;
        Project project = null;
        for (NormalTask normalTask : collection) {
            if (n == 0) {
                project = normalTask.getProject();
                project.beginUndoUpdate();
                n = project.fireMultipleTransaction(0, true);
                project.getUndoController().getEditSupport().postEdit(new ScheduleBackupEdit(collection, this));
            }
            boolean bl2 = !normalTask.hasRealAssignments() || !normalTask.hasLaborAssignment();
            int n2 = normalTask.getSchedulingType();
            boolean bl3 = normalTask.isEffortDriven();
            if (bl2) {
                normalTask.setSchedulingType(1);
                normalTask.setEffortDriven(false);
            }
            for (Resource resource : collection2) {
                if (null != normalTask.findAssignment(resource)) continue;
                Assignment assignment = this.newAssignment(normalTask, resource, d, 0L, object, true);
                if (resource.isLabor()) continue;
                assignment.setRateUnit(-2);
            }
            if (!bl2) continue;
            normalTask.setSchedulingType(n2);
            normalTask.setEffortDriven(bl3);
        }
        if (n != 0) {
            project.fireMultipleTransaction(n, false);
            project.endUndoUpdate();
        }
    }

    public Assignment newAssignment(NormalTask normalTask, Resource resource, double d, long l, Object object, boolean bl) {
        Assignment assignment = Assignment.getInstance((Task)normalTask, resource, d, l);
        if (!this.connect(assignment, object, bl)) {
            return null;
        }
        return assignment;
    }

    public Assignment newAssignment(NormalTask normalTask, Resource resource, double d, long l, Object object) {
        return this.newAssignment(normalTask, resource, d, l, object, true);
    }

    public boolean connect(Assignment assignment, Object object) {
        return this.connect(assignment, object, true);
    }

    public boolean connect(Assignment assignment, Object object, boolean bl) {
        return this.connect(assignment, object, new NodeUndoInfo(bl));
    }

    public boolean connect(Node node, Object object, boolean bl) {
        return this.connect((Assignment)node.getImpl(), object, new NodeUndoInfo(node, bl));
    }

    public boolean connect(Assignment assignment, Object object, NodeUndoInfo nodeUndoInfo) {
        if (!assignment.getTask().isAssignable()) {
            return false;
        }
        ((NormalTask)assignment.getTask()).addAssignment(assignment);
        assignment.getResource().addAssignment(assignment);
        if (object != null) {
            assignment.getDocument().getObjectEventManager().fireCreateEvent(object, assignment, nodeUndoInfo);
            ((ResourcePool)assignment.getResource().getDocument()).getObjectEventManager().fireCreateEvent(object, assignment, nodeUndoInfo);
        }
        return true;
    }

    public void remove(Node node, Object object, boolean bl) {
        this.remove((Assignment)node.getImpl(), true, object, new NodeUndoInfo(node, bl));
    }

    public void remove(Assignment assignment, Object object, boolean bl) {
        this.remove(assignment, true, object, new NodeUndoInfo(bl));
    }

    public void remove(Assignment assignment, boolean bl, Object object, boolean bl2) {
        this.remove(assignment, bl, object, new NodeUndoInfo(bl2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Collection collection, Object object, boolean bl) {
        Object var4_4 = null;
        for (Assignment assignment : collection) {
            this.remove(assignment, true, object, bl);
        }
    }

    public void remove(Assignment assignment, boolean bl, Object object, NodeUndoInfo nodeUndoInfo) {
        Resource resource;
        NormalTask normalTask = (NormalTask)assignment.getTask();
        if (normalTask.findAssignment(resource = assignment.getResource()) == null) {
            return;
        }
        if (bl) {
            normalTask.removeAssignment(assignment);
        }
        resource.removeAssignment(assignment);
        if (object != null) {
            if (bl) {
                assignment.getDocument().getObjectEventManager().fireDeleteEvent(object, assignment, nodeUndoInfo);
            }
            if (assignment.getResource().getDocument() != null) {
                ((ResourcePool)assignment.getResource().getDocument()).getObjectEventManager().fireDeleteEvent(object, assignment);
            }
        }
    }

    public void remove(Collection collection, Object object) {
        for (Assignment assignment : collection) {
            this.remove(assignment, true, object, null);
        }
    }

    public void remove(Collection collection, Collection collection2) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            collection2.add(iterator.next());
        }
    }

    public UndoableEditSupport getUndoableEditSupport(Assignment assignment) {
        if (assignment.getTask() == null) {
            return null;
        }
        return assignment.getTask().getProject().getUndoController().getEditSupport();
    }
}

