/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.model;

import com.projity.grouping.core.Node;
import com.projity.grouping.core.hierarchy.AbstractMutableNodeHierarchy;
import com.projity.grouping.core.model.NodeModel;
import com.projity.grouping.core.summaries.DeepChildWalker;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.key.HasId;
import com.projity.pm.task.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.Closure;

public class NodeModelUtil {
    public static boolean nodeIsSubproject(Node node) {
        Object object = node.getImpl();
        return object instanceof Task && ((Task)object).isSubproject();
    }

    public static void enumerateNonAssignments(NodeModel nodeModel) {
        DeepChildWalker.recursivelyTreatBranch(nodeModel, null, (Closure)new NonAssignmentEnumerator());
    }

    public static void dump(NodeModel nodeModel) {
        ((AbstractMutableNodeHierarchy)nodeModel.getHierarchy()).dump();
    }

    public static void dumpTask(NodeModel nodeModel) {
        NodeModelUtil.dumpTask(nodeModel, null, "");
    }

    private static void dumpTask(NodeModel nodeModel, Node node, String string) {
        List list;
        if (node != null) {
            System.out.println(string + ">" + node.toString());
        }
        if ((list = nodeModel.getChildren(node)) != null) {
            for (Node node2 : list) {
                Object object = node2.getImpl();
                if (object instanceof Task && ((Task)object).getWbsParentTask() != (node == null ? null : node.getImpl())) {
                    System.out.println("cached hierarchy error - child " + object + " cached parent" + ((Task)object).getWbsParentTask() + " parent " + node.getImpl());
                }
                NodeModelUtil.dumpTask(nodeModel, node2, string + "--");
            }
        }
    }

    public static List extractNodeList(NodeModel nodeModel, Node node) {
        ArrayList arrayList = new ArrayList();
        NodeModelUtil.extractNodeList(nodeModel, node, arrayList);
        return arrayList;
    }

    private static void extractNodeList(NodeModel nodeModel, Node node, Collection collection) {
        List list;
        if (node != null) {
            collection.add(node);
        }
        if ((list = nodeModel.getChildren(node)) != null) {
            for (Node node2 : list) {
                NodeModelUtil.extractNodeList(nodeModel, node2, collection);
            }
        }
    }

    public static void cacheWbs(NodeModel nodeModel, Node node) {
        Object object = node.getImpl();
        List list = nodeModel.getChildren(node);
        if (object instanceof Task && list != null && list.size() > 0) {
            Task task = (Task)object;
            task.setWbsChildrenNodes(list);
            for (Node node2 : list) {
                Object object2 = node2.getImpl();
                if (!(object2 instanceof Task)) continue;
                ((Task)object2).setWbsParent(task);
                NodeModelUtil.cacheWbs(nodeModel, node2);
            }
        }
    }

    public static boolean canBeChildOf(Node node, Node node2) {
        Object object = node.getImpl();
        Object object2 = node2.getImpl();
        if (NodeModelUtil.nodeIsSubproject(node)) {
            return false;
        }
        if (object instanceof Task && object2 instanceof Task) {
            return ((Task)object).getOwningProject() == ((Task)object2).getOwningProject();
        }
        return true;
    }

    static class NonAssignmentEnumerator
    implements Closure {
        int count = 0;

        NonAssignmentEnumerator() {
        }

        public void execute(Object object) {
            if (object == null) {
                return;
            }
            Object object2 = ((Node)object).getImpl();
            if (object2 != null && !(object2 instanceof Assignment)) {
                ((HasId)object2).setId(++this.count);
            }
        }
    }
}

