/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.text.DateFormatSymbols;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.nachocalendar.components.DayPanel;
import net.sf.nachocalendar.components.DayRenderer;
import net.sf.nachocalendar.components.DefaultDayRenderer;
import net.sf.nachocalendar.components.DefaultHeaderRenderer;
import net.sf.nachocalendar.components.HeaderPanel;
import net.sf.nachocalendar.components.HeaderRenderer;
import net.sf.nachocalendar.model.DataModel;

public class MonthPanel
extends JComponent {
    private DayPanel[][] paneles;
    private final int rows = 6;
    private final int cols = 7;
    private int tcols;
    private int firstday;
    private int showingmonth;
    private int showingyear;
    private Calendar calendar;
    private Calendar check;
    private Calendar navigation;
    private String[] months;
    private String[] days;
    private HeaderPanel[] weeks;
    private Date date;
    private Collection changelisteners;
    private boolean[] workingdays;
    private DayRenderer renderer;
    private HeaderPanel[] headers;
    private boolean showWeekNumber;
    private boolean showtitle;
    private JPanel centro;
    private JLabel title;
    private static final int[] MONDAYFIRST = new int[]{0, 2, 3, 4, 5, 6, 7, 1};
    private static final int[] SUNDAYFIRST = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static final int[] RESTAMONDAY = new int[]{0, 7, 1, 2, 3, 4, 5, 6};
    private int minimalDaysInFirstWeek;
    private int[] dayorder;
    private DayPanel[] daypanels;
    private boolean antiAliased;
    private boolean printMoon;
    private static final boolean[] DEFAULTWORKING = new boolean[]{false, true, true, true, true, true, true};
    private DataModel model;
    private HeaderRenderer headerRenderer;

    public MonthPanel() {
        this(false);
    }

    public MonthPanel(boolean showWeekNumber) {
        int i;
        this.showWeekNumber = showWeekNumber;
        this.daypanels = new DayPanel[42];
        this.calendar = new GregorianCalendar();
        this.calendar.set(10, 0);
        this.calendar.set(12, 0);
        this.calendar.set(14, 0);
        this.check = new GregorianCalendar();
        this.check.set(10, 0);
        this.check.set(12, 0);
        this.check.set(14, 0);
        this.navigation = new GregorianCalendar();
        this.navigation.set(10, 0);
        this.navigation.set(12, 0);
        this.navigation.set(14, 0);
        this.firstday = this.calendar.getFirstDayOfWeek();
        this.setFocusable(true);
        this.dayorder = this.firstday == 2 ? MONDAYFIRST : SUNDAYFIRST;
        this.centro = new JPanel(new BorderLayout());
        this.setLayout(new BorderLayout());
        this.add((Component)this.centro, "Center");
        this.tcols = showWeekNumber ? 8 : 7;
        this.headers = new HeaderPanel[this.tcols];
        this.centro.setLayout(new GridLayout(7, this.tcols));
        this.title = new JLabel();
        this.title.setHorizontalAlignment(0);
        this.title.setVerticalAlignment(0);
        this.add((Component)this.title, "North");
        this.title.setVisible(false);
        this.changelisteners = new ArrayList();
        this.paneles = new DayPanel[6][7];
        this.weeks = new HeaderPanel[6];
        Font f = UIManager.getDefaults().getFont("Label.font");
        if (f == null) {
            f = new Font("Times", 0, 12);
        }
        DateFormatSymbols symbols = new DateFormatSymbols();
        this.days = symbols.getShortWeekdays();
        for (i = 1; i < this.days.length; ++i) {
            this.days[i] = this.days[i].substring(0, 1).toUpperCase() + this.days[i].substring(1).toLowerCase();
        }
        this.months = symbols.getMonths();
        for (i = 0; i < this.months.length - 1; ++i) {
            this.months[i] = this.months[i].substring(0, 1).toUpperCase() + this.months[i].substring(1).toLowerCase();
        }
        for (i = 0; i < this.tcols; ++i) {
            this.headers[i] = new HeaderPanel(this.headerRenderer);
            this.centro.add(this.headers[i]);
        }
        this.setHeaders();
        int index = 0;
        for (int i2 = 0; i2 < 6; ++i2) {
            for (int j = 0; j < this.tcols; ++j) {
                if (j == 0 && showWeekNumber) {
                    this.weeks[i2] = new HeaderPanel(this.headerRenderer);
                    this.centro.add(this.weeks[i2]);
                    this.weeks[i2].setValue(this.days[i2]);
                    continue;
                }
                int jj = j;
                if (showWeekNumber) {
                    jj = j - 1;
                }
                this.paneles[i2][jj] = new DayPanel(this.renderer, index);
                this.daypanels[index] = this.paneles[i2][jj];
                ++index;
                this.centro.add(this.paneles[i2][jj]);
            }
        }
        this.setRenderer(new DefaultDayRenderer());
        this.setHeaderRenderer(new DefaultHeaderRenderer());
        this.setWorkingdays(MonthPanel.getDefaultWorking());
    }

    private void setHeaders() {
        for (int i = 0; i < this.tcols; ++i) {
            if (this.showWeekNumber) {
                this.headers[i].setValue(this.days[this.dayorder[i]]);
                continue;
            }
            this.headers[i].setValue(this.days[this.dayorder[i + 1]]);
        }
    }

    public void setDay(Date d) {
        this.setDay(d, true);
    }

    public void setMonth(Date d) {
        this.setDay(d, false);
    }

    public Date getMonth() {
        return this.date;
    }

    public void showTitle(boolean show) {
        this.showtitle = show;
        this.title.setVisible(show);
        this.doLayout();
    }

    private void setDay(Date d, boolean select) {
        if (d == null) {
            return;
        }
        this.date = d;
        boolean update = this.showingyear != this.calendar.get(1) || this.showingmonth != this.calendar.get(2);
        this.calendar.setTime(d);
        this.showingmonth = this.calendar.get(2);
        this.showingyear = this.calendar.get(1);
        this.calendar.add(6, -1 * (this.calendar.get(5) - 1));
        if (this.calendar.getFirstDayOfWeek() == 1) {
            this.calendar.add(6, -1 * (this.calendar.get(7) - 1));
        } else {
            this.calendar.add(6, -1 * (RESTAMONDAY[this.calendar.get(7)] - 1));
        }
        for (int i = 0; i < this.daypanels.length; ++i) {
            if (update) {
                Date temp = this.calendar.getTime();
                this.daypanels[i].setDate(temp);
                if (this.model != null) {
                    this.daypanels[i].setData(this.model.getData(temp));
                }
                if (this.calendar.get(2) == this.showingmonth) {
                    this.daypanels[i].setEnabled(true);
                } else {
                    this.daypanels[i].setEnabled(false);
                }
            }
            this.calendar.add(6, 1);
        }
        if (this.showtitle) {
            this.title.setText(this.months[this.showingmonth] + " " + this.showingyear);
        }
        if (this.showWeekNumber) {
            if (this.minimalDaysInFirstWeek != 0) {
                this.calendar.setMinimalDaysInFirstWeek(this.minimalDaysInFirstWeek);
            }
            this.calendar.setTime(d);
            int backToWeekStart = 0;
            int value = this.calendar.get(7);
            if (value == 1) {
                backToWeekStart = -6;
            } else if (value == 2) {
                backToWeekStart = 0;
            } else if (value == 3) {
                backToWeekStart = -1;
            } else if (value == 4) {
                backToWeekStart = -2;
            } else if (value == 5) {
                backToWeekStart = -3;
            } else if (value == 6) {
                backToWeekStart = -4;
            } else if (value == 7) {
                backToWeekStart = -5;
            }
            if (this.calendar.getFirstDayOfWeek() == 2) {
                this.calendar.add(5, backToWeekStart);
            } else {
                this.calendar.add(5, backToWeekStart - 1);
            }
            for (int i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setValue(Integer.toString(this.calendar.get(3)));
                this.calendar.add(5, 7);
            }
        }
        this.repaint();
        this.fireChangeEvent(new ChangeEvent(this));
    }

    public void refresh() {
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                if (this.model == null) continue;
                this.paneles[i][j].setData(this.model.getData(this.paneles[i][j].getDate()));
                this.paneles[i][j].setPrintMoon(this.printMoon);
            }
        }
        this.repaint();
    }

    public Date getDay() {
        return this.date;
    }

    protected void fireChangeEvent(ChangeEvent e) {
        Iterator it = this.changelisteners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }

    public DataModel getModel() {
        return this.model;
    }

    public void setModel(DataModel model) {
        this.model = model;
    }

    public DayRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(DayRenderer renderer) {
        this.renderer = renderer;
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                this.paneles[i][j].setRenderer(renderer);
            }
        }
    }

    public HeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderRenderer(HeaderRenderer headerRenderer) {
        int i;
        this.headerRenderer = headerRenderer;
        for (i = 0; i < this.headers.length; ++i) {
            this.headers[i].setRenderer(headerRenderer);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setRenderer(headerRenderer);
            }
        }
    }

    public void setMinimalDaysInFirstWeek(int number) {
        if (this.minimalDaysInFirstWeek != number) {
            this.minimalDaysInFirstWeek = number;
            this.setHeaders();
            this.setMonth(this.getMonth());
        }
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public boolean[] getWorkingdays() {
        return this.workingdays;
    }

    public void setWorkingdays(boolean[] workingdays) {
        if (workingdays == null) {
            return;
        }
        this.workingdays = workingdays;
        for (int i = 0; i < this.paneles.length; ++i) {
            for (int j = 0; j < this.paneles[i].length; ++j) {
                this.paneles[i][j].setWorking(workingdays[this.dayorder[j + 1] - 1]);
            }
        }
    }

    public int getFirstDayOfWeek() {
        return this.calendar.getFirstDayOfWeek();
    }

    public void setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek == 2 || firstDayOfWeek == 1) {
            this.calendar.setFirstDayOfWeek(firstDayOfWeek);
            this.check.setFirstDayOfWeek(firstDayOfWeek);
            this.dayorder = firstDayOfWeek == 1 ? SUNDAYFIRST : MONDAYFIRST;
            this.setHeaders();
            this.setMonth(this.getMonth());
        }
        this.setWorkingdays(this.getWorkingdays());
    }

    public static boolean[] getDefaultWorking() {
        return DEFAULTWORKING;
    }

    public void setEnabled(boolean b) {
        for (int i = 0; i < this.daypanels.length; ++i) {
            this.daypanels[i].setComponentEnabled(b);
        }
    }

    public boolean isEnabled() {
        return this.daypanels[0].isComponentEnabled();
    }

    public boolean isAntiAliased() {
        return this.antiAliased;
    }

    public void setAntiAliased(boolean antiAliased) {
        int i;
        this.antiAliased = antiAliased;
        for (i = 0; i < this.daypanels.length; ++i) {
            this.daypanels[i].setAntiAliased(antiAliased);
        }
        for (i = 0; i < this.headers.length; ++i) {
            this.headers[i].setAntiAliased(antiAliased);
        }
        if (this.showWeekNumber) {
            for (i = 0; i < this.weeks.length; ++i) {
                this.weeks[i].setAntiAliased(antiAliased);
            }
        }
        this.repaint();
    }

    protected DayPanel[] getDaypanels() {
        return this.daypanels;
    }

    protected void setDaypanels(DayPanel[] daypanels) {
        this.daypanels = daypanels;
    }

    public Date getMinDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        ((Calendar)cal).add(5, cal.get(5) * -1 + 1);
        return cal.getTime();
    }

    public Date getMaxDate() {
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(this.date);
        ((Calendar)cal).add(5, cal.get(5) * -1 + 1);
        ((Calendar)cal).add(2, 1);
        ((Calendar)cal).add(6, -1);
        return cal.getTime();
    }

    public boolean isPrintMoon() {
        return this.printMoon;
    }

    public void setPrintMoon(boolean printMoon) {
        if (this.printMoon != printMoon) {
            this.printMoon = printMoon;
            for (int i = 0; i < this.paneles.length; ++i) {
                for (int j = 0; j < this.paneles[i].length; ++j) {
                    this.paneles[i][j].setPrintMoon(printMoon);
                }
            }
        }
    }
}

