/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2007 Sun Microsystems, Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * The original contributor of this 
 *
 */
/* Generated By:JavaCC: Do not edit this line. ELParser.java */
package org.netbeans.microedition.databinding.el.parser;

import org.netbeans.microedition.databinding.el.*;

import java.io.Reader;
import java.util.Vector;

/**
 * Generated EL parser.
 * 
 * @author Nathan Abramson
 * @author Shawn Bayern
 * @author David Kaspar
 */
public class ELParser implements ELParserConstants {

  // TODO - it should accept "#", not "$"

  private ELContext context;

  private boolean firstLvalueFound = false;
  private Object lvalueBase;
  private Object lvalueProperty;

  private boolean storePointers;
  private Vector pointers;

  public ELParser (Reader reader, ELContext context, boolean storePointers) {
    this (reader);
    this.context = context;
    this.storePointers = storePointers;
    if (storePointers)
      pointers = new Vector ();
  }

  private void storePointer (Object base, Object property, boolean hasLvalueLock) {
    if (hasLvalueLock) {
      lvalueBase = base;
      lvalueProperty = property;
    }
    if (storePointers)
      pointers.addElement (context.createPointer (base, property));
  }

  private boolean grabLvalueLock () {
    boolean b = firstLvalueFound;
    firstLvalueFound = true;
    return ! b;
  }

  public Object getLastPointerBase () {
    return lvalueBase;
  }

  public Object getLastPointerProperty () {
    return lvalueProperty;
  }

  public Vector getStoredPointers () {
    return pointers;
  }

/*****************************************
 * GRAMMAR PRODUCTIONS *
 *****************************************/

/**
 *
 * Returns a String if the expression string is a single String, an
 * Expression if the expression string is a single Expression, an
 * ExpressionString if it's a mixture of both.
 **/
/*
Object ExpressionString () :
{
  Object ret = null;
  Object elem = null;
  StringBuffer buffer;
}
{
  (ret = AttrValueString () | ret = AttrValueExpression ())

  (
    (elem = AttrValueString () | elem = AttrValueExpression ()) {
      if (elems == null) {
        buffer = new StringBuffer ();
	    buffer.append (ret);
      }
      buffer.append (elem);
    }
  )*

  {
    return buffer != null ? buffer.toString () : ret;
  }
}


String AttrValueString () :
{
  Token t;
}
{
  t = <NON_EXPRESSION_TEXT>
  { return t.image; }
}


Object AttrValueExpression () :
{
  Object exp;
}
{
  <START_EXPRESSION> exp = Expression () <END_EXPRESSION>
  { return exp; }
}
*/
  final public Object Expression() throws ParseException {
  Object ret;
    ret = OrExpression();
    {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public Object OrExpression() throws ParseException {
  Object startExpression;
  Object expression;
    startExpression = AndExpression();
    label_1:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR1:
      case OR2:
        ;
        break;
      default:
        jj_la1[0] = jj_gen;
        break label_1;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR1:
        jj_consume_token(OR1);
        break;
      case OR2:
        jj_consume_token(OR2);
        break;
      default:
        jj_la1[1] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = AndExpression();
      startExpression = new Boolean (ELUtils.coerceToBoolean (startExpression) || ELUtils.coerceToBoolean (expression));
    }
    {if (true) return startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object AndExpression() throws ParseException {
  Object startExpression;
  Object expression;
    startExpression = EqualityExpression();
    label_2:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND1:
      case AND2:
        ;
        break;
      default:
        jj_la1[2] = jj_gen;
        break label_2;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND1:
        jj_consume_token(AND1);
        break;
      case AND2:
        jj_consume_token(AND2);
        break;
      default:
        jj_la1[3] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = EqualityExpression();
      startExpression = new Boolean (ELUtils.coerceToBoolean (startExpression) && ELUtils.coerceToBoolean (expression));
    }
    {if (true) return startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object EqualityExpression() throws ParseException {
  Object startExpression;
  Object expression;
  Boolean result = null;
  int operator;
    startExpression = RelationalExpression();
    label_3:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ1:
      case EQ2:
      case NE1:
      case NE2:
        ;
        break;
      default:
        jj_la1[4] = jj_gen;
        break label_3;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQ1:
      case EQ2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case EQ1:
          jj_consume_token(EQ1);
          break;
        case EQ2:
          jj_consume_token(EQ2);
          break;
        default:
          jj_la1[5] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                        operator = ELUtils.OPERATOR_EQUAL;
        break;
      case NE1:
      case NE2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NE1:
          jj_consume_token(NE1);
          break;
        case NE2:
          jj_consume_token(NE2);
          break;
        default:
          jj_la1[6] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                          operator = ELUtils.OPERATOR_NON_EQUAL;
        break;
      default:
        jj_la1[7] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = RelationalExpression();
      if (result == null)
        result = Boolean.TRUE;
      result = new Boolean (result.booleanValue () && ELUtils.applyEqualityOperator (startExpression, expression, operator));
      startExpression = expression;
    }
    {if (true) return result != null ? result : startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object RelationalExpression() throws ParseException {
  Object startExpression;
  Object expression;
  Boolean result = null;
  int operator;
    startExpression = AddExpression();
    label_4:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case GT1:
      case GT2:
      case LT1:
      case LT2:
      case LE1:
      case LE2:
      case GE1:
      case GE2:
        ;
        break;
      default:
        jj_la1[8] = jj_gen;
        break label_4;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LT1:
      case LT2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LT1:
          jj_consume_token(LT1);
          break;
        case LT2:
          jj_consume_token(LT2);
          break;
        default:
          jj_la1[9] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                        operator = ELUtils.OPERATOR_LT;
        break;
      case GT1:
      case GT2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GT1:
          jj_consume_token(GT1);
          break;
        case GT2:
          jj_consume_token(GT2);
          break;
        default:
          jj_la1[10] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                          operator = ELUtils.OPERATOR_GT;
        break;
      case GE1:
      case GE2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case GE1:
          jj_consume_token(GE1);
          break;
        case GE2:
          jj_consume_token(GE2);
          break;
        default:
          jj_la1[11] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                          operator = ELUtils.OPERATOR_GE;
        break;
      case LE1:
      case LE2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LE1:
          jj_consume_token(LE1);
          break;
        case LE2:
          jj_consume_token(LE2);
          break;
        default:
          jj_la1[12] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                          operator = ELUtils.OPERATOR_LE;
        break;
      default:
        jj_la1[13] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = AddExpression();
      if (result == null)
        result = Boolean.TRUE;
      result = new Boolean (result.booleanValue () && ELUtils.applyRelationalOperator (startExpression, expression, operator));
      startExpression = expression;
    }
    {if (true) return result != null ? result : startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object AddExpression() throws ParseException {
  Object startExpression;
  Object expression;
  int operator;
    startExpression = MultiplyExpression();
    label_5:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
      case MINUS:
        ;
        break;
      default:
        jj_la1[14] = jj_gen;
        break label_5;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
               operator = ELUtils.OPERATOR_PLUS;
        break;
      case MINUS:
        jj_consume_token(MINUS);
                  operator = ELUtils.OPERATOR_MINUS;
        break;
      default:
        jj_la1[15] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = MultiplyExpression();
      startExpression = ELUtils.applyArithmeticOperator (startExpression, expression, operator);
    }
    {if (true) return startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object MultiplyExpression() throws ParseException {
  Object startExpression;
  Object expression;
  int operator;
    startExpression = UnaryExpression();
    label_6:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
      case DIVIDE1:
      case DIVIDE2:
      case MODULUS1:
      case MODULUS2:
        ;
        break;
      default:
        jj_la1[16] = jj_gen;
        break label_6;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case MULTIPLY:
        jj_consume_token(MULTIPLY);
                   operator = ELUtils.OPERATOR_MULTIPLY;
        break;
      case DIVIDE1:
      case DIVIDE2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case DIVIDE1:
          jj_consume_token(DIVIDE1);
          break;
        case DIVIDE2:
          jj_consume_token(DIVIDE2);
          break;
        default:
          jj_la1[17] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                  operator = ELUtils.OPERATOR_DIVIDE;
        break;
      case MODULUS1:
      case MODULUS2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case MODULUS1:
          jj_consume_token(MODULUS1);
          break;
        case MODULUS2:
          jj_consume_token(MODULUS2);
          break;
        default:
          jj_la1[18] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                                    operator = ELUtils.OPERATOR_MODULUS;
        break;
      default:
        jj_la1[19] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = UnaryExpression();
      startExpression = ELUtils.applyArithmeticOperator (startExpression, expression, operator);
    }
    {if (true) return startExpression;}
    throw new Error("Missing return statement in function");
  }

  final public Object UnaryExpression() throws ParseException {
  Object expression;
  int operator;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case MINUS:
    case NOT1:
    case NOT2:
    case EMPTY:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOT1:
      case NOT2:
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NOT1:
          jj_consume_token(NOT1);
          break;
        case NOT2:
          jj_consume_token(NOT2);
          break;
        default:
          jj_la1[20] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
                          operator = ELUtils.OPERATOR_UNARY_NOT;
        break;
      case MINUS:
        jj_consume_token(MINUS);
                  operator = ELUtils.OPERATOR_UNARY_MINUS;
        break;
      case EMPTY:
        jj_consume_token(EMPTY);
                  operator = ELUtils.OPERATOR_EMPTY;
        break;
      default:
        jj_la1[21] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      expression = UnaryExpression();
      expression = ELUtils.applyUnaryOperation (expression, operator);
      break;
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case TRUE:
    case FALSE:
    case NULL:
    case LPAREN:
    case IDENTIFIER:
      expression = Value();
      break;
    default:
      jj_la1[22] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return expression;}
    throw new Error("Missing return statement in function");
  }

  final public Object Value() throws ParseException {
  Object value;
  Token t;
  boolean lvalue = false;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case TRUE:
    case FALSE:
    case NULL:
      // ValuePrefix
          value = Literal();
      break;
    case LPAREN:
      jj_consume_token(LPAREN);
      value = Expression();
      jj_consume_token(RPAREN);
      break;
    default:
      jj_la1[23] = jj_gen;
      if (jj_2_1(2147483647)) {
        value = FunctionInvocation();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case IDENTIFIER:
          // NamedValue
                  t = jj_consume_token(IDENTIFIER);
          storePointer (null, t.image, lvalue = grabLvalueLock ());
          value = context.resolveVariable (t.image);
          break;
        default:
          jj_la1[24] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    label_7:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOT:
      case LBRACKET:
        ;
        break;
      default:
        jj_la1[25] = jj_gen;
        break label_7;
      }
      value = ValueSuffix(lvalue, value);
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Object FunctionInvocation() throws ParseException {
  String qualifiedName;
  Vector argumentList = new Vector ();
  Object exp;
    qualifiedName = QualifiedName();
    jj_consume_token(LPAREN);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INTEGER_LITERAL:
    case FLOATING_POINT_LITERAL:
    case STRING_LITERAL:
    case TRUE:
    case FALSE:
    case NULL:
    case LPAREN:
    case MINUS:
    case NOT1:
    case NOT2:
    case EMPTY:
    case IDENTIFIER:
      exp = Expression();
          argumentList.addElement(exp);
      label_8:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[26] = jj_gen;
          break label_8;
        }
        jj_consume_token(COMMA);
        exp = Expression();
          argumentList.addElement(exp);
      }
      break;
    default:
      jj_la1[27] = jj_gen;
      ;
    }
    jj_consume_token(RPAREN);
    {if (true) return context.invokeFunction (qualifiedName, argumentList);}
    throw new Error("Missing return statement in function");
  }

  final public Object ValueSuffix(boolean lvalue, Object value) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case DOT:
      value = PropertySuffix(lvalue, value);
      break;
    case LBRACKET:
      value = ArraySuffix(lvalue, value);
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return value;}
    throw new Error("Missing return statement in function");
  }

  final public Object PropertySuffix(boolean lvalue, Object value) throws ParseException {
  String property;
    jj_consume_token(DOT);
    property = Identifier();
    storePointer (value, property, lvalue);
    {if (true) return context.getValue (value, property);}
    throw new Error("Missing return statement in function");
  }

  final public Object ArraySuffix(boolean lvalue, Object value) throws ParseException {
  Object index;
    jj_consume_token(LBRACKET);
    index = Expression();
    jj_consume_token(RBRACKET);
    storePointer (value, index, lvalue);
    {if (true) return context.getValue (value, index);}
    throw new Error("Missing return statement in function");
  }

  final public Object Literal() throws ParseException {
  Object ret;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
    case FALSE:
      ret = BooleanLiteral();
      break;
    case INTEGER_LITERAL:
      ret = IntegerLiteral();
      break;
    case FLOATING_POINT_LITERAL:
      ret = FloatingPointLiteral();
      break;
    case STRING_LITERAL:
      ret = StringLiteral();
      break;
    case NULL:
      ret = NullLiteral();
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return ret;}
    throw new Error("Missing return statement in function");
  }

  final public Boolean BooleanLiteral() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TRUE:
      jj_consume_token(TRUE);
           {if (true) return Boolean.TRUE;}
      break;
    case FALSE:
      jj_consume_token(FALSE);
              {if (true) return Boolean.FALSE;}
      break;
    default:
      jj_la1[30] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public String StringLiteral() throws ParseException {
  Token t;
    t = jj_consume_token(STRING_LITERAL);
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public Integer IntegerLiteral() throws ParseException {
  Token t;
    t = jj_consume_token(INTEGER_LITERAL);
    {if (true) return Integer.valueOf (t.image);}
    throw new Error("Missing return statement in function");
  }

  final public Float FloatingPointLiteral() throws ParseException {
  Token t;
    t = jj_consume_token(FLOATING_POINT_LITERAL);
    {if (true) return Float.valueOf (t.image);}
    throw new Error("Missing return statement in function");
  }

  final public Object NullLiteral() throws ParseException {
    jj_consume_token(NULL);
    {if (true) return null;}
    throw new Error("Missing return statement in function");
  }

  final public String Identifier() throws ParseException {
  Token t;
    t = jj_consume_token(IDENTIFIER);
    {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String QualifiedName() throws ParseException {
  String prefix = null, localPart = null;
    if (jj_2_2(2147483647)) {
      prefix = Identifier();
      jj_consume_token(COLON);
    } else {
      ;
    }
    localPart = Identifier();
    if (prefix == null)
      {if (true) return localPart;}
    else
     {if (true) return prefix + ":" + localPart;}
    throw new Error("Missing return statement in function");
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_1(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(0, xla); }
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    try { return !jj_3_2(); }
    catch(LookaheadSuccess ls) { return true; }
    finally { jj_save(1, xla); }
  }

  final private boolean jj_3R_10() {
    if (jj_scan_token(IDENTIFIER)) return true;
    return false;
  }

  final private boolean jj_3R_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_11()) jj_scanpos = xsp;
    if (jj_3R_10()) return true;
    return false;
  }

  final private boolean jj_3_1() {
    if (jj_3R_9()) return true;
    if (jj_scan_token(LPAREN)) return true;
    return false;
  }

  final private boolean jj_3R_11() {
    if (jj_3R_10()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_10()) return true;
    if (jj_scan_token(COLON)) return true;
    return false;
  }

  public ELParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[31];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static {
      jj_la1_0();
      jj_la1_1();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x0,0x0,0x6180000,0x180000,0x6000000,0x6180000,0x1e78000,0x60000,0x18000,0x1800000,0x600000,0x1e78000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8001d60,0x8001d60,0x0,0x80004000,0x20000000,0x8001d60,0x80004000,0x1d60,0xc00,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x3000,0x3000,0xc00,0xc00,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,0xf8,0x30,0xc0,0xf8,0x300,0x4304,0xc304,0x0,0x8000,0x0,0x0,0xc304,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[2];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public ELParser(java.io.InputStream stream) {
     this(stream, null);
  }
  public ELParser(java.io.InputStream stream, String encoding) {
    try { jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { e.printStackTrace(); throw new IllegalArgumentException(e.getMessage()); }
    token_source = new ELParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
     ReInit(stream, null);
  }
  public void ReInit(java.io.InputStream stream, String encoding) {
    try { jj_input_stream.ReInit(stream, encoding, 1, 1); } catch(java.io.UnsupportedEncodingException e) { e.printStackTrace(); throw new IllegalArgumentException(e.getMessage()); }
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ELParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new ELParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public ELParser(ELParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(ELParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 31; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  static private final class LookaheadSuccess extends java.lang.Error { }
  final private LookaheadSuccess jj_ls = new LookaheadSuccess();
  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    if (jj_scanpos.kind != kind) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) throw jj_ls;
    return false;
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration e = jj_expentries.elements(); e.hasMoreElements();) {
        int[] oldentry = (int[])(e.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[52];
    for (int i = 0; i < 52; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 31; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 52; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 2; i++) {
    try {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
          }
        }
        p = p.next;
      } while (p != null);
      } catch(LookaheadSuccess ls) { }
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
