/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.java.plugins;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.java.RetoucheUtils;
import org.netbeans.modules.refactoring.java.api.MemberInfo;
import org.netbeans.modules.refactoring.java.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.java.plugins.JavaPluginUtils;
import org.netbeans.modules.refactoring.java.plugins.PullUpTransformer;
import org.netbeans.modules.refactoring.java.plugins.PushDownRefactoringPlugin;
import org.netbeans.modules.refactoring.java.spi.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class PullUpRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PullUpRefactoring refactoring;
    private TreePathHandle treePathHandle;

    PullUpRefactoringPlugin(PullUpRefactoring pullUpRefactoring) {
        this.refactoring = pullUpRefactoring;
        this.treePathHandle = pullUpRefactoring.getSourceType();
    }

    @Override
    protected JavaSource getJavaSource(JavaRefactoringPlugin.Phase phase) {
        switch (phase) {
            default: 
        }
        return JavaSource.forFileObject((FileObject)this.treePathHandle.getFileObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem preCheck(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            Problem problem;
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            Problem problem2 = PullUpRefactoringPlugin.isElementAvail(this.treePathHandle, (CompilationInfo)compilationController);
            if (problem2 != null) {
                Problem problem3 = problem2;
                return problem3;
            }
            this.fireProgressListenerStep();
            Element element = this.treePathHandle.resolveElement((CompilationInfo)compilationController);
            problem2 = JavaPluginUtils.isSourceElement(element, (CompilationInfo)compilationController);
            if (problem2 != null) {
                Problem problem4 = problem2;
                return problem4;
            }
            if (!(element instanceof TypeElement)) {
                Problem problem5 = new Problem(true, NbBundle.getMessage(PushDownRefactoringPlugin.class, (String)"ERR_PushDown_InvalidSource", (Object)this.treePathHandle, (Object)element));
                return problem5;
            }
            TypeElement typeElement = (TypeElement)element;
            if (RetoucheUtils.getSuperTypes(typeElement, (CompilationInfo)compilationController, true).isEmpty()) {
                Problem problem6 = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoSuperTypes"));
                return problem6;
            }
            this.fireProgressListenerStep();
            for (Element element2 : typeElement.getEnclosedElements()) {
                if (element2.getKind() == ElementKind.CONSTRUCTOR) continue;
                Problem problem7 = null;
                return problem7;
            }
            if (!typeElement.getInterfaces().isEmpty()) {
                problem = null;
                return problem;
            }
            problem2 = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembers"));
            this.fireProgressListenerStep();
            problem = problem2;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    @Override
    public Problem fastCheckParameters() {
        MemberInfo<ElementHandle<? extends Element>>[] memberInfoArray = this.refactoring.getMembers();
        if (memberInfoArray.length == 0) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembersSelected"));
        }
        if (memberInfoArray.length > 1) {
            for (int i = 0; i < memberInfoArray.length - 1; ++i) {
                for (int j = i + 1; j < memberInfoArray.length; ++j) {
                    if (!memberInfoArray[i].equals(memberInfoArray[j])) continue;
                    return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_CannotPullupDuplicateMembers"));
                }
            }
        }
        if (this.refactoring.getTargetType() == null) {
            return new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoTargetType"));
        }
        Problem problem = null;
        if (this.refactoring.getTargetType().getKind().isInterface()) {
            for (MemberInfo<ElementHandle<? extends Element>> memberInfo : memberInfoArray) {
                if (memberInfo.getModifiers().contains((Object)Modifier.PUBLIC)) continue;
                problem = PullUpRefactoringPlugin.createProblem(problem, false, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullupNonPublicToInterface", (Object)memberInfo.getName()));
            }
        }
        return problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Problem checkParameters(CompilationController compilationController) throws IOException {
        this.fireProgressListenerStart(1, 4);
        try {
            compilationController.toPhase(JavaSource.Phase.RESOLVED);
            TypeElement typeElement = (TypeElement)this.refactoring.getSourceType().resolveElement((CompilationInfo)compilationController);
            Collection<TypeElement> collection = RetoucheUtils.getSuperTypes(typeElement, (CompilationInfo)compilationController);
            TypeElement typeElement2 = (TypeElement)this.refactoring.getTargetType().resolve((CompilationInfo)compilationController);
            MemberInfo<ElementHandle<? extends Element>>[] memberInfoArray = this.refactoring.getMembers();
            this.fireProgressListenerStart(2, memberInfoArray.length + 1);
            if (!collection.contains(typeElement2)) {
                Problem problem = new Problem(true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalTargetType"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = null;
            for (int i = 0; i < memberInfoArray.length; ++i) {
                Element element = memberInfoArray[i].getElementHandle().resolve((CompilationInfo)compilationController);
                if (memberInfoArray[i].getGroup() == MemberInfo.Group.IMPLEMENTS) continue;
                if (RetoucheUtils.elementExistsIn(typeElement2, element, (CompilationInfo)compilationController)) {
                    Problem problem2 = PullUpRefactoringPlugin.createProblem(problem, true, NbBundle.getMessage(PullUpRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)element.getSimpleName()));
                    return problem2;
                }
                this.fireProgressListenerStep();
            }
        }
        finally {
            this.fireProgressListenerStop();
        }
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        ClasspathInfo classpathInfo = this.getClasspathInfo(this.refactoring);
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        hashSet.addAll(RetoucheUtils.getSuperTypesFiles(this.refactoring.getSourceType()));
        hashSet.add(RetoucheUtils.getFileObject(this.treePathHandle));
        this.fireProgressListenerStart(1, hashSet.size());
        JavaRefactoringPlugin.TransformTask transformTask = new JavaRefactoringPlugin.TransformTask(this, new PullUpTransformer(this.refactoring), this.treePathHandle);
        Problem problem = this.createAndAddElements(hashSet, transformTask, refactoringElementsBag, this.refactoring, classpathInfo);
        this.fireProgressListenerStop();
        return problem;
    }

    protected FileObject getFileObject() {
        return this.treePathHandle.getFileObject();
    }
}

